package com.bxm.localnews.merchant.param.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: zhoujincheng
 * @create: 2020-08-21 10:11
 */
@Data
public class GoodsUpdateManageParam {

    @ApiModelProperty(value = "商品id",required = true)
    private Long goodsId;

    @ApiModelProperty("商品类型0单品1套餐")
    private Integer type;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("商品轮播图")
    private String headPics;

    @ApiModelProperty("原价")
    private BigDecimal originalPrice;

    @ApiModelProperty("现价")
    private BigDecimal price;

    @ApiModelProperty("佣金比例")
    private Integer commissionRate;

    @ApiModelProperty("0关闭vip折扣1开启vip折扣")
    private Integer vipDiscount;

    @ApiModelProperty("使用规则")
    private String rule;

    @ApiModelProperty("店铺详情")
    private String detail;

    @ApiModelProperty(value="库存")
    private Integer num;

    /**
     * 套餐明细
     *
     */
    @ApiModelProperty("套餐内容")
    private String setMeal;

    /**
     * 审核状态
     *
     */
    @ApiModelProperty("0:待审核 1:审核中 2: 资质审核通过 3: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("审核拒绝原因")
    private String remark;

    /**
     * 审核人id
     *
     */
    @ApiModelProperty(value = "审核人id",required = true)
    private Long userId;

}
