package com.bxm.localnews.merchant.param.goods;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 根据基础参数中的platform有额外的逻辑，如果是web（站外）则会进行特殊处理
 *
 * @author gonzo
 * @date 2020-09-05 15:33
 **/
@Data
public class QueryGoodsParam extends BasicParam {

    @ApiModelProperty(value = "商品id", required = true)
    @NotNull(message = "商品id不能为空")
    private Long goodsId;

    @ApiModelProperty(value = "用户id", required = true)
    @NotNull(message = "用户id不能为空")
    private Long userId;

    @ApiModelProperty(value = "查询类型 1: 普通商品详情查询 2: 管理商品详情查询 3: 站外查看商品详情", required = true)
    private Integer queryType = 1;
}
