package com.bxm.localnews.merchant.param.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "商户购买权益订单参数")
@Data
public class MerchantBuyOrderParam extends UserOrderParam {

    @ApiModelProperty(value = "商家id", required = true)
    private Long merchantId;

    @ApiModelProperty("0-不使用推广金 1-使用")
    private Integer usePromotion = 1;

    @ApiModelProperty("购买权益类型 0-vip 1-广告")
    private Integer type;
}

