package com.bxm.localnews.merchant.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(description = "帖子基础详情")
public class ForumBasicVo {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("发帖地址")
    private String location;

    @ApiModelProperty("帖子文本")
    private String textField;

    @ApiModelProperty("版块id")
    private Long forumId;

    @ApiModelProperty("话题id列表")
    private List<Long> topicIdList;

    @ApiModelProperty("是否新人一键发布 0不是,1是")
    private Byte isNewReport;

    @ApiModelProperty("版块内容")
    private String forumContent;

    @ApiModelProperty("封面选择")
    private Byte coverSelect;

    @ApiModelProperty("额外内容，拼接在textField后，imgList前")
    private String extraContent;

    @ApiModelProperty("帖子类型(1:普通帖子 2:小纸条)")
    private Byte postType;

    @ApiModelProperty("有效期(单位:天)")
    private Integer validDay;

    @ApiModelProperty("帖子图片数组")
    private List<PostImgVo> postImgList;

    @ApiModelProperty(value = "帖子文本是否是需要支持富文本，通过这个参数来控制当帖子文本为富文本时，content内容使用富文本的内容进行填充而不是截取html之后的内容 0:不支持 1:支持", hidden = true)
    private Byte supportRichTextField;

}
