package com.bxm.localnews.merchant.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel(description = "帖子详情")
@Data
public class ForumPostVo extends ForumBasicVo {

    @ApiModelProperty("作者头像")
    private String userImg;

    @ApiModelProperty("作者名称")
    private String userName;

    @ApiModelProperty("帖子封面图片")
    @JsonIgnore
    private String coverList;

    @ApiModelProperty("帖子内容")
    private String content;

    @ApiModelProperty("是否精华帖：0否 1是")
    private Integer isBrilliant;

    @ApiModelProperty("是否本地爆料：0否 1是")
    private Byte isBroke;

    @ApiModelProperty("是否优质头条：0否 1是")
    private Byte isRecommend;

    @ApiModelProperty("是否红色章：0否 1是")
    private Integer isRed;

    @ApiModelProperty("是否奖励现金：0否 1是")
    private Integer isCash;

    @ApiModelProperty("发布时间")
    private String displayTime;

    @ApiModelProperty("阅读数")
    private Integer clickCount;

    @ApiModelProperty("评论数")
    private Integer commentCount;

    @ApiModelProperty("更多评论数")
    private Integer moreCommentCount;

    @ApiModelProperty("分享数")
    private Integer shareCount;

    @ApiModelProperty("收藏数")
    private Integer collectCount;

    @ApiModelProperty(value = "推荐次数", hidden = true)
    private Integer recommendCount;

    @ApiModelProperty("点赞次数")
    private Integer likeCount;

    @ApiModelProperty("当前用户是否已点赞：0否 1是")
    private Integer liked;

    @ApiModelProperty("当前用户是否已收藏：0否 1是")
    private Integer collected;


    @ApiModelProperty("审核状态：1通过 2审核中 3拒绝 ... 100:限制内容被访问")
    private Integer status;

    @ApiModelProperty("帖子分享链接")
    private String shareUrl;

    @ApiModelProperty("是否强引导下载  0:否 1:是")
    private Byte isBootDownload;

    @ApiModelProperty("现金奖励金额")
    private BigDecimal cashReward;


    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("发布时间")
    private Date publishTime;

    @ApiModelProperty("展示时间")
    private Date displayDateTime;

    @ApiModelProperty("展示标签：1热 2爆")
    private Byte displayTag;

    @ApiModelProperty("剩下的评论数量，如果replyInfo为空则不用显示")
    private Integer leftRelyNum = 0;

    @ApiModelProperty("微信小程序分享url")
    private String appletShareUrl;

    @ApiModelProperty("编辑寄语")
    private String editorMessage;

    @ApiModelProperty("启用占位符 0 未启用 1启用")
    private Byte enablePlaceholder;


    @ApiModelProperty("更新时间")
    private Date modifyTime;


    @ApiModelProperty("是否用户修改")
    private Byte isUserUpdate;

    @ApiModelProperty("投放类型 0全国 1地区")
    private Integer deliveryType;

    @ApiModelProperty("到期时间")
    private Date validDate;

    @ApiModelProperty("马甲号类型 0:正常用户 1:评论马甲  2:发帖马甲 3:普通陪聊 4:地方大V 5:全国大V")
    private Byte vestType;

}
