package com.bxm.localnews.merchant.vo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.Date;

/**
 *@author: zhoujincheng
 *@create: 2020-08-04 11:17
 */
@Data
public class MerchantMemberVo{

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "商户id")
    private Long merchantId;

    @ApiModelProperty(value = "用户id")
    private Long userId;

    @ApiModelProperty(value = "用户昵称")
    private String nickName;

    @ApiModelProperty(value = "用户头像")
    private String headImg;

    @ApiModelProperty(value = "用户与商户的绑定关系,0：解除绑定，1：绑定中")
    private Integer relation;

    @ApiModelProperty(value = "用户角色,0：老板，1：员工")
    private Integer role;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @ApiModelProperty(value = "删除时间")
    private Date deleteTime;

    @ApiModelProperty(value = "是否删除,0：否，1：是")
    private Integer deleteFlag;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @ApiModelProperty(value = "绑定时间")
    private Date bindTime;

    @ApiModelProperty(value = "会员是否弹窗 0没有弹窗过1已经弹窗过")
    private Integer bindPopType;

}
