package com.bxm.localnews.merchant.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * b_merchant_withdraw_flow
 * @author
 */
@Data
public class MerchantWithdrawManageFlowVO implements Serializable {

    @ApiModelProperty("提现记录id")
    private Long id;

    @ApiModelProperty("提现订单号")
    private String orderNo;

    @ApiModelProperty("商户id")
    private Long merchantId;

    @ApiModelProperty("提现渠道 1: 微信 2: 支付宝")
    private Long payChannel;

    @ApiModelProperty("提现的账号实际姓名")
    private String realName;

    @ApiModelProperty("提现账号")
    private String payAccount;

    @ApiModelProperty("提现金额")
    private BigDecimal amount;

    @ApiModelProperty("提现手续费")
    private BigDecimal fee;

    @ApiModelProperty("提现状态 1-待审核 2-支付中 3-支付成功 4-支付失败 5-延迟审核")
    private Byte state;

    @ApiModelProperty("客户端提现ip")
    private String clientIp;

    @ApiModelProperty("设备号")
    private String equipment;

    @ApiModelProperty("第三方支付单号")
    private String paymentNo;

    @ApiModelProperty("提现成功时间")
    private String paymentTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("发起提现时间")
    private Date createTime;

    @ApiModelProperty("最后一次更新时间")
    private Date updateTime;

    @ApiModelProperty("商户名称")
    private String merchantName;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("已提现金额")
    private BigDecimal hasWithdraw;

    @ApiModelProperty("累计收入")
    private BigDecimal totalMoney;
}