package com.bxm.localnews.merchant.vo.goods;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zhoujincheng
 * @create: 2020-08-25 16:03
 */
@Data
public class GoodsListVo {
    @ApiModelProperty("商品id")
    private Long id;

    @ApiModelProperty("0:待审核 1: 资质审核通过 2: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("店铺公司名称")
    private String merchantName;

    @ApiModelProperty("行业名称")
    private String catName;

    @ApiModelProperty("原价")
    private BigDecimal originalPrice;

    @ApiModelProperty("现价")
    private BigDecimal price;

    @ApiModelProperty("库存")
    private Integer num;

    @ApiModelProperty("总量")
    private Integer totalNum;

    private Integer commissionRate;

    @ApiModelProperty("上下架状态 0：下架 1：上架")
    private Integer shelfType;

    @ApiModelProperty("商品id")
    private Long goodsId;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date createTime;

    /*
     *
     * 新增
     * */

    @ApiModelProperty("单笔分销金额")
    private BigDecimal distributionAmount;

    @ApiModelProperty("已售")
    private Integer saleNum;

    @ApiModelProperty("海报url")
    private String posterUrl;

    @ApiModelProperty("海报名称")
    private String posterName;

    @ApiModelProperty("海报上下架状态 0 下架 1 上架")
    private Byte posterStatus;

    @ApiModelProperty("关注的人数")
    private Integer gazePeopleNum;
}
