/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.dto.CreateStatusDto;
import com.bxm.localnews.merchant.dto.MerchantUserInfoDto;
import com.bxm.localnews.merchant.param.EmployeeRemoveParam;
import com.bxm.localnews.merchant.param.RemoveRecordParam;
import com.bxm.localnews.merchant.security.dto.MerchantMemberRoleDTO;
import com.bxm.localnews.merchant.security.facade.param.CreateParam;
import com.bxm.localnews.merchant.security.facade.service.MerchantMemberFacadeService;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.security.param.MerchantMemberPageParam;
import com.bxm.localnews.merchant.security.service.MerchantAuthService;
import com.bxm.localnews.merchant.security.service.MerchantMemberService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={" 11-05 \u5546\u6237\u6a21\u5757\u56e2\u961f\u7ed1\u5b9a\u5173\u7cfb\u76f8\u5173API"})
@RestController
@RequestMapping(value={"{version}/merchant/user"})
public class MerchantMemberController {
    private final MerchantMemberService merchantMemberService;
    private final MerchantMemberFacadeService merchantMemberFacadeService;
    private final MerchantAuthService merchantAuthService;

    @Autowired
    public MerchantMemberController(MerchantMemberService merchantMemberService, MerchantMemberFacadeService merchantMemberFacadeService, MerchantAuthService merchantAuthService) {
        this.merchantMemberService = merchantMemberService;
        this.merchantMemberFacadeService = merchantMemberFacadeService;
        this.merchantAuthService = merchantAuthService;
    }

    @ApiOperation(value="11-05-1 \u3010v1\u3011\u521b\u5efa\u7ed1\u5b9a\u5173\u7cfb", notes="\u8bf4\u660e\uff1a\u65b0\u589e\u4e00\u79cd\u6536\u5f92\u65b9\u5f0f\uff1a\u7ed1\u5b9a\u5458\u5de5\u6536\u5f92\u6536\u5f92\u903b\u8f91\uff1a\u7ed1\u5b9a\u7684\u5458\u5de5\u4e3a\u65b0\u7528\u6237\uff0c\u7ed1\u5b9a\u6210\u529f\u540e\uff0c\u5f92\u5f1f\u4e0b\u8f7d\u767b\u5f55\u540e\u5efa\u7acb\u5e08\u5f92\u5173\u7cfb\uff1b\u975e\u65b0\u7528\u6237\uff0c\u65e0\u5e08\u5f92\u5173\u7cfb\uff0c\u7ed1\u5b9a\u5458\u5de5\u5173\u7cfb\u4e0d\u5efa\u7acb\u5e08\u5f92\u5173\u7cfb", httpMethod="POST")
    @PostMapping(value={"/create"})
    @ApiVersion(value=1)
    public ResponseJson<CreateStatusDto> create(@RequestBody @Validated CreateParam createParam) {
        Message message = this.merchantMemberFacadeService.create(createParam);
        if (message.isSuccess()) {
            return ResponseJson.ok((Object)message.getParam("createStatusDto"));
        }
        return ResponseJson.badReqeuset((String)message.getLastMessage()).build();
    }

    @ApiOperation(value="11-05-2 \u3010v1\u3011\u89e3\u9664\u5458\u5de5\u7ed1\u5b9a\u5173\u7cfb", notes="\u89e3\u9664\u5458\u5de5\u7ed1\u5b9a\u5173\u7cfb", httpMethod="POST")
    @PostMapping(value={"/employeeRemove"})
    @ApiVersion(value=1)
    public ResponseJson remove(@RequestBody @Validated EmployeeRemoveParam employeeRemoveParam) {
        return ResponseJson.build((Message)this.merchantMemberService.remove(employeeRemoveParam));
    }

    @ApiOperation(value="11-05-3 \u3010v1\u3011\u5220\u9664\u7ed1\u5b9a\u8bb0\u5f55", notes="\u5220\u9664\u7ed1\u5b9a\u8bb0\u5f55", httpMethod="POST")
    @PostMapping(value={"/removeRecord"})
    @ApiVersion(value=1)
    public ResponseJson removeRecord(@RequestBody @Validated RemoveRecordParam removeEmployeeParam) {
        return ResponseJson.build((Message)this.merchantMemberService.removeRecord(removeEmployeeParam));
    }

    @GetMapping(value={"/getEmployeeList"})
    @ApiOperation(value="11-05-5  \u3010v1\u3011\u5458\u5de5\u5217\u8868", notes="\u5458\u5de5\u5217\u8868", httpMethod="GET")
    @ApiVersion(value=1)
    public ResponseJson<PageWarper<MerchantMemberVo>> getEmployeeList(MerchantMemberPageParam merchantMemberPageParam) {
        return ResponseJson.ok((Object)this.merchantMemberService.getEmployeeList(merchantMemberPageParam));
    }

    @ApiOperation(value="11-05-6 \u3010v1\u3011\u83b7\u53d6\u7528\u6237\u5934\u50cf\u548c\u6635\u79f0\u548c\u5e97\u94fa\u7b80\u79f0\u76f8\u5173\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u5934\u50cf\u548c\u6635\u79f0\u548c\u5e97\u94fa\u7b80\u79f0\u76f8\u5173\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"/getUserInfo"})
    @ApiVersion(value=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    public ResponseJson<MerchantUserInfoDto> getMerchantUserInfo(@RequestParam(value="userId") Long userId) {
        Message message = this.merchantMemberService.getMerchantUserInfo(userId);
        if (message.isSuccess()) {
            return ResponseJson.ok((Object)message.getParam("merchantUserInfoDto"));
        }
        return ResponseJson.badReqeuset((String)message.getLastMessage()).build();
    }

    @ApiOperation(value="11-05-7 [v1]\u83b7\u53d6\u5e97\u94fa\u6210\u5458\u89d2\u8272\u4fe1\u606f\uff0c\u5305\u542b\u5bf9\u5e94\u7684\u6743\u9650\u5217\u8868", notes="\u6743\u9650\u7f16\u7801\u5b9a\u4e49\u89c1\uff1ahttp://wiki.bianxianmao.cn/pages/viewpage.action?pageId=25991478")
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u5546\u6237ID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @GetMapping(value={"role"})
    @ApiVersion(value=1)
    public ResponseJson<MerchantMemberRoleDTO> getMerchantMemberRole(@RequestParam(value="merchantId") Long merchantId, @RequestParam(value="userId") Long userId) {
        return ResponseJson.ok((Object)this.merchantAuthService.getMemberRole(userId, merchantId));
    }
}

