/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.manager.impl;

import com.bxm.localnews.merchant.domain.BmManagerMapper;
import com.bxm.localnews.merchant.dto.BmInfoListDTO;
import com.bxm.localnews.merchant.dto.CategoryInfoDTO;
import com.bxm.localnews.merchant.dto.MerchantBmDetailDTO;
import com.bxm.localnews.merchant.manager.BmManagerService;
import com.bxm.localnews.merchant.param.BmEditParam;
import com.bxm.localnews.merchant.param.BmParam;
import com.bxm.localnews.merchant.param.MerchantBmListParam;
import com.bxm.localnews.merchant.service.MerchantRedisRefresh;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BmManagerServiceImpl
implements BmManagerService {
    private static final Logger log = LogManager.getLogger(BmManagerServiceImpl.class);
    @Resource
    private BmManagerMapper bmManagerMapper;
    @Resource
    private MerchantRedisRefresh merchantRedisRefresh;

    @Override
    public PageWarper<BmInfoListDTO> bmList(BmParam param) {
        MerchantBmListParam param1 = new MerchantBmListParam();
        BeanUtils.copyProperties((Object)param, (Object)param1);
        List list = this.bmManagerMapper.getList(param1);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageWarper();
        }
        Page page = new Page(param.getPageNum().intValue(), param.getPageSize().intValue());
        page.setTotal((long)list.size());
        page.addAll((Collection)list);
        return new PageWarper((List)page);
    }

    @Override
    public void saveAndEdit(BmEditParam param) {
        if (Objects.isNull(param.getId())) {
            this.bmManagerMapper.insert(param);
        } else {
            this.bmManagerMapper.update(param);
        }
        this.merchantRedisRefresh.refreshMerchantList(param.getMerchantId());
    }

    @Override
    public List<CategoryInfoDTO> getCategoryInfo() {
        return this.bmManagerMapper.getCategoryList();
    }

    @Override
    public MerchantBmDetailDTO bmDetail(Long id) {
        if (Objects.isNull(id)) {
            return new MerchantBmDetailDTO();
        }
        return this.bmManagerMapper.detail(id);
    }
}

