/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service;

import com.bxm.localnews.merchant.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.merchant.dto.NewsBriefInfoDto;
import com.bxm.localnews.merchant.dto.TopicFacadeVO;
import com.bxm.localnews.merchant.facade.ForumPostFacadeService;
import com.bxm.localnews.merchant.facade.NewsFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class NewsIntegrationService {
    private final ForumPostFacadeService forumPostFacadeService;
    private final NewsFacadeService newsFacadeService;

    @Autowired
    public NewsIntegrationService(ForumPostFacadeService forumPostFacadeService, NewsFacadeService newsFacadeService) {
        this.forumPostFacadeService = forumPostFacadeService;
        this.newsFacadeService = newsFacadeService;
    }

    public ForumPostBriefInfoDto getPostWithoutDetail(Long postId) {
        ResponseEntity postWithoutDetail = this.forumPostFacadeService.getPostWithoutDetail(postId);
        if (postWithoutDetail.hasBody()) {
            return (ForumPostBriefInfoDto)postWithoutDetail.getBody();
        }
        return ForumPostBriefInfoDto.builder().id(postId).build();
    }

    public NewsBriefInfoDto getNewsInfo(Long newsId) {
        ResponseEntity newsInfo = this.newsFacadeService.getBriefInfo(newsId, null, null);
        if (newsInfo.hasBody()) {
            return (NewsBriefInfoDto)newsInfo.getBody();
        }
        return NewsBriefInfoDto.builder().id(newsId).build();
    }

    public TopicFacadeVO getTopicById(Long topicId) {
        ResponseEntity topic = this.forumPostFacadeService.getTopicById(topicId);
        if (topic.hasBody()) {
            return (TopicFacadeVO)topic.getBody();
        }
        return TopicFacadeVO.builder().id(topicId).build();
    }
}

