/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.merchant.common.constant.MerchantGoodsEnum;
import com.bxm.localnews.merchant.common.constant.MerchantMemberEnum;
import com.bxm.localnews.merchant.common.constant.MerchantStatusEnum;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.localnews.merchant.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.service.BaseService;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

@Service
public class PushIntegrationService
extends BaseService {
    @Resource
    private DomainIntegrationService domainIntegrationService;
    @Resource
    private MessageSender messageSender;

    public void pushQualificationStatusMsg(MerchantInfo merchant, MerchantStatusEnum qualificationType, String remark) {
        String content;
        String title;
        if (MerchantStatusEnum.QUALIFICATION_SUCCESS.equals((Object)qualificationType)) {
            title = "\u8d44\u8d28\u8ba4\u8bc1\u6210\u529f";
            content = "\u60a8\u63d0\u4ea4\u7684\u8d44\u8d28\u8ba4\u8bc1\u5df2\u5ba1\u6838\u901a\u8fc7\uff0c\u8d76\u5feb\u8fdb\u5165\u5546\u5bb6\u4e2d\u5fc3\u88c5\u4fee\u4f60\u7684\u5e97\u94fa\u5427~";
        } else {
            title = "\u8d44\u8d28\u8ba4\u8bc1\u5931\u8d25";
            content = "\u60a8\u63d0\u4ea4\u7684\u8d44\u8d28\u8ba4\u8bc1\u5ba1\u6838\u672a\u901a\u8fc7,\u5177\u4f53\u539f\u56e0\uff1a\"" + remark + "\",\u8bf7\u91cd\u65b0\u8fdb\u884c\u8ba4\u8bc1\uff0c\u6709\u7591\u95ee\u53ef\u4ee5\u8054\u7cfb\u5ba2\u670d\u54e6~";
        }
        PushMessage message = this.getPushMessage(merchant, title, content);
        this.messageSender.sendPushMessage(message);
    }

    public void pushMerchantMemberMsg(MerchantMemberVo merchantMemberVo, MerchantInfo merchantInfo, MerchantMemberEnum merchantMemberEnum) {
        String url = "";
        PushMessage message = null;
        if (MerchantMemberEnum.PUSH_TOBOSS_SUCESSS.equals((Object)merchantMemberEnum)) {
            String title = "\u7ed1\u5b9a\u5458\u5de5\u6210\u529f";
            String content = "\u60a8\u5df2\u6210\u529f\u7ed1\u5b9a" + merchantMemberVo.getNickName() + "\u4e3a\u60a8\u5458\u5de5,\u8be6\u60c5\u8bf7\u5728\u5546\u5bb6\u4e2d\u5fc3\uff0c\u5168\u5458\u8425\u9500\u4e2d\u67e5\u770b~";
            url = this.getBossAddress(merchantInfo);
            message = this.pushMerchantMember(merchantInfo.getUserId(), url, title, content);
            this.pushMerchantMember(merchantInfo.getUserId(), url, title, content);
        } else if (MerchantMemberEnum.PUSH_TOEMPLOYEE_SUCESSS.equals((Object)merchantMemberEnum)) {
            String title = "\u6210\u529f\u52a0\u5165\u56e2\u961f";
            String content = "\u606d\u559c\u4f60\uff0c\u6210\u529f\u52a0\u5165" + merchantInfo.getShortName() + "\u56e2\u961f,\u73b0\u5728\u8fdb\u5165\u6211\u7684\u8425\u9500\u4e2d\u4e00\u8d77\u8d5a\u94b1\u5427~";
            url = this.getEmployeeAddress(merchantMemberVo);
            message = this.pushMerchantMember(merchantMemberVo.getUserId(), url, title, content);
        } else if (MerchantMemberEnum.PUSH_TOBOSS_FAIL.equals((Object)merchantMemberEnum)) {
            String title = "\u5458\u5de5\u89e3\u7ed1\u901a\u77e5";
            String content = merchantMemberVo.getNickName() + "\u548c\u60a8\u89e3\u9664\u4e86\u5458\u5de5\u5173\u7cfb\uff0c\u8be6\u60c5\u8bf7\u5728\u5546\u5bb6\u4e2d\u5fc3\uff0c\u5168\u5458\u8425\u9500\u4e2d\u67e5\u770b";
            url = this.getBossAddress(merchantInfo);
            message = this.pushMerchantMember(merchantInfo.getUserId(), url, title, content);
        } else if (MerchantMemberEnum.PUSH_TOEMPLOYEE_FAIL.equals((Object)merchantMemberEnum)) {
            String title = "\u5458\u5de5\u89e3\u7ed1\u901a\u77e5";
            String content = merchantInfo.getShortName() + "\u5df2\u89e3\u9664\u548c\u60a8\u7684\u6210\u5458\u5173\u7cfb";
            message = this.pushMerchantMember(merchantMemberVo.getUserId(), url, title, content);
            this.pushMerchantMember(merchantMemberVo.getUserId(), url, title, content);
        }
        if (message != null) {
            this.messageSender.sendPushMessage(message);
        }
    }

    public void pushShelfStatusMsg(MerchantInfo merchant, MerchantStatusEnum shelfType, String remark) {
        String content;
        String title;
        if (MerchantStatusEnum.SHELF_SUCCESS.equals((Object)shelfType)) {
            title = "\u5e97\u94fa\u6062\u590d\u4e0a\u67b6";
            content = "\u60a8\u7684\u5e97\u94fa\u5df2\u6062\u590d\u4e0a\u67b6\uff0c\u53ef\u4ee5\u7ee7\u7eed\u63a8\u5e7f\u4e86\u54e6~";
            this.logger.debug("\u60a8\u7684\u5e97\u94fa\u5df2\u6062\u590d\u4e0a\u67b6\uff0c\u53ef\u4ee5\u7ee7\u7eed\u63a8\u5e7f\u4e86\u54e6~");
        } else {
            title = "\u5e97\u94fa\u8fdd\u89c4\u4e0b\u67b6";
            content = "\u60a8\u7684\u5e97\u94fa\u6d89\u53ca\u8fdd\u89c4\uff0c\u5df2\u88ab\u4e0b\u67b6\uff0c\u5177\u4f53\u539f\u56e0:\"" + remark + "\",\u8bf7\u5728\u5e97\u94fa\u88c5\u4fee\u5185\u8fdb\u884c\u4fee\u6539\u3002";
        }
        PushMessage message = this.getPushMessage(merchant, title, content);
        this.messageSender.sendPushMessage(message);
    }

    public void pushBossWeekReport(Long merchantId, Long userId, String title, String content) {
        MerchantInfo merchantInfo = new MerchantInfo();
        merchantInfo.setId(merchantId);
        merchantInfo.setUserId(userId);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(this.getBossAddress(merchantInfo));
        this.createMsg(userId, title, content, info);
    }

    public void pushBossEveryDayManagement(Long merchantId, Long userId, String title, String content) {
        MerchantInfo merchantInfo = new MerchantInfo();
        merchantInfo.setId(merchantId);
        merchantInfo.setUserId(userId);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(this.getBossMerchantAddress(merchantInfo));
        this.createMsg(userId, title, content, info);
    }

    public void pushEmployeeWeekReport(Long merchantId, Long userId, String title, String content) {
        MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
        merchantMemberVo.setMerchantId(merchantId);
        merchantMemberVo.setUserId(userId);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(this.getEmployeeAddress(merchantMemberVo));
        this.createMsg(userId, title, content, info);
    }

    public void pushShareByOrderReport(Long merchantId, Long userId, Integer typeEnum) {
        String title = "\u5e7f\u544a\u5e26\u6765\u4e00\u4e2a\u65b0\u7684\u8ba2\u5355";
        String content = "\u7528\u6237\u901a\u8fc7\u5e16\u5b50\u5e7f\u544a\u63d0\u4ea4\u4e86\u4e00\u7b14\u8ba2\u5355\uff0c\u73b0\u5728\u53bb\u67e5\u770b";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        if (Objects.equals(typeEnum, 0)) {
            MerchantInfo merchantInfo = new MerchantInfo();
            merchantInfo.setId(merchantId);
            merchantInfo.setUserId(userId);
            info.setProtocol(this.getBossAddress(merchantInfo));
        } else {
            MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
            merchantMemberVo.setMerchantId(merchantId);
            merchantMemberVo.setUserId(userId);
            info.setProtocol(this.getEmployeeAddress(merchantMemberVo));
        }
        this.createMsg(userId, title, content, info);
    }

    private void createMsg(Long userId, String title, String content, PushPayloadInfo info) {
        info.setTitle(title);
        info.setContent(content);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.DEFAULT_SOUND);
        message.assign(userId);
        this.messageSender.sendPushMessage(message);
    }

    public void pushShareByClickReport(MerchantMemberVo merchantMemberVo) {
        String title = "\u6709\u7528\u6237\u5bf9\u4f60\u7684\u5e97\u94fa\u611f\u5174\u8da3\uff0c\u73b0\u5728\u53bb\u67e5\u770b";
        String content = "\u53d1\u73b0\u65b0\u7684\u5ba2\u6237\u7ebf\u7d22";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        if (Objects.equals(merchantMemberVo.getRole(), 0)) {
            MerchantInfo merchantInfo = new MerchantInfo();
            merchantInfo.setId(merchantMemberVo.getMerchantId());
            merchantInfo.setUserId(merchantMemberVo.getUserId());
            info.setProtocol(this.getBossAddress(merchantInfo));
        } else {
            info.setProtocol(this.getEmployeeAddress(merchantMemberVo));
        }
        this.createMsg(merchantMemberVo.getUserId(), title, content, info);
    }

    private PushMessage getPushMessage(MerchantInfo merchant, String title, String content) {
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(this.buildProtocol(merchant));
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);
        message.assign(merchant.getUserId());
        return message;
    }

    private String buildProtocol(MerchantInfo merchant) {
        StringBuilder url = new StringBuilder();
        url.append(this.domainIntegrationService.getInnerH5BaseUrl()).append("/tk/merchant.html#/shopCenter?merchantId=").append(merchant.getId()).append("&userId={userId}").append("&areaCode={areaCode}").append("&areaName={areaName}");
        return "wst://web/webDetail?url=" + UriUtils.encode((String)url.toString(), (Charset)Charset.defaultCharset());
    }

    private PushMessage pushMerchantMember(Long userId, String url, String title, String content) {
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(url);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);
        message.assign(userId);
        return message;
    }

    private String getBossAddress(MerchantInfo merchantInfo) {
        StringBuilder url = new StringBuilder();
        url.append(this.domainIntegrationService.getInnerH5BaseUrl()).append("/tk/marketing.html#/boss?merchantId=").append(merchantInfo.getId()).append("&userId=").append(merchantInfo.getUserId()).append("&areaCode={areaCode}").append("&areaName={areaName}");
        return "wst://web/webDetail?url=" + UriUtils.encode((String)url.toString(), (Charset)Charset.defaultCharset());
    }

    private String getBossMerchantAddress(MerchantInfo merchantInfo) {
        StringBuilder url = new StringBuilder();
        url.append(this.domainIntegrationService.getInnerH5BaseUrl()).append("/tk/merchant.html#/shopCenter?merchantId=").append(merchantInfo.getId()).append("&userId=").append(merchantInfo.getUserId()).append("&areaCode={areaCode}").append("&areaName={areaName}");
        return "wst://web/webDetail?url=" + UriUtils.encode((String)url.toString(), (Charset)Charset.defaultCharset());
    }

    private String getEmployeeAddress(MerchantMemberVo merchantMemberVo) {
        StringBuilder url = new StringBuilder();
        url.append(this.domainIntegrationService.getInnerH5BaseUrl()).append("/tk/marketing.html#/staff?merchantId=").append(merchantMemberVo.getMerchantId()).append("&userId=").append(merchantMemberVo.getUserId()).append("&areaCode={areaCode}").append("&areaName={areaName}");
        return "wst://web/webDetail?url=" + UriUtils.encode((String)url.toString(), (Charset)Charset.defaultCharset());
    }

    @Async
    public void pushGoodsMsg(MerchantGoodsVo merchantGoodsVo, MerchantInfo merchantInfo, MerchantGoodsEnum merchantGoodsEnum, String remark) {
        String title = null;
        String content = null;
        String url = null;
        if (Objects.equals(MerchantGoodsEnum.PUSH_GOODS_LESSTEN, merchantGoodsEnum)) {
            title = "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3";
            content = "\u60a8\u7684\u5546\u54c1" + merchantGoodsVo.getName() + "\u5e93\u5b58\u4e0d\u8db3\u4e86\uff0c\u8d76\u5feb\u53bb\u6dfb\u52a0\u5546\u54c1\u5e93\u5b58\u5427~";
            url = this.getGoodsBossAddress(merchantInfo, MerchantGoodsEnum.PAGE_GOODS_SALEIN);
        } else if (Objects.equals(MerchantGoodsEnum.PUSH_GOODS_SELLOUT, merchantGoodsEnum)) {
            title = "\u5546\u54c1\u552e\u7f44";
            content = "\u60a8\u7684\u5546\u54c1" + merchantGoodsVo.getName() + "\u5df2\u552e\u7f44\uff0c\u8d76\u5feb\u53bb\u6dfb\u52a0\u5546\u54c1\u5e93\u5b58\u5427~";
            url = this.getGoodsBossAddress(merchantInfo, MerchantGoodsEnum.PAGE_GOODS_SALEOUT);
        } else if (Objects.equals(MerchantGoodsEnum.AUDIT_GOODS_SUCCESS, merchantGoodsEnum)) {
            title = "\u5546\u54c1\u5ba1\u6838\u901a\u8fc7";
            content = "\u60a8\u521b\u5efa\u7684\u5546\u54c1" + merchantGoodsVo.getName() + "\u5df2\u5ba1\u6838\u901a\u8fc7\uff0c\u8f6c\u53d1\u81f3\u5fae\u4fe1\u8ba9\u66f4\u591a\u4eba\u53c2\u4e0e\u8d2d\u4e70\u54e6~";
            url = this.getGoodsBossAddress(merchantInfo, MerchantGoodsEnum.PAGE_GOODS_SALEIN);
        } else if (Objects.equals(MerchantGoodsEnum.AUDIT_GOODS_FAIL, merchantGoodsEnum)) {
            title = "\u5546\u54c1\u5ba1\u6838\u5931\u8d25";
            content = "\u60a8\u521b\u5efa\u7684\u5546\u54c1" + merchantGoodsVo.getName() + "\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u539f\u56e0\u4e3a" + remark + "\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539~";
            url = this.getGoodsBossAddress(merchantInfo, MerchantGoodsEnum.PAGE_GOODS_AUDIT);
        }
        PushMessage pushMessage = this.pushMerchantMember(merchantInfo.getUserId(), url, title, content);
        this.messageSender.sendPushMessage(pushMessage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("pushMessage : {}", (Object)pushMessage);
        }
    }

    private String getGoodsBossAddress(MerchantInfo merchantInfo, MerchantGoodsEnum merchantGoodsEnum) {
        Integer type = null;
        if (Objects.equals(MerchantGoodsEnum.PAGE_GOODS_SALEIN, merchantGoodsEnum)) {
            type = MerchantGoodsEnum.PAGE_GOODS_SALEIN.getType();
        } else if (Objects.equals(MerchantGoodsEnum.PAGE_GOODS_AUDIT, merchantGoodsEnum)) {
            type = MerchantGoodsEnum.PAGE_GOODS_AUDIT.getType();
        } else if (Objects.equals(MerchantGoodsEnum.PAGE_GOODS_SALEOUT, merchantGoodsEnum)) {
            type = MerchantGoodsEnum.PAGE_GOODS_SALEOUT.getType();
        }
        StringBuilder url = new StringBuilder();
        url.append(this.domainIntegrationService.getInnerH5BaseUrl()).append("/tk/goods.html#/commodity?merchantId=").append(merchantInfo.getId()).append("&userId=").append(merchantInfo.getUserId()).append("&areaCode={areaCode}").append("&areaName={areaName}").append("&type=").append(type);
        return "wst://web/webDetail?url=" + UriUtils.encode((String)url.toString(), (Charset)Charset.defaultCharset());
    }
}

