/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account;

import com.bxm.localnews.merchant.common.enums.MerchantAccountTypeEnum;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantUserPromotionFlowMapper;
import com.bxm.localnews.merchant.dto.account.MerchantAccountInfoDTO;
import com.bxm.localnews.merchant.entity.MerchantPromotionFlowEntity;
import com.bxm.localnews.merchant.service.MerchantUserProAccountService;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractUserProAccount {
    private static final Logger log = LoggerFactory.getLogger(AbstractUserProAccount.class);
    @Autowired
    private MerchantUserProAccountService merchantUserProAccountService;
    @Autowired
    private MerchantUserPromotionFlowMapper merchantUserPromotionFlowMapper;
    @Autowired
    private MerchantInfoMapper merchantInfoMapper;
    @Autowired
    private SequenceCreater sequenceCreater;

    protected abstract Boolean checkAmount(MerchantAccountInfoDTO var1);

    protected abstract void changeAccount(MerchantAccountInfoDTO var1);

    private void addRecord(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        MerchantPromotionFlowEntity accountEntity = new MerchantPromotionFlowEntity();
        accountEntity.setAmount(merchantAccountInfoDTO.getAmount());
        accountEntity.setMerchantId(merchantAccountInfoDTO.getMerchantId());
        accountEntity.setType(merchantAccountInfoDTO.getType().name());
        accountEntity.setRelationId(merchantAccountInfoDTO.getRelationId());
        accountEntity.setRelationTitle(merchantAccountInfoDTO.getType().getTitle());
        accountEntity.setUserId(merchantAccountInfoDTO.getUserId());
        accountEntity.setId(this.sequenceCreater.nextLongId());
        this.merchantUserPromotionFlowMapper.insertSelective(accountEntity);
    }

    protected abstract Message preCheck(MerchantAccountInfoDTO var1);

    private Boolean checkBefore(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        MerchantInfo merchantInfo = null;
        if (null != merchantAccountInfoDTO.getUserId()) {
            merchantInfo = this.merchantInfoMapper.selectByUserId(merchantAccountInfoDTO.getUserId());
        } else if (null != merchantAccountInfoDTO.getMerchantId()) {
            merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantAccountInfoDTO.getMerchantId());
        }
        if (null == merchantInfo || null == merchantInfo.getId()) {
            return false;
        }
        merchantAccountInfoDTO.setMerchantId(merchantInfo.getId());
        return true;
    }

    private void afterDispose(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        this.merchantUserProAccountService.refreshAccount(merchantAccountInfoDTO.getMerchantId());
    }

    public final Message execute(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        if (!this.checkBefore(merchantAccountInfoDTO).booleanValue()) {
            this.addRecord(merchantAccountInfoDTO);
            return Message.build((boolean)true);
        }
        Message message = this.preCheck(merchantAccountInfoDTO);
        if (!this.checkAmount(merchantAccountInfoDTO).booleanValue()) {
            return Message.build((boolean)false);
        }
        if (message.isSuccess()) {
            this.changeAccount(merchantAccountInfoDTO);
            if (message.isSuccess()) {
                this.addRecord(merchantAccountInfoDTO);
                this.afterDispose(merchantAccountInfoDTO);
            }
        }
        return message;
    }

    protected abstract MerchantAccountTypeEnum getType();
}

