/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.handle;

import com.bxm.localnews.merchant.common.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossCashFlagEnum;
import com.bxm.localnews.merchant.domain.MerchantAccountMapper;
import com.bxm.localnews.merchant.domain.MerchantCashFlowMapper;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.entity.MerchantAccountEntity;
import com.bxm.localnews.merchant.entity.MerchantCashFlowEntity;
import com.bxm.localnews.merchant.service.account.boss.BossAccountCacheService;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractBossAccountHandle {
    @Resource
    private MerchantInfoMapper merchantInfoMapper;
    @Resource
    private MerchantAccountMapper merchantAccountMapper;
    @Resource
    protected SequenceCreater sequenceCreater;
    @Resource
    private MerchantCashFlowMapper merchantCashFlowMapper;
    @Autowired
    private BossAccountCacheService bossAccountCacheService;

    private Message preCheck(BossAccountContext context) {
        if (Objects.isNull(context.getRelationId())) {
            return Message.build((boolean)false);
        }
        if (Objects.isNull(context.getMerchantId())) {
            return Message.build((boolean)false);
        }
        return this.checkMerchant(context);
    }

    private Message checkMerchant(BossAccountContext context) {
        MerchantInfo merchantInfo = null;
        if (null != context.getUserId()) {
            merchantInfo = this.merchantInfoMapper.selectByUserId(context.getUserId());
        } else if (null != context.getMerchantId()) {
            merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(context.getMerchantId());
        }
        if (null == merchantInfo || null == merchantInfo.getId()) {
            return Message.build((boolean)false);
        }
        context.setMerchantId(merchantInfo.getId());
        return Message.build((boolean)true);
    }

    protected abstract Message checkLogic(BossAccountContext var1);

    protected abstract void bossAccountChange(BossAccountContext var1);

    protected abstract void addAccountCash(BossAccountContext var1);

    public final Message execute(BossAccountContext context) {
        Message message = this.preCheck(context);
        if (!message.isSuccess()) {
            return Message.build((boolean)false);
        }
        message = this.checkLogic(context);
        if (!message.isSuccess()) {
            return message;
        }
        this.bossAccountChange(context);
        this.addAccountCash(context);
        this.afterLogic(context);
        return message;
    }

    private void afterLogic(BossAccountContext context) {
        this.bossAccountCacheService.removeAccountTotal(context.getMerchantId());
    }

    protected abstract MerchantBossAccountActionEnum actionType();

    protected MerchantAccountEntity accountEntity(BossAccountContext context) {
        MerchantAccountEntity entity = this.merchantAccountMapper.selectByMerchantId(context.getMerchantId());
        return Objects.nonNull(entity) ? entity : null;
    }

    protected void addCash(BossAccountContext context, MerchantBossAccountCashTypeEnum cashEnum, BigDecimal amount, String desc, MerchantBossCashFlagEnum cashFlagEnum) {
        MerchantCashFlowEntity entity = new MerchantCashFlowEntity();
        entity.setId(this.sequenceCreater.nextLongId());
        entity.setAmount(amount);
        entity.setType(cashEnum.name());
        entity.setRelationId(context.getRelationId());
        entity.setRemark(cashEnum.getDesc());
        entity.setMerchantId(context.getMerchantId());
        entity.setRelationTitle(desc);
        entity.setGoodsName(context.getGoodsName());
        entity.setCashFlag(Integer.valueOf(cashFlagEnum.getCode()));
        if (cashEnum.equals((Object)MerchantBossAccountCashTypeEnum.CASH_PAYMENT)) {
            entity.setReceiveAmount(context.getReceiveMoney());
        }
        this.merchantCashFlowMapper.insertSelective(entity);
    }
}

