/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.handle.processor;

import com.bxm.localnews.merchant.common.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossCashFlagEnum;
import com.bxm.localnews.merchant.domain.MerchantAccountMapper;
import com.bxm.localnews.merchant.entity.MerchantAccountEntity;
import com.bxm.localnews.merchant.service.account.boss.BossAccountCacheService;
import com.bxm.localnews.merchant.service.account.boss.handle.AbstractBossAccountHandle;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayActionProcessor
extends AbstractBossAccountHandle {
    @Resource
    private MerchantAccountMapper merchantAccountMapper;
    @Autowired
    private BossAccountCacheService bossAccountCacheService;

    @Override
    protected Message checkLogic(BossAccountContext context) {
        if (Objects.isNull(context.getPayMoney())) {
            return Message.build((boolean)false);
        }
        if (Objects.isNull(context.getServiceMoney())) {
            return Message.build((boolean)false);
        }
        if (Objects.isNull(context.getReceiveMoney())) {
            return Message.build((boolean)false);
        }
        return Message.build((boolean)true);
    }

    @Override
    protected void bossAccountChange(BossAccountContext context) {
        MerchantAccountEntity entity = super.accountEntity(context);
        if (Objects.nonNull(entity)) {
            entity.setTotalCash(entity.getTotalCash().add(context.getReceiveMoney()));
            entity.setFreezeCash(entity.getFreezeCash().add(context.getReceiveMoney()));
            this.merchantAccountMapper.updateByPrimaryKey(entity);
        } else {
            MerchantAccountEntity entityNew = new MerchantAccountEntity();
            entityNew.setTotalCash(context.getReceiveMoney());
            entityNew.setFreezeCash(context.getReceiveMoney());
            entityNew.setMerchantId(context.getMerchantId());
            this.merchantAccountMapper.insertSelective(entityNew);
        }
        this.bossAccountCacheService.cacheAccountToday(context.getMerchantId(), context.getReceiveMoney());
    }

    @Override
    protected void addAccountCash(BossAccountContext context) {
        this.addCash(context, MerchantBossAccountCashTypeEnum.CASH_PAYMENT, context.getPayMoney(), "\u8ba2\u5355", MerchantBossCashFlagEnum.CASH_FLAG_OUT_NO);
        if (null != context.getServiceMoney() && context.getServiceMoney().compareTo(BigDecimal.ZERO) > 0) {
            this.addCash(context, MerchantBossAccountCashTypeEnum.CASH_INCOME_CHARGE, context.getServiceMoney().multiply(new BigDecimal("-1")), "\u8ba2\u5355", MerchantBossCashFlagEnum.CASH_FLAG_OUT);
        }
        if (null != context.getPromotionMoney() && context.getPromotionMoney().compareTo(BigDecimal.ZERO) > 0) {
            this.addCash(context, MerchantBossAccountCashTypeEnum.CASH_DIVIDE, context.getPromotionMoney().multiply(new BigDecimal("-1")), "\u8ba2\u5355", MerchantBossCashFlagEnum.CASH_FLAG_OUT);
        }
    }

    @Override
    protected MerchantBossAccountActionEnum actionType() {
        return MerchantBossAccountActionEnum.ACCOUNT_ACTION_PAYMENT;
    }
}

