/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.handle.processor;

import com.bxm.localnews.merchant.common.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossCashFlagEnum;
import com.bxm.localnews.merchant.domain.MerchantAccountMapper;
import com.bxm.localnews.merchant.domain.MerchantCashFlowMapper;
import com.bxm.localnews.merchant.entity.MerchantAccountEntity;
import com.bxm.localnews.merchant.service.account.boss.handle.AbstractBossAccountHandle;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class VerifyCancelActionProcessor
extends AbstractBossAccountHandle {
    @Resource
    private MerchantAccountMapper merchantAccountMapper;
    @Resource
    private MerchantCashFlowMapper merchantCashFlowMapper;

    @Override
    protected Message checkLogic(BossAccountContext context) {
        if (Objects.isNull(context.getPayMoney())) {
            return Message.build((boolean)false);
        }
        if (Objects.isNull(context.getServiceMoney())) {
            return Message.build((boolean)false);
        }
        if (Objects.isNull(context.getReceiveMoney())) {
            return Message.build((boolean)false);
        }
        MerchantAccountEntity entity = super.accountEntity(context);
        if (Objects.isNull(entity)) {
            return Message.build((boolean)false, (String)"\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (entity.getFreezeCash().compareTo(context.getReceiveMoney()) < 0) {
            return Message.build((boolean)false, (String)"\u5185\u90e8\u9519\u8bef\uff1a\u5546\u5bb6\u51bb\u7ed3\u4e2d\u91d1\u989d\u5f02\u5e38\uff01");
        }
        return Message.build((boolean)true);
    }

    @Override
    protected void bossAccountChange(BossAccountContext context) {
        MerchantAccountEntity entity = super.accountEntity(context);
        entity.setDrawableCash(entity.getDrawableCash().add(context.getReceiveMoney()));
        entity.setFreezeCash(entity.getFreezeCash().subtract(context.getReceiveMoney()));
        this.merchantAccountMapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    protected void addAccountCash(BossAccountContext context) {
        this.merchantCashFlowMapper.update(context.getRelationId(), MerchantBossAccountCashTypeEnum.CASH_PAYMENT.name(), MerchantBossAccountCashTypeEnum.CASH_PAYMENT.name(), Integer.valueOf(MerchantBossCashFlagEnum.CASH_FLAG_OUT.getCode()), MerchantBossAccountCashTypeEnum.CASH_PAYMENT.getDesc());
    }

    @Override
    protected MerchantBossAccountActionEnum actionType() {
        return MerchantBossAccountActionEnum.ACCOUNT_ACTION_VERIFY_CANCEL;
    }
}

