/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.handle.processor;

import com.bxm.localnews.merchant.common.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossCashFlagEnum;
import com.bxm.localnews.merchant.domain.MerchantAccountMapper;
import com.bxm.localnews.merchant.entity.MerchantAccountEntity;
import com.bxm.localnews.merchant.service.account.boss.handle.AbstractBossAccountHandle;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class WithdrawingActionProcessor
extends AbstractBossAccountHandle {
    @Resource
    private MerchantAccountMapper merchantAccountMapper;

    @Override
    protected Message checkLogic(BossAccountContext context) {
        if (Objects.isNull(context.getAmount())) {
            return Message.build((boolean)false);
        }
        MerchantAccountEntity entity = super.accountEntity(context);
        if (Objects.isNull(entity)) {
            return Message.build((boolean)false, (String)"\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (entity.getDrawableCash().compareTo(context.getAmount()) < 0) {
            return Message.build((boolean)false, (String)"\u91d1\u989d\u4e0d\u8db3");
        }
        return Message.build((boolean)true);
    }

    @Override
    protected void bossAccountChange(BossAccountContext context) {
        MerchantAccountEntity entity = super.accountEntity(context);
        entity.setFreezeCash(entity.getFreezeCash().add(context.getAmount()));
        entity.setDrawableCash(entity.getDrawableCash().subtract(context.getAmount()));
        entity.setWithdrawingCash(entity.getWithdrawingCash().add(context.getAmount()));
        this.merchantAccountMapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    protected void addAccountCash(BossAccountContext context) {
        this.addCash(context, MerchantBossAccountCashTypeEnum.CASH_WITHDRAW_ING, context.getAmount().multiply(new BigDecimal("-1")), "\u63d0\u73b0", MerchantBossCashFlagEnum.CASH_FLAG_OUT_NO);
    }

    @Override
    protected MerchantBossAccountActionEnum actionType() {
        return MerchantBossAccountActionEnum.ACCOUNT_ACTION_WITHDRAW_ING;
    }
}

