/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.activity.impl;

import com.bxm.localnews.merchant.dto.ActionRecordTraceIdDTO;
import com.bxm.localnews.merchant.dto.RelationshipDto;
import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.param.MerchantReportParam;
import com.bxm.localnews.merchant.param.activity.ActivityAdvertParam;
import com.bxm.localnews.merchant.service.MerchantActionRecordService;
import com.bxm.localnews.merchant.service.MerchantPageCollectService;
import com.bxm.localnews.merchant.service.MerchantUserService;
import com.bxm.localnews.merchant.service.activity.ActivityService;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import com.bxm.localnews.merchant.service.activity.ticket.TicketHandlerChain;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityServiceImpl
implements ActivityService {
    private static final Logger log = LogManager.getLogger(ActivityServiceImpl.class);
    @Autowired
    MerchantUserService merchantUserService;
    @Autowired
    TicketHandlerChain ticketHandlerChain;
    @Autowired
    MerchantActionRecordService merchantActionRecordService;
    @Autowired
    MerchantPageCollectService merchantPageCollectService;

    @Override
    public ActivityAdvertInfoDTO activityAdvertUp(ActivityAdvertParam param) {
        if (log.isDebugEnabled()) {
            log.debug("ActivityAdvertParam : {}", (Object)param);
        }
        if (Objects.isNull(param.getShareUserId())) {
            return null;
        }
        String traceId = this.traceIdDo(param);
        this.viewContent(param, traceId);
        RelationshipDto relationshipDto = this.merchantUserService.getRelationship(param.getShareUserId());
        if (Objects.isNull(relationshipDto)) {
            return null;
        }
        return this.ticketHandlerChain.excuter(this.makeTicketContext(param, relationshipDto, traceId));
    }

    private TicketContext makeTicketContext(ActivityAdvertParam param, RelationshipDto relationshipDto, String traceId) {
        TicketContext ticketContext = TicketContext.builder().merchantId(relationshipDto.getMerchantId()).traceId(traceId).build();
        BeanUtils.copyProperties((Object)param, (Object)((Object)ticketContext));
        return ticketContext;
    }

    private void viewContent(ActivityAdvertParam param, String traceId) {
        if (StringUtils.isBlank((CharSequence)param.getActorUserId())) {
            return;
        }
        MerchantReportParam merchantReportParam = new MerchantReportParam();
        merchantReportParam.setTraceId(traceId);
        merchantReportParam.setToken(param.getActorUserId());
        this.merchantPageCollectService.viewContent(merchantReportParam);
    }

    private String traceIdDo(ActivityAdvertParam param) {
        ActionRecordTraceIdDTO actionRecordTraceIdDTO = new ActionRecordTraceIdDTO();
        actionRecordTraceIdDTO.setBelonger(param.getShareUserId());
        actionRecordTraceIdDTO.setRelationId(param.getContentId());
        actionRecordTraceIdDTO.setRelationType(param.getContentType());
        String traceId = this.merchantActionRecordService.getTraceByRidBelonger(actionRecordTraceIdDTO);
        if (log.isDebugEnabled()) {
            log.debug("traceIdDo  traceId : {}", (Object)traceId);
        }
        return StringUtils.isNotBlank((CharSequence)traceId) ? traceId : null;
    }
}

