/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.activity.ticket;

import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.service.MerchantActionRecordService;
import com.bxm.localnews.merchant.service.MerchantPageCollectService;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractTicketHandler {
    private static final Logger log = LogManager.getLogger(AbstractTicketHandler.class);
    @Autowired
    MerchantActionRecordService merchantActionRecordService;
    @Autowired
    MerchantPageCollectService merchantPageCollectService;
    private AbstractTicketHandler nextHandler;

    public final ActivityAdvertInfoDTO handlerMessage(TicketContext request) {
        Object activityAdvertInfoDTO = this.response(request);
        if (Objects.nonNull(activityAdvertInfoDTO)) {
            return activityAdvertInfoDTO;
        }
        activityAdvertInfoDTO = this.nextHandler != null ? this.nextHandler.handlerMessage(request) : null;
        return activityAdvertInfoDTO;
    }

    public void setNextHandler(AbstractTicketHandler handler) {
        this.nextHandler = handler;
    }

    protected abstract int getHandlerLevel();

    protected abstract ActivityAdvertInfoDTO response(TicketContext var1);
}

