/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.activity.ticket;

import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.service.activity.ticket.AbstractTicketHandler;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TicketHandlerChain {
    Map<Integer, AbstractTicketHandler> handlerMap;
    private List<Integer> offsets = new ArrayList<Integer>();

    @Autowired
    public TicketHandlerChain(List<AbstractTicketHandler> processors) {
        this.handlerMap = Maps.newHashMap();
        if (null != processors) {
            processors.forEach(processor -> {
                this.offsets.add(processor.getHandlerLevel());
                this.handlerMap.put(processor.getHandlerLevel(), (AbstractTicketHandler)processor);
            });
            this.offsets.sort(Integer::compareTo);
            this.handlerMap.forEach((k, v) -> {
                int index;
                int size = this.offsets.size() - 1;
                if (size > (index = this.offsets.indexOf(k))) {
                    v.setNextHandler(this.handlerMap.get(this.offsets.get(index + 1)));
                }
            });
        }
    }

    public ActivityAdvertInfoDTO excuter(TicketContext request) {
        return this.handlerMap.get(this.offsets.get(0)).handlerMessage(request);
    }
}

