/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.activity.ticket.processor;

import com.bxm.localnews.merchant.common.constant.TicketLevelEnum;
import com.bxm.localnews.merchant.dto.MerchantAdvertInfoDTO;
import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.service.MerchantInfoManageService;
import com.bxm.localnews.merchant.service.activity.ticket.AbstractTicketHandler;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployHandlerProcessor
extends AbstractTicketHandler {
    @Autowired
    MerchantInfoManageService merchantInfoManageService;

    @Override
    protected int getHandlerLevel() {
        return TicketLevelEnum.CONFIGURE_LEVEL.getNum();
    }

    @Override
    protected ActivityAdvertInfoDTO response(TicketContext context) {
        MerchantAdvertInfoDTO merchantAdvertInfoDTO = this.merchantInfoManageService.merchantAdvertInfo(context.getMerchantId());
        if (Objects.isNull(merchantAdvertInfoDTO) || merchantAdvertInfoDTO.getStatus() == 0) {
            return null;
        }
        ActivityAdvertInfoDTO response = new ActivityAdvertInfoDTO();
        response.setImgUrl(merchantAdvertInfoDTO.getImgUrl());
        response.setActivityType(TicketLevelEnum.CONFIGURE_LEVEL.getCode());
        response.setLinkUrl(merchantAdvertInfoDTO.getLinkUrl());
        response.setTitle(merchantAdvertInfoDTO.getTitle());
        response.setTraceId(context.getTraceId());
        return response;
    }
}

