/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.activity.ticket.processor;

import com.bxm.localnews.merchant.common.constant.TicketLevelEnum;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.service.activity.ticket.AbstractTicketHandler;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class WebsiteHandlerProcessor
extends AbstractTicketHandler {
    @Resource
    MerchantInfoMapper merchantInfoMapper;

    @Override
    protected int getHandlerLevel() {
        return TicketLevelEnum.WEBSITE_LEVEL.getNum();
    }

    @Override
    protected ActivityAdvertInfoDTO response(TicketContext context) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(context.getMerchantId());
        if (Objects.isNull(merchantInfo) || merchantInfo.getIsShelf() != 1) {
            return null;
        }
        ActivityAdvertInfoDTO response = new ActivityAdvertInfoDTO();
        response.setTraceId(context.getTraceId());
        response.setTitle(merchantInfo.getManageName());
        response.setImgUrl(StringUtils.isNotBlank((CharSequence)merchantInfo.getHeadPics()) ? Arrays.asList(merchantInfo.getHeadPics().split(",")).get(0) : null);
        response.setActivityType(TicketLevelEnum.WEBSITE_LEVEL.getCode());
        response.setLinkUrl(this.linkUrl(context, response.getTraceId()));
        response.setSubtitle(merchantInfo.getDes());
        return response;
    }

    private String linkUrl(TicketContext param, String traceId) {
        String linkUrl = "${common.config.h5-enabled-domain-name}/shareShopDetail.html?merchantId=" + param.getMerchantId() + "&traceId=" + traceId + "&shareUserId=" + param.getShareUserId() + "&actorUserId=" + param.getActorUserId() + "&userId={userId}&areaCode={areaCode}&cityName={cityName}&areaName={areaName}&longitude={longitude}&latitude={latitude}";
        return linkUrl;
    }
}

