/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.impl;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.constant.MerchantGoodsEnum;
import com.bxm.localnews.merchant.common.properties.MerchantGoodsRateProperties;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsRecordMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsSampleMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsUserFavoriteMapper;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantOrderInfoMapper;
import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.dto.goods.AllGoodsSumDTO;
import com.bxm.localnews.merchant.dto.goods.CollectionListDTO;
import com.bxm.localnews.merchant.dto.goods.ExampleGoodsDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsCompare;
import com.bxm.localnews.merchant.dto.goods.GoodsInfoAndUserIdDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsListDTO;
import com.bxm.localnews.merchant.dto.goods.MerchantDto;
import com.bxm.localnews.merchant.dto.goods.MerchantWorkGoodsDTO;
import com.bxm.localnews.merchant.dto.goods.QueryGoodsDTO;
import com.bxm.localnews.merchant.entity.MerchantGoodsViewEntity;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.param.goods.AuditByUserParam;
import com.bxm.localnews.merchant.param.goods.CollectionListParam;
import com.bxm.localnews.merchant.param.goods.GoodsCreateParam;
import com.bxm.localnews.merchant.param.goods.GoodsIdParam;
import com.bxm.localnews.merchant.param.goods.GoodsLikeParam;
import com.bxm.localnews.merchant.param.goods.GoodsUpdateParam;
import com.bxm.localnews.merchant.param.goods.QueryAllGoodsParam;
import com.bxm.localnews.merchant.param.goods.QueryGoodsParam;
import com.bxm.localnews.merchant.param.goods.ShelfByUserParam;
import com.bxm.localnews.merchant.param.goods.SortParam;
import com.bxm.localnews.merchant.service.PushIntegrationService;
import com.bxm.localnews.merchant.service.goods.GoodsBarrageService;
import com.bxm.localnews.merchant.service.goods.GoodsService;
import com.bxm.localnews.merchant.vo.MerchantGoodsRecordVO;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.localnews.merchant.vo.goods.GoodsSortVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsListVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsSampleVO;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsUserFavoriteVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodstotalVo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsServiceImpl
implements GoodsService {
    private static final Logger log = LogManager.getLogger(GoodsServiceImpl.class);
    private final MerchantGoodsMapper merchantGoodsMapper;
    private final MerchantInfoMapper merchantInfoMapper;
    private final MerchantGoodsRecordMapper merchantGoodsRecordMapper;
    private final MerchantGoodsSampleMapper merchantGoodsSampleMapper;
    private final MerchantGoodsUserFavoriteMapper merchantGoodsUserFavoriteMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final SequenceCreater sequenceCreater;
    private final PushIntegrationService pushIntegrationService;
    private final LocationIntegrationService locationIntegrationService;
    private final GoodsBarrageService goodsBarrageService;
    private final MerchantOrderInfoMapper merchantOrderInfoMapper;
    private static final BigDecimal RATE_1 = new BigDecimal("0.01");
    @Autowired
    private MerchantGoodsRateProperties merchantGoodsRateProperties;

    @Override
    public Message create(GoodsCreateParam goodsCreateParam) {
        MerchantGoodsVo merchantGoodsVo = new MerchantGoodsVo();
        BeanUtils.copyProperties((Object)goodsCreateParam, (Object)merchantGoodsVo);
        String mes = this.goodsCheck(merchantGoodsVo);
        if (StringUtils.isNotBlank((String)mes)) {
            return Message.build((boolean)false, (String)mes);
        }
        Long goodsId = this.sequenceCreater.nextLongId();
        merchantGoodsVo.setId(goodsId);
        merchantGoodsVo.setCreateTime(new Date());
        merchantGoodsVo.setTotalNum(merchantGoodsVo.getNum());
        merchantGoodsVo.setVersion(Integer.valueOf(0));
        merchantGoodsVo.setQualificationStatus(Integer.valueOf(1));
        merchantGoodsVo.setShelfType(Integer.valueOf(0));
        GoodsSortVo goodsSortVo = this.merchantGoodsMapper.selectSortByMerchantId(merchantGoodsVo.getMerchantId());
        merchantGoodsVo.setSort(Integer.valueOf(Objects.isNull(goodsSortVo) ? 1 : goodsSortVo.getSort() + 1));
        this.merchantGoodsMapper.insertSelective(merchantGoodsVo);
        this.redisHashMapAdapter.put(RedisConfig.MERCHANT_GOODS_KEY, goodsId + "", (Object)merchantGoodsVo);
        this.addLog(merchantGoodsVo);
        return Message.build((boolean)true);
    }

    private void record(QueryGoodsParam param) {
        if (!Objects.equals(param.getQueryType(), 2)) {
            if (param.getPlatform() == 0) {
                return;
            }
            MerchantGoodsViewEntity entity = new MerchantGoodsViewEntity();
            entity.setUserId(param.getUserId());
            entity.setSource(Byte.valueOf(param.getPlatform() + ""));
            entity.setGoodsId(param.getGoodsId());
            this.goodsBarrageService.saveViewRecord(entity);
        }
    }

    @Override
    public Message query(QueryGoodsParam param) {
        BigDecimal reducedPrice;
        BigDecimal vipPrice;
        long goodsId = param.getGoodsId();
        long userId = param.getUserId();
        int queryType = param.getQueryType();
        boolean isInfoQuery = queryType == 1 || queryType == 3;
        boolean isEditQuery = queryType == 2;
        QueryGoodsDTO queryGoodsDTO = new QueryGoodsDTO();
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsId);
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantGoodsVo.getMerchantId());
        if (Objects.isNull(merchantInfo)) {
            queryGoodsDTO.setPageState(Integer.valueOf(0));
            queryGoodsDTO.setPhone("");
            queryGoodsDTO.setBuyType(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("queryGoodsDTO", (Object)queryGoodsDTO);
        }
        queryGoodsDTO.setPhone(merchantInfo.getMobile());
        this.setBuyType(param, queryGoodsDTO);
        if (Objects.isNull(merchantGoodsVo) || Objects.equals(merchantGoodsVo.getState(), 0)) {
            queryGoodsDTO.setPageState(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("queryGoodsDTO", (Object)queryGoodsDTO);
        }
        this.record(param);
        if (!(!isInfoQuery || Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType()) && Objects.equals(merchantGoodsVo.getShelfType(), MerchantGoodsEnum.GOODS_SHELF_UP.getType()))) {
            queryGoodsDTO.setPageState(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("queryGoodsDTO", (Object)queryGoodsDTO);
        }
        BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)queryGoodsDTO);
        queryGoodsDTO.setPageState(Integer.valueOf(1));
        queryGoodsDTO.setGoodsId(merchantGoodsVo.getId());
        queryGoodsDTO.setMerchantName(merchantInfo.getMerchantName());
        queryGoodsDTO.setMerchantId(merchantInfo.getId());
        queryGoodsDTO.setLatitude(merchantInfo.getLat());
        queryGoodsDTO.setLongitude(merchantInfo.getLng());
        queryGoodsDTO.setMerchantPic(StringUtils.isNotBlank((String)merchantInfo.getHeadPics()) ? Arrays.asList(merchantInfo.getHeadPics().split(",")).get(0) : null);
        List merchantGoodsSampleVOS = this.merchantGoodsSampleMapper.selectBySampleId(merchantGoodsVo.getId());
        if (!CollectionUtils.isEmpty((Collection)merchantGoodsSampleVOS) && queryType == 1) {
            queryGoodsDTO.setSampleType(Integer.valueOf(1));
        } else {
            queryGoodsDTO.setSampleType(Integer.valueOf(0));
        }
        BigDecimal immediatelyPrice = merchantGoodsVo.getPrice().multiply(new BigDecimal(merchantGoodsVo.getCommissionRate())).multiply(this.merchantGoodsRateProperties.getProfitRebate()).multiply(RATE_1).setScale(2, 4);
        BigDecimal discount = merchantGoodsVo.getPrice().divide(merchantGoodsVo.getOriginalPrice(), 2, 1).multiply(BigDecimal.TEN);
        if (discount.compareTo(BigDecimal.ZERO) <= 0) {
            discount = RATE_1;
        }
        if ((vipPrice = merchantGoodsVo.getPrice().multiply(this.merchantGoodsRateProperties.getVipRebate()).setScale(2, 4)).compareTo(BigDecimal.ZERO) <= 0) {
            vipPrice = RATE_1;
        }
        if ((reducedPrice = merchantGoodsVo.getPrice().subtract(vipPrice)).compareTo(BigDecimal.ZERO) < 0) {
            vipPrice = BigDecimal.ZERO;
        }
        queryGoodsDTO.setImmediatelyPrice(immediatelyPrice);
        queryGoodsDTO.setAddress(this.getAddress(merchantInfo));
        queryGoodsDTO.setVipPrice(vipPrice);
        queryGoodsDTO.setDiscount(discount);
        queryGoodsDTO.setReducedPrice(reducedPrice);
        MerchantGoodsUserFavoriteVo merchantGoodsUserFavoriteVo = this.merchantGoodsUserFavoriteMapper.selectByUserAndGoods(Long.valueOf(userId), merchantGoodsVo.getId());
        if (Objects.nonNull(merchantGoodsUserFavoriteVo)) {
            queryGoodsDTO.setCollectionType(merchantGoodsUserFavoriteVo.getStatus());
        } else {
            queryGoodsDTO.setCollectionType(Integer.valueOf(0));
        }
        return Message.build((boolean)true).addParam("queryGoodsDTO", (Object)queryGoodsDTO);
    }

    private void setBuyType(QueryGoodsParam param, QueryGoodsDTO queryGoodsDTO) {
        if (Objects.equals(3, param.getQueryType()) || Objects.equals(PlatformEnum.WEB.getCode(), param.getPlatform())) {
            int orderNum = this.merchantOrderInfoMapper.hasUserOrder(param.getGoodsId(), param.getUserId());
            queryGoodsDTO.setBuyType(Integer.valueOf(orderNum > 0 ? 1 : 0));
        } else {
            queryGoodsDTO.setBuyType(Integer.valueOf(0));
        }
    }

    @Override
    public Message update(GoodsUpdateParam goodsUpdateParam) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsUpdateParam.getGoodsId());
        if (merchantGoodsVo == null) {
            return Message.build((boolean)false, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MerchantGoodsVo goodsVo = new MerchantGoodsVo();
        BeanUtils.copyProperties((Object)goodsUpdateParam, (Object)goodsVo);
        this.goodsCheck(goodsVo);
        goodsVo.setId(goodsUpdateParam.getGoodsId());
        goodsVo.setTotalNum(this.countTotalNum(goodsUpdateParam.getNum(), merchantGoodsVo));
        goodsVo.setVersion(merchantGoodsVo.getVersion());
        boolean result = this.compare(goodsUpdateParam);
        if (result) {
            goodsVo.setQualificationStatus(Integer.valueOf(1));
            goodsVo.setShelfType(Integer.valueOf(0));
        }
        if (this.merchantGoodsMapper.updateByPrimaryKeySelective(goodsVo) == 0) {
            if (log.isDebugEnabled()) {
                log.debug(MerchantGoodsEnum.FAILMES.getDesc(), (Object)goodsVo);
            }
            return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
        }
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{goodsVo.getId() + ""});
        this.addLog(merchantGoodsVo);
        return Message.build((boolean)true);
    }

    @Override
    public Message getMerchantInfo(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
        MerchantDto merchantDto = new MerchantDto();
        if (merchantInfo != null) {
            BeanUtils.copyProperties((Object)merchantInfo, (Object)merchantDto);
            merchantDto.setMerchantId(merchantInfo.getId());
            merchantDto.setAddress(this.getAddress(merchantInfo));
            merchantDto.setHeadPics(StringUtils.isNotBlank((String)merchantInfo.getHeadPics()) ? Arrays.asList(merchantInfo.getHeadPics().split(",")).get(0) : null);
            return Message.build((boolean)true).addParam("merchantDto", (Object)merchantDto);
        }
        return Message.build((boolean)true).addParam("merchantDto", (Object)merchantDto);
    }

    @Override
    public PageWarper<MerchantGoodsListVo> queryGoodsListAll(QueryAllGoodsParam queryAllGoodsParam) {
        switch (queryAllGoodsParam.getType()) {
            case 0: {
                queryAllGoodsParam.setType(Integer.valueOf(1));
                return this.convert(this.merchantGoodsMapper.selectByshelfType(queryAllGoodsParam));
            }
            case 1: {
                return this.convert(this.merchantGoodsMapper.selectByqualification(queryAllGoodsParam));
            }
            case 2: {
                return this.convert(this.merchantGoodsMapper.selectByshelfAndSum(queryAllGoodsParam));
            }
            case 3: {
                queryAllGoodsParam.setType(Integer.valueOf(0));
                return this.convert(this.merchantGoodsMapper.selectByshelfType(queryAllGoodsParam));
            }
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    private PageWarper<MerchantGoodsListVo> convert(List<MerchantGoodsListVo> merchantGoodsListVoList) {
        if (!CollectionUtils.isEmpty(merchantGoodsListVoList)) {
            merchantGoodsListVoList.forEach(merchantGoodsListVo -> {
                if (merchantGoodsListVo != null) {
                    merchantGoodsListVo.setImg(StringUtils.isNotBlank((String)merchantGoodsListVo.getHeadPics()) ? Arrays.asList(merchantGoodsListVo.getHeadPics().split(",")).get(0) : null);
                    merchantGoodsListVo.setSaleNum(Integer.valueOf(merchantGoodsListVo.getTotalNum() - merchantGoodsListVo.getNum()));
                    merchantGoodsListVo.setGoodsId(merchantGoodsListVo.getId());
                    BigDecimal vipPrice = merchantGoodsListVo.getPrice().multiply(this.merchantGoodsRateProperties.getVipRebate()).setScale(2, 4);
                    if (vipPrice.compareTo(BigDecimal.ZERO) <= 0) {
                        vipPrice = RATE_1;
                    }
                    merchantGoodsListVo.setVipPrice(vipPrice);
                    BigDecimal immediatelyPrice = merchantGoodsListVo.getPrice().multiply(new BigDecimal(merchantGoodsListVo.getCommissionRate())).multiply(this.merchantGoodsRateProperties.getProfitRebate()).multiply(RATE_1).setScale(2, 4);
                    merchantGoodsListVo.setImmediatelyPrice(immediatelyPrice);
                    BigDecimal discount = merchantGoodsListVo.getPrice().divide(merchantGoodsListVo.getOriginalPrice(), 2, 1).multiply(BigDecimal.TEN);
                    if (discount.compareTo(BigDecimal.ZERO) <= 0) {
                        discount = RATE_1;
                    }
                    merchantGoodsListVo.setDiscount(discount);
                }
            });
            return new PageWarper(merchantGoodsListVoList);
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    @Override
    public Message queryExampleGoods(Long merchantId) {
        ExampleGoodsDTO exampleGoodsDTO = new ExampleGoodsDTO();
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
        if (Objects.isNull(merchantInfo)) {
            exampleGoodsDTO.setType(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("exampleGoodsDTO", (Object)exampleGoodsDTO);
        }
        MerchantGoodsSampleVO merchantGoodsSampleVO = this.merchantGoodsSampleMapper.selectByPrimaryKey(merchantInfo.getCategoryId());
        if (Objects.isNull(merchantGoodsSampleVO)) {
            exampleGoodsDTO.setType(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("exampleGoodsDTO", (Object)exampleGoodsDTO);
        }
        if (Objects.isNull(merchantGoodsSampleVO.getSampleId())) {
            exampleGoodsDTO.setType(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("exampleGoodsDTO", (Object)exampleGoodsDTO);
        }
        MerchantGoodsVo merchantGoodsVo = this.merchantGoodsMapper.selectByPrimaryKey(merchantGoodsSampleVO.getSampleId());
        if (Objects.isNull(merchantGoodsVo)) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORGOODSMES.getDesc());
        }
        exampleGoodsDTO.setGoodsId(merchantGoodsVo.getId());
        exampleGoodsDTO.setImg(StringUtils.isNotBlank((String)merchantGoodsVo.getHeadPics()) ? Arrays.asList(merchantGoodsVo.getHeadPics().split(",")).get(0) : null);
        exampleGoodsDTO.setType(Integer.valueOf(1));
        exampleGoodsDTO.setName(merchantGoodsVo.getName());
        exampleGoodsDTO.setNum(merchantGoodsVo.getNum());
        exampleGoodsDTO.setOriginalPrice(merchantGoodsVo.getOriginalPrice());
        exampleGoodsDTO.setPrice(merchantGoodsVo.getPrice());
        exampleGoodsDTO.setSaleNum(Objects.nonNull(merchantGoodsVo.getNum()) && Objects.nonNull(merchantGoodsVo.getTotalNum()) ? Integer.valueOf(merchantGoodsVo.getTotalNum() - merchantGoodsVo.getNum()) : null);
        return Message.build((boolean)true).addParam("exampleGoodsDTO", (Object)exampleGoodsDTO);
    }

    @Override
    public Message queryAllGoodsSum(Long merchantId) {
        AllGoodsSumDTO allGoodsSumDTO = new AllGoodsSumDTO();
        MerchantGoodstotalVo merchantGoodstotalVo = this.merchantGoodsMapper.selectByqualificationTatal(merchantId);
        if (merchantGoodstotalVo != null) {
            allGoodsSumDTO.setAuditSum(merchantGoodstotalVo.getTotal());
        }
        if ((merchantGoodstotalVo = this.merchantGoodsMapper.selectByshelfTypeTatal(Integer.valueOf(0), merchantId)) != null) {
            allGoodsSumDTO.setShelfDownSum(merchantGoodstotalVo.getTotal());
        }
        if ((merchantGoodstotalVo = this.merchantGoodsMapper.selectByshelfTypeTatal(Integer.valueOf(1), merchantId)) != null) {
            allGoodsSumDTO.setShelfUpSum(merchantGoodstotalVo.getTotal());
        }
        if ((merchantGoodstotalVo = this.merchantGoodsMapper.selectByshelfAndSumTatal(merchantId)) != null) {
            allGoodsSumDTO.setShelfOutSum(merchantGoodstotalVo.getTotal());
        }
        return Message.build((boolean)true).addParam("allGoodsSumDTO", (Object)allGoodsSumDTO);
    }

    @Override
    public Message delete(GoodsIdParam goodsIdParam) {
        this.merchantGoodsMapper.deleteByPrimaryKey(goodsIdParam.getGoodsId());
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{goodsIdParam.getGoodsId() + ""});
        return Message.build((boolean)true);
    }

    @Override
    public Message shelf(ShelfByUserParam shelfByUserParam) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(shelfByUserParam.getGoodsId());
        if (this.getGoodsInfo(shelfByUserParam.getGoodsId()) == null) {
            return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType())) {
            return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u6ca1\u6709\u5ba1\u6838\u6210\u529f,\u4e0d\u80fd\u4e0a\u4e0b\u67b6");
        }
        if (Objects.equals(shelfByUserParam.getType(), 1) || Objects.equals(shelfByUserParam.getType(), 0)) {
            MerchantGoodsVo goodsVo = new MerchantGoodsVo();
            goodsVo.setId(shelfByUserParam.getGoodsId());
            goodsVo.setShelfType(shelfByUserParam.getType());
            goodsVo.setVersion(merchantGoodsVo.getVersion());
            if (this.merchantGoodsMapper.updateByPrimaryKeySelective(goodsVo) == 0) {
                if (log.isDebugEnabled()) {
                    log.debug(MerchantGoodsEnum.FAILMES.getDesc(), (Object)goodsVo);
                }
                return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
            }
        }
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{shelfByUserParam.getGoodsId() + ""});
        return Message.build((boolean)true, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public Message auditByUser(AuditByUserParam auditByUserParam) {
        String mes = this.checkAuditByUser(auditByUserParam);
        if (StringUtils.isNotBlank((String)mes)) {
            return Message.build((boolean)false, (String)mes);
        }
        MerchantGoodsVo merchantGoodsVo = new MerchantGoodsVo();
        merchantGoodsVo.setId(auditByUserParam.getGoodsId());
        merchantGoodsVo.setQualificationStatus(auditByUserParam.getType());
        this.merchantGoodsMapper.updateByGoodsId(merchantGoodsVo);
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{auditByUserParam.getGoodsId() + ""});
        return Message.build((boolean)true);
    }

    private String checkAuditByUser(AuditByUserParam auditByUserParam) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(auditByUserParam.getGoodsId());
        if (this.getGoodsInfo(auditByUserParam.getGoodsId()) == null) {
            return "\u8be5\u5546\u54c1\u4e0d\u5b58\u5728";
        }
        if (Objects.equals(auditByUserParam.getType(), 0) && !Objects.equals(merchantGoodsVo.getQualificationStatus(), 1)) {
            return "\u8be5\u5546\u54c1\u4e0d\u5728\u5ba1\u6838\u4e2d";
        }
        if (Objects.equals(auditByUserParam.getType(), 1) && !Objects.equals(merchantGoodsVo.getQualificationStatus(), 0)) {
            return "\u8be5\u5546\u54c1\u4e0d\u5728\u5f85\u5ba1\u6838\u4e2d";
        }
        return null;
    }

    @Override
    public Message queryGoodsList(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
        if (Objects.isNull(merchantInfo)) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORMERCHANTMES.getDesc());
        }
        List merchantGoodsVos = this.merchantGoodsMapper.selectByMerchantId(merchantId);
        List goodsListDTOList = merchantGoodsVos.stream().map(merchantGoodsVo -> {
            GoodsListDTO goodsListDTO = new GoodsListDTO();
            if (Objects.nonNull(merchantGoodsVo)) {
                BigDecimal discount;
                BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)goodsListDTO);
                if (StringUtils.isNotBlank((String)merchantGoodsVo.getHeadPics())) {
                    goodsListDTO.setImg(this.getFirstImg(merchantGoodsVo.getHeadPics()));
                }
                if ((discount = merchantGoodsVo.getPrice().divide(merchantGoodsVo.getOriginalPrice(), 2, 1).multiply(BigDecimal.TEN)).compareTo(BigDecimal.ZERO) <= 0) {
                    discount = RATE_1;
                }
                goodsListDTO.setDiscount(discount);
                goodsListDTO.setGoodsId(merchantGoodsVo.getId());
            }
            return goodsListDTO;
        }).collect(Collectors.toList());
        return Message.build((boolean)true).addParam("goodsListDTOList", goodsListDTOList);
    }

    private String getFirstImg(String goodsImg) {
        String[] imgs;
        if (StringUtils.isNotBlank((String)goodsImg) && goodsImg.contains(",") && (imgs = goodsImg.split(",")).length > 0) {
            return imgs[0];
        }
        return goodsImg;
    }

    @Override
    public Message sort(SortParam sortParam) {
        MerchantGoodsVo merchantGoodsVo = new MerchantGoodsVo();
        merchantGoodsVo.setId(sortParam.getUpGoodsId());
        merchantGoodsVo.setSort(sortParam.getDownGoodsSort());
        this.merchantGoodsMapper.updateByGoodsId(merchantGoodsVo);
        merchantGoodsVo.setId(sortParam.getDownGoodsId());
        merchantGoodsVo.setSort(sortParam.getUpGoodsSort());
        this.merchantGoodsMapper.updateByGoodsId(merchantGoodsVo);
        return Message.build((boolean)true);
    }

    @Override
    public Message collection(GoodsLikeParam goodsLikeParam) {
        if (Objects.equals(goodsLikeParam.getType(), 0)) {
            MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsLikeParam.getGoodsId());
            if (merchantGoodsVo == null || Objects.equals(merchantGoodsVo.getShelfType(), MerchantGoodsEnum.GOODS_SHELF_DOWN.getType())) {
                return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u5df2\u88ab\u4e0b\u67b6,\u4e0d\u80fd\u88ab\u6536\u85cf");
            }
            MerchantGoodsUserFavoriteVo merchantGoodsUserFavoriteVo = this.merchantGoodsUserFavoriteMapper.selectByUserAndGoods(goodsLikeParam.getUserId(), goodsLikeParam.getGoodsId());
            if (Objects.isNull(merchantGoodsUserFavoriteVo)) {
                MerchantGoodsUserFavoriteVo favoriteVo = new MerchantGoodsUserFavoriteVo();
                favoriteVo.setCreateTime(new Date());
                favoriteVo.setModifyTime(new Date());
                BeanUtils.copyProperties((Object)goodsLikeParam, (Object)favoriteVo);
                this.merchantGoodsUserFavoriteMapper.insertSelective(favoriteVo);
            } else {
                if (Objects.equals(merchantGoodsUserFavoriteVo.getStatus(), 1)) {
                    return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u5df2\u7ecf\u5728\u6536\u85cf\u4e2d,\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
                }
                BeanUtils.copyProperties((Object)goodsLikeParam, (Object)merchantGoodsUserFavoriteVo);
                merchantGoodsUserFavoriteVo.setId(merchantGoodsUserFavoriteVo.getId());
                merchantGoodsUserFavoriteVo.setStatus(Integer.valueOf(1));
                merchantGoodsUserFavoriteVo.setModifyTime(new Date());
                this.merchantGoodsUserFavoriteMapper.updateByPrimaryKey(merchantGoodsUserFavoriteVo);
            }
            return Message.build((boolean)true);
        }
        if (Objects.equals(goodsLikeParam.getType(), 1)) {
            MerchantGoodsUserFavoriteVo merchantGoodsUserFavoriteVo = this.merchantGoodsUserFavoriteMapper.selectByUserAndGoods(goodsLikeParam.getUserId(), goodsLikeParam.getGoodsId());
            if (Objects.isNull(merchantGoodsUserFavoriteVo)) {
                return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u672a\u6536\u85cf\u8be5\u5546\u54c1");
            }
            if (Objects.equals(merchantGoodsUserFavoriteVo.getStatus(), 0)) {
                return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u5df2\u7ecf\u88ab\u53d6\u6d88\u6536\u85cf,\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
            }
            BeanUtils.copyProperties((Object)goodsLikeParam, (Object)merchantGoodsUserFavoriteVo);
            merchantGoodsUserFavoriteVo.setStatus(Integer.valueOf(0));
            merchantGoodsUserFavoriteVo.setModifyTime(new Date());
            this.merchantGoodsUserFavoriteMapper.updateByPrimaryKey(merchantGoodsUserFavoriteVo);
            return Message.build((boolean)true);
        }
        return Message.build((boolean)true);
    }

    @Override
    public PageWarper<CollectionListDTO> collectionList(CollectionListParam collectionListParam) {
        List merchantGoodsUserFavoriteVos = this.merchantGoodsUserFavoriteMapper.collectionList(collectionListParam);
        if (!CollectionUtils.isEmpty((Collection)merchantGoodsUserFavoriteVos)) {
            merchantGoodsUserFavoriteVos.forEach(merchantGoodsUserFavoriteVo -> {
                if (Objects.nonNull(merchantGoodsUserFavoriteVo)) {
                    merchantGoodsUserFavoriteVo.setHeadPics(StringUtils.isNotBlank((String)merchantGoodsUserFavoriteVo.getHeadPics()) ? Arrays.asList(merchantGoodsUserFavoriteVo.getHeadPics().split(",")).get(0) : null);
                    merchantGoodsUserFavoriteVo.setCollectTime(merchantGoodsUserFavoriteVo.getModifyTime());
                }
            });
            return new PageWarper(merchantGoodsUserFavoriteVos);
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    private MerchantGoodsVo getGoodsInfo(Long goodsId) {
        MerchantGoodsVo merchantGoodsVo = (MerchantGoodsVo)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_GOODS_KEY, goodsId + "", MerchantGoodsVo.class);
        if (merchantGoodsVo == null) {
            merchantGoodsVo = this.merchantGoodsMapper.selectByPrimaryKey(goodsId);
            if (merchantGoodsVo != null) {
                this.redisHashMapAdapter.put(RedisConfig.MERCHANT_GOODS_KEY, merchantGoodsVo.getId() + "", (Object)merchantGoodsVo);
                return merchantGoodsVo;
            }
            return null;
        }
        return merchantGoodsVo;
    }

    @Override
    public Boolean stockGoods(Long goodsId, Integer num) {
        log.info("\u5546\u54c1: {} \u64cd\u4f5c\u5e93\u5b58: {}", (Object)goodsId, (Object)num);
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsId);
        if (merchantGoodsVo == null) {
            return false;
        }
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantGoodsVo.getMerchantId());
        if (merchantInfo == null) {
            return false;
        }
        int sum = merchantGoodsVo.getNum();
        if (sum <= 0) {
            return false;
        }
        if (num < 0) {
            num = Math.abs(num);
            sum += num.intValue();
        } else {
            sum -= num.intValue();
        }
        if (sum < 0) {
            return false;
        }
        MerchantGoodsVo update = new MerchantGoodsVo();
        update.setId(goodsId);
        update.setNum(Integer.valueOf(sum));
        update.setVersion(merchantGoodsVo.getVersion());
        if (this.merchantGoodsMapper.updateByPrimaryKeySelective(update) == 0) {
            log.warn("\u66f4\u65b0\u5e93\u5b58\u5931\u8d25 goodsId: {}, num: {}", (Object)goodsId, (Object)num);
            return false;
        }
        if (Objects.equals(update.getNum(), 10)) {
            this.pushIntegrationService.pushGoodsMsg(merchantGoodsVo, merchantInfo, MerchantGoodsEnum.PUSH_GOODS_LESSTEN, null);
        }
        if (update.getNum() <= 0) {
            this.pushIntegrationService.pushGoodsMsg(merchantGoodsVo, merchantInfo, MerchantGoodsEnum.PUSH_GOODS_SELLOUT, null);
        }
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{merchantGoodsVo.getId() + ""});
        return true;
    }

    @Override
    public GoodsInfoAndUserIdDTO getByGoodsId(Long goodsId) {
        GoodsInfoAndUserIdDTO entity = this.merchantGoodsMapper.getGoodsInfoAndMerchant(goodsId);
        if (null != entity && com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)entity.getGoodsImg())) {
            entity.setGoodsImg(entity.getGoodsImg().split(",")[0]);
        }
        return entity;
    }

    private Integer countTotalNum(Integer num, MerchantGoodsVo merchantGoodsVo) {
        Integer totalNum = merchantGoodsVo.getTotalNum();
        Integer oldNum = merchantGoodsVo.getNum();
        if (!Objects.equals(oldNum, num)) {
            if (num > oldNum) {
                int result = num - oldNum;
                totalNum = totalNum + result;
            } else {
                int result = oldNum - num;
                totalNum = totalNum - result;
            }
        }
        return totalNum;
    }

    private void addLog(MerchantGoodsVo merchantGoodsVo) {
        MerchantGoodsRecordVO merchantGoodsRecordVO = new MerchantGoodsRecordVO();
        BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)merchantGoodsRecordVO);
        merchantGoodsRecordVO.setGoodsId(merchantGoodsVo.getId());
        merchantGoodsRecordVO.setId(null);
        merchantGoodsRecordVO.setCreateTime(new Date());
        this.merchantGoodsRecordMapper.insertSelective(merchantGoodsRecordVO);
    }

    private String goodsCheck(MerchantGoodsVo merchantGoodsVo) {
        if (merchantGoodsVo.getNum() <= 0) {
            return "\u5e93\u5b58\u4e0d\u80fd\u4e3a0";
        }
        if (merchantGoodsVo.getOriginalPrice().doubleValue() < 1.0) {
            return "\u539f\u4ef7\u6700\u4f4e\u53ef\u8bbe\u4e3a1\u5143";
        }
        if (merchantGoodsVo.getOriginalPrice().doubleValue() < 0.01) {
            return "\u73b0\u4ef7\u6700\u4f4e\u53ef\u8bbe\u4e3a0.01\u5143";
        }
        if (merchantGoodsVo.getPrice().doubleValue() > merchantGoodsVo.getOriginalPrice().doubleValue()) {
            return "\u5546\u54c1\u73b0\u4ef7\u4e0d\u80fd\u5927\u4e8e\u539f\u4ef7";
        }
        if (merchantGoodsVo.getCommissionRate() > MerchantGoodsEnum.GOODS_RATE_MAX.getType() || merchantGoodsVo.getCommissionRate() < 1) {
            return "\u4f63\u91d1\u6bd4\u4f8b\uff0c\u6700\u4f4e\u4e0d\u5c0f\u4e8e1%\uff0c\u6700\u9ad8\u4e0d\u8d85\u8fc799%";
        }
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantGoodsVo.getMerchantId());
        if (Objects.isNull(merchantInfo)) {
            return "\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        return null;
    }

    private String getAddress(MerchantInfo merchantInfo) {
        if (StringUtils.isNotBlank((String)merchantInfo.getCityCode()) && StringUtils.isNotBlank((String)merchantInfo.getCountyCode())) {
            StringBuilder str = new StringBuilder();
            LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(merchantInfo.getCityCode());
            if (StringUtils.isNotBlank((String)locationDTO.getFullName())) {
                str.append(locationDTO.getFullName());
            }
            if (StringUtils.isNotBlank((String)(locationDTO = this.locationIntegrationService.getLocationByGeocode(merchantInfo.getCountyCode())).getName())) {
                str.append(locationDTO.getName());
            }
            str.append(merchantInfo.getAddress());
            return str.toString();
        }
        return null;
    }

    private boolean compare(GoodsUpdateParam goodsUpdateParam) {
        MerchantGoodsRecordVO merchantGoodsRecordVO = this.merchantGoodsRecordMapper.selectByPrimaryKey(goodsUpdateParam.getGoodsId());
        if (merchantGoodsRecordVO != null) {
            GoodsCompare newGoods = new GoodsCompare();
            BeanUtils.copyProperties((Object)goodsUpdateParam, (Object)newGoods);
            newGoods.setPrice(goodsUpdateParam.getPrice().doubleValue());
            newGoods.setOriginalPrice(goodsUpdateParam.getOriginalPrice().doubleValue());
            GoodsCompare oldGoods = new GoodsCompare();
            BeanUtils.copyProperties((Object)merchantGoodsRecordVO, (Object)oldGoods);
            oldGoods.setPrice(merchantGoodsRecordVO.getPrice().doubleValue());
            oldGoods.setOriginalPrice(merchantGoodsRecordVO.getOriginalPrice().doubleValue());
            if (Objects.equals(newGoods, oldGoods)) {
                return false;
            }
            return Objects.equals(merchantGoodsRecordVO.getNum(), goodsUpdateParam.getNum()) && Objects.equals(merchantGoodsRecordVO.getVipDiscount(), goodsUpdateParam.getVipDiscount()) && Objects.equals(merchantGoodsRecordVO.getCommissionRate(), goodsUpdateParam.getCommissionRate());
        }
        return true;
    }

    @Override
    public void shelfDownAllGoods(Long merchantId) {
        this.merchantGoodsMapper.shelfDownAllGoods(merchantId);
    }

    @Override
    public List<MerchantWorkGoodsDTO> queryWorkGoods(Long merchantId) {
        List workGoodsList = this.merchantGoodsMapper.getWorkGoodsList(merchantId);
        ArrayList<MerchantWorkGoodsDTO> goodsDTOList = new ArrayList<MerchantWorkGoodsDTO>();
        if (!CollectionUtils.isEmpty((Collection)workGoodsList)) {
            workGoodsList.forEach(merchantGoodsVo -> {
                if (merchantGoodsVo != null) {
                    MerchantWorkGoodsDTO merchantWorkGoodsDTO = new MerchantWorkGoodsDTO();
                    BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)merchantWorkGoodsDTO);
                    merchantWorkGoodsDTO.setGoodsId(merchantGoodsVo.getId());
                    merchantWorkGoodsDTO.setVipPrice(merchantGoodsVo.getPrice().multiply(new BigDecimal("0.05")).setScale(2, 4));
                    goodsDTOList.add(merchantWorkGoodsDTO);
                }
            });
            log.debug(((Object)goodsDTOList).toString());
            return goodsDTOList;
        }
        return null;
    }

    public GoodsServiceImpl(MerchantGoodsMapper merchantGoodsMapper, MerchantInfoMapper merchantInfoMapper, MerchantGoodsRecordMapper merchantGoodsRecordMapper, MerchantGoodsSampleMapper merchantGoodsSampleMapper, MerchantGoodsUserFavoriteMapper merchantGoodsUserFavoriteMapper, RedisHashMapAdapter redisHashMapAdapter, SequenceCreater sequenceCreater, PushIntegrationService pushIntegrationService, LocationIntegrationService locationIntegrationService, GoodsBarrageService goodsBarrageService, MerchantOrderInfoMapper merchantOrderInfoMapper, MerchantGoodsRateProperties merchantGoodsRateProperties) {
        this.merchantGoodsMapper = merchantGoodsMapper;
        this.merchantInfoMapper = merchantInfoMapper;
        this.merchantGoodsRecordMapper = merchantGoodsRecordMapper;
        this.merchantGoodsSampleMapper = merchantGoodsSampleMapper;
        this.merchantGoodsUserFavoriteMapper = merchantGoodsUserFavoriteMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.sequenceCreater = sequenceCreater;
        this.pushIntegrationService = pushIntegrationService;
        this.locationIntegrationService = locationIntegrationService;
        this.goodsBarrageService = goodsBarrageService;
        this.merchantOrderInfoMapper = merchantOrderInfoMapper;
        this.merchantGoodsRateProperties = merchantGoodsRateProperties;
    }
}

