/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.param.MerchantIntoApplyParam;
import com.bxm.localnews.merchant.supporter.LocationHelper;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;

public class BaseMerchantInfoService
extends BaseService {
    @Resource
    private LocationHelper locationHelper;
    @Resource
    private LocationIntegrationService locationIntegrationService;

    MerchantInfo fillMerchantInfo(MerchantIntoApplyParam merchantInfoParam) {
        MerchantInfo merchantInfo = new MerchantInfo();
        BeanUtils.copyProperties((Object)merchantInfoParam, (Object)merchantInfo);
        merchantInfo.setId(merchantInfoParam.getMerchantId());
        this.locationHelper.fillLocation(merchantInfo);
        this.fillAreaCode(merchantInfo);
        return merchantInfo;
    }

    private void fillAreaCode(MerchantInfo merchantInfo) {
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(merchantInfo.getCountyCode());
        if (StringUtils.isNotBlank((CharSequence)locationDTO.getName())) {
            merchantInfo.setAreaCode(locationDTO.getCode());
        } else {
            locationDTO = this.locationIntegrationService.getLocationByGeocode(merchantInfo.getCityCode());
            if (StringUtils.isNotBlank((CharSequence)locationDTO.getName())) {
                merchantInfo.setAreaCode(locationDTO.getCode());
            }
        }
        this.logger.info("\u5546\u6237\u57ce\u5e02\u5b9a\u4f4d\uff1a{},\u533a\u53bf\u5b9a\u4f4d:{}\uff0c\u6700\u7ec8\u5b9a\u4f4d\uff1a{}", new Object[]{merchantInfo.getCityCode(), merchantInfo.getCountyCode(), merchantInfo.getAreaCode()});
    }
}

