/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.bxm.localnews.merchant.domain.MerchantCategoryMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsSampleMapper;
import com.bxm.localnews.merchant.entity.MerchantCategoryEntity;
import com.bxm.localnews.merchant.param.CategoryCreateParam;
import com.bxm.localnews.merchant.service.CategoryService;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsSampleVO;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CategoryServiceImpl
implements CategoryService {
    private MerchantCategoryMapper merchantCategoryMapper;
    private MerchantGoodsSampleMapper merchantGoodsSampleMapper;

    @Override
    public Message create(CategoryCreateParam categoryCreateParam) {
        MerchantCategoryEntity merchantCategoryEntity = new MerchantCategoryEntity();
        merchantCategoryEntity.setVipPrice(categoryCreateParam.getVipPrice());
        merchantCategoryEntity.setCatName(categoryCreateParam.getCatName());
        merchantCategoryEntity.setCreateTime(new Date());
        merchantCategoryEntity.setParentId(Long.valueOf(0L));
        this.merchantCategoryMapper.insertSelective(merchantCategoryEntity);
        this.after(merchantCategoryEntity.getId(), categoryCreateParam.getCatName());
        return Message.build((boolean)true);
    }

    @Async
    public void after(Long categoryId, String catName) {
        MerchantGoodsSampleVO merchantGoodsSampleVO = new MerchantGoodsSampleVO();
        merchantGoodsSampleVO.setCategoryId(categoryId);
        merchantGoodsSampleVO.setCatName(catName);
        merchantGoodsSampleVO.setCreateTime(new Date());
        this.merchantGoodsSampleMapper.insertSelective(merchantGoodsSampleVO);
    }

    @Override
    public Message synchronizeGoodsData() {
        List merchantCategoryEntities = this.merchantCategoryMapper.selectAll();
        if (!CollectionUtils.isEmpty((Collection)merchantCategoryEntities)) {
            merchantCategoryEntities.forEach(merchantCategoryEntity -> {
                MerchantGoodsSampleVO merchantGoodsSampleVO = new MerchantGoodsSampleVO();
                merchantGoodsSampleVO.setCatName(merchantCategoryEntity.getCatName());
                merchantGoodsSampleVO.setCategoryId(merchantCategoryEntity.getId());
                merchantGoodsSampleVO.setCreateTime(new Date());
                this.merchantGoodsSampleMapper.insertSelective(merchantGoodsSampleVO);
            });
        }
        return Message.build((boolean)true);
    }

    public CategoryServiceImpl(MerchantCategoryMapper merchantCategoryMapper, MerchantGoodsSampleMapper merchantGoodsSampleMapper) {
        this.merchantCategoryMapper = merchantCategoryMapper;
        this.merchantGoodsSampleMapper = merchantGoodsSampleMapper;
    }
}

