/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.merchant.common.enums.MerchantAccountTypeEnum;
import com.bxm.localnews.merchant.domain.MerchantCategoryMapper;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantPrerogativeInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantPrerogativeRecodeMapper;
import com.bxm.localnews.merchant.dto.InterestsInfoDTO;
import com.bxm.localnews.merchant.dto.account.MerchantAccountInfoDTO;
import com.bxm.localnews.merchant.entity.MerchantCategoryEntity;
import com.bxm.localnews.merchant.entity.MerchantPrerogativeInfoEntity;
import com.bxm.localnews.merchant.entity.MerchantPrerogativeRecodeEntity;
import com.bxm.localnews.merchant.entity.MerchantUserPromotionAccountEntity;
import com.bxm.localnews.merchant.param.InterestsInfoParam;
import com.bxm.localnews.merchant.param.MerchantOpenVipParam;
import com.bxm.localnews.merchant.service.InterestsService;
import com.bxm.localnews.merchant.service.MerchantRedisRefresh;
import com.bxm.localnews.merchant.service.MerchantUserProAccountService;
import com.bxm.localnews.merchant.service.account.UserProAccountStrategy;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.localnews.merchant.vo.MerchantUserAccountVO;
import com.bxm.newidea.component.exceptions.BusinessException;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InterestsServiceImpl
implements InterestsService {
    private static final Logger log = LoggerFactory.getLogger(InterestsServiceImpl.class);
    private final MerchantInfoMapper merchantInfoMapper;
    private final MerchantPrerogativeInfoMapper merchantPrerogativeInfoMapper;
    private final MerchantPrerogativeRecodeMapper merchantPrerogativeRecodeMapper;
    private final MerchantCategoryMapper merchantCategoryMapper;
    private final MerchantUserProAccountService merchantUserProAccountService;
    private final UserProAccountStrategy userProAccountStrategy;
    private final MerchantRedisRefresh merchantRedisRefresh;

    @Autowired
    public InterestsServiceImpl(MerchantInfoMapper merchantInfoMapper, MerchantPrerogativeInfoMapper merchantPrerogativeInfoMapper, MerchantPrerogativeRecodeMapper merchantPrerogativeRecodeMapper, MerchantCategoryMapper merchantCategoryMapper, MerchantUserProAccountService merchantUserProAccountService, UserProAccountStrategy userProAccountStrategy, MerchantRedisRefresh merchantRedisRefresh) {
        this.merchantInfoMapper = merchantInfoMapper;
        this.merchantPrerogativeInfoMapper = merchantPrerogativeInfoMapper;
        this.merchantPrerogativeRecodeMapper = merchantPrerogativeRecodeMapper;
        this.merchantCategoryMapper = merchantCategoryMapper;
        this.merchantUserProAccountService = merchantUserProAccountService;
        this.userProAccountStrategy = userProAccountStrategy;
        this.merchantRedisRefresh = merchantRedisRefresh;
    }

    @Override
    public PageWarper<InterestsInfoDTO> getPageList(InterestsInfoParam interestsInfoParam) {
        PageWarper pageWarper = new PageWarper(this.merchantInfoMapper.getInterestsPageList(interestsInfoParam));
        if (!CollectionUtils.isEmpty((Collection)pageWarper.getList())) {
            pageWarper.getList().forEach(this::completeInterests);
        }
        return pageWarper;
    }

    @Override
    public InterestsInfoDTO getByPhone(String phone) {
        InterestsInfoDTO interestsInfoDTO = this.merchantInfoMapper.getByPhone(phone);
        if (null == interestsInfoDTO) {
            throw new BusinessException("\u8be5\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u5bf9\u5e94\u5546\u94fa\u672a\u5ba1\u6838\u901a\u8fc7");
        }
        MerchantCategoryEntity merchantCategoryEntity = this.merchantCategoryMapper.selectByPrimaryKey(interestsInfoDTO.getIndustryId());
        if (null != merchantCategoryEntity) {
            interestsInfoDTO.setIndustryName(merchantCategoryEntity.getCatName());
        }
        interestsInfoDTO.setDeductionMoney(this.merchantUserProAccountService.getUserProAccount(interestsInfoDTO.getId()).getAbleProCash());
        return interestsInfoDTO;
    }

    @Override
    @Transactional
    public Boolean openVip(MerchantOpenVipParam merchantOpenVipParam, int num) {
        if (num >= 3) {
            return false;
        }
        MerchantUserAccountVO userAccountVO = this.merchantUserProAccountService.getUserProAccount(merchantOpenVipParam.getId());
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantOpenVipParam.getId());
        MerchantCategoryEntity categoryEntity = this.merchantCategoryMapper.selectByPrimaryKey(merchantInfo.getCategoryId());
        this.checkParam(merchantOpenVipParam, userAccountVO, categoryEntity);
        Message message = this.userProAccountStrategy.exection(this.convertSub(merchantOpenVipParam));
        if (message.isSuccess()) {
            this.addPreroInfoEntity(merchantOpenVipParam);
            this.addPreroRecordEntity(merchantOpenVipParam);
            this.merchantUserProAccountService.refreshAccount(merchantOpenVipParam.getId());
            this.merchantRedisRefresh.refreshMerchantList(merchantOpenVipParam.getId());
        } else {
            log.debug("\u66f4\u65b0\u5931\u8d25\uff0c\u63a8\u5e7f\u91d1[{}]~~~", (Object)JSONObject.toJSONString((Object)userAccountVO));
            this.merchantUserProAccountService.refreshAccount(merchantOpenVipParam.getId());
            this.openVip(merchantOpenVipParam, ++num);
        }
        return true;
    }

    @Override
    public Boolean updateRemark(MerchantOpenVipParam merchantOpenVipParam) {
        MerchantInfo merchantInfo = new MerchantInfo();
        merchantInfo.setId(merchantOpenVipParam.getId());
        merchantInfo.setRemark(merchantOpenVipParam.getRemark());
        return this.merchantInfoMapper.updateByPrimaryKeySelective(merchantInfo) > 0;
    }

    private void completeInterests(InterestsInfoDTO entity) {
        MerchantCategoryEntity merchantCategoryEntity;
        MerchantPrerogativeRecodeEntity recordEntity;
        MerchantPrerogativeInfoEntity preroEntity;
        if (null == entity) {
            return;
        }
        if (null != entity.getInterestsType() && null != (preroEntity = this.merchantPrerogativeInfoMapper.selectByMerchantId(entity.getId(), null))) {
            entity.setCreateTime(preroEntity.getStartTime());
            entity.setEndTime(preroEntity.getEndTime());
        }
        if (null != (recordEntity = this.merchantPrerogativeRecodeMapper.getSumPayDeduction(entity.getId(), entity.getInterestsType()))) {
            entity.setPayMoney(recordEntity.getPayAmt());
            entity.setDeductionMoney(recordEntity.getDeductionAmt());
        }
        if (null != (merchantCategoryEntity = this.merchantCategoryMapper.selectByPrimaryKey(entity.getIndustryId()))) {
            entity.setIndustryName(merchantCategoryEntity.getCatName());
        }
    }

    private void checkParam(MerchantOpenVipParam merchantOpenVipParam, MerchantUserAccountVO userAccountVO, MerchantCategoryEntity categoryEntity) {
        if (new BigDecimal(merchantOpenVipParam.getDeductionMoney()).compareTo(userAccountVO.getAbleProCash()) > 0) {
            throw new BusinessException("\u4f7f\u7528\u63a8\u5e7f\u91d1\u4e0d\u80fd\u5927\u4e8e\u53ef\u7528\u63a8\u5e7f\u91d1");
        }
    }

    private MerchantAccountInfoDTO convertSub(MerchantOpenVipParam merchantOpenVipParam) {
        MerchantAccountInfoDTO entity = new MerchantAccountInfoDTO();
        entity.setAmount(new BigDecimal(merchantOpenVipParam.getDeductionMoney()));
        entity.setMerchantId(merchantOpenVipParam.getId());
        entity.setRelationId(merchantOpenVipParam.getId());
        entity.setType(MerchantAccountTypeEnum.OPEN_MERCHANT_VIP);
        return entity;
    }

    private MerchantUserPromotionAccountEntity convertAdd(MerchantOpenVipParam merchantOpenVipParam) {
        MerchantUserPromotionAccountEntity entity = new MerchantUserPromotionAccountEntity();
        entity.setAblePromotionCash(new BigDecimal(merchantOpenVipParam.getDeductionMoney()));
        entity.setConsumePromotionCash(new BigDecimal(merchantOpenVipParam.getDeductionMoney()));
        return entity;
    }

    private void addPreroInfoEntity(MerchantOpenVipParam merchantOpenVipParam) {
        MerchantPrerogativeInfoEntity prerogativeInfoEntity = this.merchantPrerogativeInfoMapper.selectByMerchantId(merchantOpenVipParam.getId(), merchantOpenVipParam.getInterestsType());
        if (null == prerogativeInfoEntity) {
            prerogativeInfoEntity = new MerchantPrerogativeInfoEntity();
            prerogativeInfoEntity.setMerchantId(merchantOpenVipParam.getId());
            prerogativeInfoEntity.setPrerogativeType(merchantOpenVipParam.getInterestsType());
            prerogativeInfoEntity.setStatus(Integer.valueOf(1));
            prerogativeInfoEntity.setStartTime(new Date());
            prerogativeInfoEntity.setEndTime(DateUtils.addYears((Date)new Date(), (int)1));
            this.merchantPrerogativeInfoMapper.insert(prerogativeInfoEntity);
        } else {
            if (prerogativeInfoEntity.getStatus().equals(1)) {
                prerogativeInfoEntity.setEndTime(DateUtils.addYears((Date)prerogativeInfoEntity.getEndTime(), (int)1));
            } else {
                prerogativeInfoEntity.setEndTime(DateUtils.addYears((Date)new Date(), (int)1));
            }
            prerogativeInfoEntity.setId(prerogativeInfoEntity.getId());
            prerogativeInfoEntity.setMerchantId(merchantOpenVipParam.getId());
            prerogativeInfoEntity.setPrerogativeType(merchantOpenVipParam.getInterestsType());
            prerogativeInfoEntity.setStatus(Integer.valueOf(1));
            this.merchantPrerogativeInfoMapper.updateByPrimaryKeySelective(prerogativeInfoEntity);
        }
    }

    private void addPreroRecordEntity(MerchantOpenVipParam merchantOpenVipParam) {
        MerchantPrerogativeRecodeEntity prerogativeRecodeEntity = new MerchantPrerogativeRecodeEntity();
        prerogativeRecodeEntity.setCreateTime(new Date());
        prerogativeRecodeEntity.setDeductionAmt(new BigDecimal(merchantOpenVipParam.getDeductionMoney()));
        prerogativeRecodeEntity.setPrerogativeType(merchantOpenVipParam.getInterestsType());
        if (merchantOpenVipParam.getDeductionMoney().equals("0")) {
            prerogativeRecodeEntity.setDeductionType(Integer.valueOf(0));
        } else {
            prerogativeRecodeEntity.setDeductionType(Integer.valueOf(1));
        }
        prerogativeRecodeEntity.setMerchantId(merchantOpenVipParam.getId());
        prerogativeRecodeEntity.setOpenType(merchantOpenVipParam.getOpenType());
        prerogativeRecodeEntity.setPayAmt(new BigDecimal(merchantOpenVipParam.getPayMoney()));
        this.merchantPrerogativeRecodeMapper.insert(prerogativeRecodeEntity);
    }
}

