/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.merchant.common.constant.MerchantStatusEnum;
import com.bxm.localnews.merchant.common.enums.MerchantAccountTypeEnum;
import com.bxm.localnews.merchant.common.utils.ImportUtils;
import com.bxm.localnews.merchant.config.MerchantProperties;
import com.bxm.localnews.merchant.domain.MerchantActivityMapper;
import com.bxm.localnews.merchant.domain.MerchantAuthInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantMemberMapper;
import com.bxm.localnews.merchant.domain.MerchantOperationLogMapper;
import com.bxm.localnews.merchant.dto.ManageMerchantInfoDto;
import com.bxm.localnews.merchant.dto.MechantTeamInfosDTO;
import com.bxm.localnews.merchant.dto.MerchantAdvertInfoDTO;
import com.bxm.localnews.merchant.dto.MerchantAuthInfoDto;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.account.MerchantAccountInfoDTO;
import com.bxm.localnews.merchant.integration.BizLogIntegrationService;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.AuditAuthInfoParam;
import com.bxm.localnews.merchant.param.CreateParam;
import com.bxm.localnews.merchant.param.ManageMerchantInfoAddParam;
import com.bxm.localnews.merchant.param.ManageMerchantInfoParam;
import com.bxm.localnews.merchant.param.MerchantAdvertParam;
import com.bxm.localnews.merchant.param.MerchantIntoApplyParam;
import com.bxm.localnews.merchant.param.MerchantManageListParam;
import com.bxm.localnews.merchant.param.manager.MemberTeamParam;
import com.bxm.localnews.merchant.service.MerchantInfoManageService;
import com.bxm.localnews.merchant.service.MerchantRedisRefresh;
import com.bxm.localnews.merchant.service.MerchantUserProAccountService;
import com.bxm.localnews.merchant.service.MerchantUserService;
import com.bxm.localnews.merchant.service.PushIntegrationService;
import com.bxm.localnews.merchant.service.account.UserProAccountStrategy;
import com.bxm.localnews.merchant.service.goods.GoodsService;
import com.bxm.localnews.merchant.service.impl.BaseMerchantInfoService;
import com.bxm.localnews.merchant.vo.MerchantAdvertInfoVo;
import com.bxm.localnews.merchant.vo.MerchantAuthInfo;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.localnews.merchant.vo.MerchantInfoListVo;
import com.bxm.localnews.merchant.vo.MerchantOperationLog;
import com.bxm.localnews.merchant.vo.goods.GoodsSortVo;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MerchantInfoManageServiceImpl
extends BaseMerchantInfoService
implements MerchantInfoManageService {
    private SequenceCreater sequenceCreater;
    private MerchantInfoMapper merchantInfoMapper;
    private MerchantAuthInfoMapper merchantAuthInfoMapper;
    private PushIntegrationService pushIntegrationService;
    private MerchantRedisRefresh merchantRedisRefresh;
    private UserProAccountStrategy userProAccountStrategy;
    private BizLogIntegrationService bizLogIntegrationService;
    private MerchantOperationLogMapper merchantOperationLogMapper;
    private MerchantProperties merchantProperties;
    private MessageSender messageSender;
    private MerchantUserProAccountService merchantUserProAccountService;
    private MerchantActivityMapper merchantActivityMapper;
    private MerchantMemberMapper merchantMemberMapper;
    private UserIntegrationService userIntegrationService;
    private MerchantUserService merchantUserService;
    private MerchantGoodsMapper merchantGoodsMapper;
    private GoodsService goodsService;

    @Override
    public Message getAuthInfo(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
        if (merchantInfo == null) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u5546\u6237\u4fe1\u606f:[{}]", (Object)merchantId);
            return Message.build((boolean)false, (String)"\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MerchantAuthInfo merchantAuthInfo = this.merchantAuthInfoMapper.selectByMerchantId(merchantId);
        MerchantAuthInfoDto merchantAuthInfoDto = new MerchantAuthInfoDto();
        merchantAuthInfoDto.setMerchantName(merchantInfo.getMerchantName());
        merchantAuthInfoDto.setCategoryId(merchantInfo.getCategoryId());
        if (merchantAuthInfo != null) {
            BeanUtils.copyProperties((Object)merchantAuthInfo, (Object)merchantAuthInfoDto);
        }
        return Message.build().addParam("merchantAuthInfoDto", (Object)merchantAuthInfoDto);
    }

    @Override
    public Message auditAuthInfo(AuditAuthInfoParam auditAuthInfoParam) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(auditAuthInfoParam.getMerchantId());
        if (merchantInfo == null) {
            this.logger.info("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\u5931\u8d25:[{}]", (Object)JSON.toJSONString((Object)auditAuthInfoParam));
            return Message.build((boolean)false, (String)"\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\u5931\u8d25");
        }
        MerchantAuthInfo merchantAuthInfo = new MerchantAuthInfo();
        BeanUtils.copyProperties((Object)auditAuthInfoParam, (Object)merchantAuthInfo);
        merchantAuthInfo.setModifyTime(new Date());
        if (this.merchantAuthInfoMapper.selectByMerchantId(auditAuthInfoParam.getMerchantId()) == null) {
            this.merchantAuthInfoMapper.insertSelective(merchantAuthInfo);
        } else {
            this.merchantAuthInfoMapper.updateByPrimaryKeySelective(merchantAuthInfo);
        }
        List merchantOperationLogs = this.merchantOperationLogMapper.selectByMerchantId(auditAuthInfoParam.getMerchantId(), MerchantStatusEnum.OPERATOR_SHELF_SUCCESS.getType());
        if (Objects.equals(MerchantStatusEnum.QUALIFICATION_SUCCESS.getType(), auditAuthInfoParam.getQualificationStatus())) {
            merchantInfo.setQualificationStatus(MerchantStatusEnum.QUALIFICATION_SUCCESS.getType());
            if (CollectionUtils.isNotEmpty((Collection)merchantOperationLogs)) {
                this.pushIntegrationService.pushShelfStatusMsg(merchantInfo, MerchantStatusEnum.SHELF_SUCCESS, null);
            }
            if (Objects.equals(merchantInfo.getIsShelf(), MerchantStatusEnum.SHELF_NOTAUDIT.getType())) {
                MerchantAccountInfoDTO merchantAccountInfoDTO = new MerchantAccountInfoDTO();
                merchantAccountInfoDTO.setType(MerchantAccountTypeEnum.QUALIFICATION_SUCCESS);
                merchantAccountInfoDTO.setMerchantId(auditAuthInfoParam.getMerchantId());
                merchantAccountInfoDTO.setUserId(merchantInfo.getUserId());
                this.userProAccountStrategy.exection(merchantAccountInfoDTO);
                this.pushIntegrationService.pushQualificationStatusMsg(merchantInfo, MerchantStatusEnum.QUALIFICATION_SUCCESS, auditAuthInfoParam.getRemark());
            }
            merchantInfo.setIsShelf(MerchantStatusEnum.SHELF_SUCCESS.getType());
            this.pointAdd(merchantInfo);
            this.refreshCache(merchantInfo);
            this.addLog(auditAuthInfoParam.getMerchantId(), MerchantStatusEnum.OPERATOR_QUALIFICATION_SUCCESS.getType(), auditAuthInfoParam.getAuditUserId());
            this.addLog(auditAuthInfoParam.getMerchantId(), MerchantStatusEnum.OPERATOR_SHELF_SUCCESS.getType(), auditAuthInfoParam.getAuditUserId());
        }
        if (Objects.equals(MerchantStatusEnum.QUALIFICATION_FAIL.getType(), auditAuthInfoParam.getQualificationStatus())) {
            merchantInfo.setQualificationStatus(MerchantStatusEnum.QUALIFICATION_FAIL.getType());
            if (Objects.equals(merchantInfo.getIsShelf(), MerchantStatusEnum.SHELF_NOTAUDIT.getType())) {
                this.pushIntegrationService.pushQualificationStatusMsg(merchantInfo, MerchantStatusEnum.QUALIFICATION_FAIL, auditAuthInfoParam.getRemark());
            }
            if (CollectionUtils.isNotEmpty((Collection)merchantOperationLogs)) {
                this.goodsService.shelfDownAllGoods(merchantInfo.getId());
                merchantInfo.setIsShelf(MerchantStatusEnum.SHELF_FAIL.getType());
                this.pushIntegrationService.pushShelfStatusMsg(merchantInfo, MerchantStatusEnum.SHELF_FAIL, auditAuthInfoParam.getRemark());
                this.refreshCache(merchantInfo);
                this.addLog(auditAuthInfoParam.getMerchantId(), MerchantStatusEnum.OPERATOR_SHELF_FAIL.getType(), auditAuthInfoParam.getAuditUserId());
            }
            this.addLog(auditAuthInfoParam.getMerchantId(), MerchantStatusEnum.OPERATOR_QUALIFICATION_FAIL.getType(), auditAuthInfoParam.getAuditUserId());
        }
        this.merchantInfoMapper.updateByPrimaryKeySelective(merchantInfo);
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    public void addMerchantRemark(Long merchantId, String remark) {
        MerchantInfo merchantInfo = new MerchantInfo();
        merchantInfo.setId(merchantId);
        merchantInfo.setRemark(remark);
        int i = this.merchantInfoMapper.updateByPrimaryKeySelective(merchantInfo);
        if (i <= 0) {
            this.logger.info("\u6dfb\u52a0\u5907\u6ce8\u64cd\u4f5c\u5931\u8d25:[{}]", (Object)JSONObject.toJSONString((Object)merchantInfo));
        }
    }

    @Override
    public Message getMerchantInfo(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
        if (merchantInfo == null) {
            this.logger.info("\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u5931\u8d25:[{}]", (Object)merchantId);
            return Message.build((boolean)false, (String)"\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ManageMerchantInfoDto manageMerchantInfoDto = new ManageMerchantInfoDto();
        BeanUtils.copyProperties((Object)merchantInfo, (Object)manageMerchantInfoDto);
        return Message.build().addParam("manageMerchantInfoDto", (Object)manageMerchantInfoDto);
    }

    @Override
    public Message saveMerchantInfo(ManageMerchantInfoParam manageMerchantInfoParam) {
        MerchantInfo merchant = this.merchantInfoMapper.selectByPrimaryKey(manageMerchantInfoParam.getMerchantId());
        if (merchant == null) {
            this.logger.info("\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u5931\u8d25:[{}]", (Object)manageMerchantInfoParam.getMerchantId());
            return Message.build((boolean)false, (String)"\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        MerchantInfo merchantInfo = this.fillMerchantInfo((MerchantIntoApplyParam)manageMerchantInfoParam);
        if (!StringUtils.equals((String)merchantInfo.getAreaCode(), (String)merchant.getAreaCode())) {
            this.merchantRedisRefresh.removeMerchantList(merchant.getAreaCode(), merchant.getCategoryId());
        }
        if (Objects.equals(manageMerchantInfoParam.getIsShelf(), merchant.getIsShelf())) {
            this.merchantInfoMapper.updateByPrimaryKeySelective(merchantInfo);
            this.merchantRedisRefresh.removeMerchantUserCache(merchant.getUserId());
            return Message.build((boolean)true, (String)"\u5e97\u94fa\u4fe1\u606f\u4fee\u6539\u6210\u529f");
        }
        if (!Objects.equals(merchant.getQualificationStatus(), MerchantStatusEnum.QUALIFICATION_SUCCESS.getType())) {
            this.logger.info("\u8d44\u8d28\u8ba4\u8bc1\u672a\u901a\u8fc7,\u4e0d\u80fd\u64cd\u4f5c\u4e0a\u4e0b\u67b6:[{}]", (Object)JSONObject.toJSONString((Object)manageMerchantInfoParam));
            merchantInfo.setIsShelf(merchant.getIsShelf());
            this.merchantInfoMapper.updateByPrimaryKeySelective(merchantInfo);
            this.merchantRedisRefresh.removeMerchantUserCache(merchant.getUserId());
            return Message.build((boolean)true, (String)"\u5e97\u94fa\u4fe1\u606f\u4fee\u6539\u6210\u529f,\u4f46\u8d44\u8d28\u8ba4\u8bc1\u672a\u901a\u8fc7,\u4e0d\u80fd\u64cd\u4f5c\u4e0a\u4e0b\u67b6");
        }
        this.merchantInfoMapper.updateByPrimaryKeySelective(merchantInfo);
        if (Objects.equals(MerchantStatusEnum.SHELF_SUCCESS.getType(), manageMerchantInfoParam.getIsShelf())) {
            this.pushIntegrationService.pushShelfStatusMsg(merchantInfo, MerchantStatusEnum.SHELF_SUCCESS, null);
            this.refreshCache(merchantInfo);
            this.addLog(manageMerchantInfoParam.getMerchantId(), MerchantStatusEnum.OPERATOR_SHELF_SUCCESS.getType(), manageMerchantInfoParam.getAuditUserId());
        }
        if (Objects.equals(MerchantStatusEnum.SHELF_FAIL.getType(), manageMerchantInfoParam.getIsShelf())) {
            this.goodsService.shelfDownAllGoods(merchant.getId());
            this.pushIntegrationService.pushShelfStatusMsg(merchantInfo, MerchantStatusEnum.SHELF_FAIL, manageMerchantInfoParam.getRemovalReason());
            this.refreshCache(merchantInfo);
            this.addLog(manageMerchantInfoParam.getMerchantId(), MerchantStatusEnum.OPERATOR_SHELF_FAIL.getType(), manageMerchantInfoParam.getAuditUserId());
        }
        return Message.build((boolean)true, (String)"\u5e97\u94fa\u4fe1\u606f\u4fee\u6539\u6210\u529f");
    }

    private void addLog(Long merchantId, Integer type, Long currentUserId) {
        MerchantOperationLog merchantOperationLog = new MerchantOperationLog();
        merchantOperationLog.setUserId(currentUserId);
        merchantOperationLog.setMerchantId(merchantId);
        merchantOperationLog.setCreateTime(new Date());
        merchantOperationLog.setType(type);
        this.merchantOperationLogMapper.insertSelective(merchantOperationLog);
    }

    private void pointAdd(MerchantInfo merchantInfo) {
        PointReportParam reportParam = PointReportParam.build().e("3034").ev("121." + merchantInfo.getId()).put("uid", merchantInfo.getUserId() + "");
        this.bizLogIntegrationService.point(reportParam);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5546\u5bb6\u901a\u8fc7\u8d44\u8d28\u8ba4\u8bc1\u4e8b\u4ef6\uff0c\u8bf7\u6c42\u53c2\u6570: {}", (Object)reportParam);
        }
    }

    private void refreshCache(MerchantInfo merchant) {
        this.merchantRedisRefresh.removeMerchantUserCache(merchant.getUserId());
        this.merchantRedisRefresh.refreshMerchantList(merchant.getId());
    }

    @Override
    public PageWarper<MerchantInfoListVo> getMerchantList(MerchantManageListParam merchantManageListParam) {
        List merchantInfoList = this.merchantInfoMapper.queryMerchantListByPage(merchantManageListParam);
        if (CollectionUtils.isNotEmpty((Collection)merchantInfoList)) {
            List merchantIds = merchantInfoList.stream().map(MerchantInfoListVo::getId).collect(Collectors.toList());
            List merchantAuthInfos = this.merchantAuthInfoMapper.selectByMerchantIds(merchantIds);
            merchantInfoList.forEach(merchant -> {
                if (merchant.getAblePromotionCash() != null) {
                    merchant.setAblePromotionCash(merchant.getAblePromotionCash().setScale(2, 1));
                }
                Optional<MerchantAuthInfo> match = merchantAuthInfos.stream().filter(authInfo -> Objects.equals(authInfo.getMerchantId(), merchant.getId())).findFirst();
                match.ifPresent(merchantAuthInfo -> merchant.setBusinessLicenseType(merchantAuthInfo.getType()));
                List infos = this.merchantActivityMapper.selectByMerchantId(merchant.getId());
                merchant.setMerchantAdvertStatus(Integer.valueOf(CollectionUtils.isEmpty((Collection)infos) ? 0 : (((MerchantAdvertInfoVo)infos.get(0)).getStatus() == 0 ? 2 : 1)));
                merchant.setMerchantTeamNum(this.merchantMemberMapper.memberNum(merchant.getId()));
                GoodsSortVo goodsSortVo = this.merchantGoodsMapper.selectTotalByMerchantId(merchant.getId());
                merchant.setGoodsNum(Objects.nonNull(goodsSortVo) ? goodsSortVo.getTotal() : null);
            });
            return new PageWarper(merchantInfoList);
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    @Override
    public Message insertMerchantInfo(ManageMerchantInfoAddParam manageMerchantInfoAddParam) {
        if (CollectionUtils.isNotEmpty((Collection)this.merchantInfoMapper.selectByMobile(manageMerchantInfoAddParam.getMobile()))) {
            return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u5df2\u7ed1\u5b9a\u8be5\u624b\u673a\u53f7,\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a");
        }
        if (this.merchantInfoMapper.selectByUserId(manageMerchantInfoAddParam.getUserId()) != null) {
            return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u5df2\u7ed1\u5b9a\u5546\u6237,\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a");
        }
        MerchantInfo merchantInfo = new MerchantInfo();
        BeanUtils.copyProperties((Object)manageMerchantInfoAddParam, (Object)merchantInfo);
        merchantInfo.setId(this.sequenceCreater.nextLongId());
        merchantInfo.setCreateTime(new Date());
        if (this.merchantInfoMapper.insert(merchantInfo) <= 0) {
            this.logger.info("\u65b0\u589e\u5546\u5bb6\u4fe1\u606f\u5931\u8d25:[{}]", (Object)JSONObject.toJSONString((Object)manageMerchantInfoAddParam));
        } else {
            this.afterEnterSuccess(merchantInfo);
        }
        this.merchantUserProAccountService.initProAccount(manageMerchantInfoAddParam.getUserId());
        this.merchantUserService.bossCreate(merchantInfo.getId(), merchantInfo.getUserId());
        return Message.build((boolean)true, (String)"\u65b0\u589e\u5e97\u94fa\u6210\u529f");
    }

    private void afterEnterSuccess(MerchantInfo merchantInfo) {
        if (this.merchantProperties.getEnableEnterNotify().booleanValue()) {
            this.messageSender.sendDingtalk(DingtalkMessage.builder().scene("mct").content("\u6709\u65b0\u7684\u5546\u6237\u7533\u8bf7\u5165\u9a7b\uff1a" + merchantInfo.getMerchantName()).build());
        }
    }

    @Override
    public MerchantAdvertInfoDTO merchantAdvertInfo(Long merchantId) {
        List infos = this.merchantActivityMapper.selectByMerchantId(merchantId);
        if (!CollectionUtils.isEmpty((Collection)infos)) {
            List result = infos.stream().map(item -> {
                MerchantAdvertInfoDTO merchantAdvertInfoDTO = new MerchantAdvertInfoDTO();
                BeanUtils.copyProperties((Object)item, (Object)merchantAdvertInfoDTO);
                return merchantAdvertInfoDTO;
            }).collect(Collectors.toList());
            return (MerchantAdvertInfoDTO)result.get(0);
        }
        return null;
    }

    @Override
    public Boolean editMerchantAdvert(MerchantAdvertParam param) {
        MerchantAdvertInfoVo entity = new MerchantAdvertInfoVo();
        BeanUtils.copyProperties((Object)param, (Object)entity);
        if (Objects.isNull(param.getId())) {
            this.merchantActivityMapper.save(entity);
        } else {
            this.merchantActivityMapper.updateMerchantAdvert(entity);
        }
        return Boolean.TRUE;
    }

    @Override
    public PageWarper<MechantTeamInfosDTO> getMemberInfo(MemberTeamParam param) {
        List listFromDb = this.merchantMemberMapper.getMemberForIdAndNickname(param);
        if (CollectionUtils.isEmpty((Collection)listFromDb)) {
            return new PageWarper();
        }
        List<MechantTeamInfosDTO> result = listFromDb.stream().map(item -> {
            MechantTeamInfosDTO mechantTeamInfosDTO = new MechantTeamInfosDTO();
            BeanUtils.copyProperties((Object)item, (Object)mechantTeamInfosDTO);
            return mechantTeamInfosDTO;
        }).collect(Collectors.toList());
        result.forEach(bean -> {
            UserInfoDTO user = this.userIntegrationService.getUserFromRedisDB(bean.getUserId());
            if (Objects.nonNull(user)) {
                bean.setPhone(Objects.nonNull(user.getPhone()) ? user.getPhone() : null);
                bean.setAreaName(Objects.nonNull(user.getLocationName()) ? user.getLocationName() : null);
            }
        });
        return new PageWarper(result);
    }

    @Override
    public void readExcel(MultipartFile multipartFiles) {
        if (null == multipartFiles) {
            return;
        }
        Long merchantId = null;
        List resultList = ImportUtils.readExcelFile((MultipartFile)multipartFiles);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u89e3\u6790\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resultList));
        }
        if (resultList == null) {
            return;
        }
        for (List result : resultList) {
            this.logger.debug("\u89e3\u6790\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)result));
            if (result.size() < 2) continue;
            String bossPhone = (String)result.get(1);
            merchantId = Long.valueOf(bossPhone);
        }
        for (List result : resultList) {
            if (StringUtils.isBlank((String)((String)result.get(0)))) continue;
            Long employeeId = Long.valueOf((String)result.get(0));
            CreateParam createParam = new CreateParam();
            createParam.setPush(Integer.valueOf(0));
            createParam.setMerchantId(merchantId);
            createParam.setUserId(employeeId);
            this.merchantUserService.create(createParam);
        }
    }

    public MerchantInfoManageServiceImpl(SequenceCreater sequenceCreater, MerchantInfoMapper merchantInfoMapper, MerchantAuthInfoMapper merchantAuthInfoMapper, PushIntegrationService pushIntegrationService, MerchantRedisRefresh merchantRedisRefresh, UserProAccountStrategy userProAccountStrategy, BizLogIntegrationService bizLogIntegrationService, MerchantOperationLogMapper merchantOperationLogMapper, MerchantProperties merchantProperties, MessageSender messageSender, MerchantUserProAccountService merchantUserProAccountService, MerchantActivityMapper merchantActivityMapper, MerchantMemberMapper merchantMemberMapper, UserIntegrationService userIntegrationService, MerchantUserService merchantUserService, MerchantGoodsMapper merchantGoodsMapper, GoodsService goodsService) {
        this.sequenceCreater = sequenceCreater;
        this.merchantInfoMapper = merchantInfoMapper;
        this.merchantAuthInfoMapper = merchantAuthInfoMapper;
        this.pushIntegrationService = pushIntegrationService;
        this.merchantRedisRefresh = merchantRedisRefresh;
        this.userProAccountStrategy = userProAccountStrategy;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.merchantOperationLogMapper = merchantOperationLogMapper;
        this.merchantProperties = merchantProperties;
        this.messageSender = messageSender;
        this.merchantUserProAccountService = merchantUserProAccountService;
        this.merchantActivityMapper = merchantActivityMapper;
        this.merchantMemberMapper = merchantMemberMapper;
        this.userIntegrationService = userIntegrationService;
        this.merchantUserService = merchantUserService;
        this.merchantGoodsMapper = merchantGoodsMapper;
        this.goodsService = goodsService;
    }
}

