/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.constant.MerchantMemberEnum;
import com.bxm.localnews.merchant.common.constant.MerchantStatusEnum;
import com.bxm.localnews.merchant.config.MerchantProperties;
import com.bxm.localnews.merchant.domain.MerchantAuthInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantCategoryMapper;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantPrerogativeInfoMapper;
import com.bxm.localnews.merchant.dto.IntoApplyDTO;
import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.dto.MerchantBusinessInfo;
import com.bxm.localnews.merchant.dto.MerchantInfoDto;
import com.bxm.localnews.merchant.dto.MerchantIntoInfoDto;
import com.bxm.localnews.merchant.dto.MerchantStatusDto;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.entity.MerchantCategoryEntity;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.MerchantAuthInfoParam;
import com.bxm.localnews.merchant.param.MerchantInfoParam;
import com.bxm.localnews.merchant.param.MerchantIntoApplyParam;
import com.bxm.localnews.merchant.param.MerchantStatusParam;
import com.bxm.localnews.merchant.service.MerchantInfoService;
import com.bxm.localnews.merchant.service.MerchantRedisRefresh;
import com.bxm.localnews.merchant.service.MerchantUserProAccountService;
import com.bxm.localnews.merchant.service.MerchantUserService;
import com.bxm.localnews.merchant.service.impl.BaseMerchantInfoService;
import com.bxm.localnews.merchant.vo.MerchantAuthInfo;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.localnews.merchant.vo.MerchantInfoSimpleVO;
import com.bxm.localnews.merchant.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.vo.MerchantUserAccountVO;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MerchantInfoServiceImpl
extends BaseMerchantInfoService
implements MerchantInfoService {
    private static final Logger log = LoggerFactory.getLogger(MerchantInfoServiceImpl.class);
    private MerchantInfoMapper merchantInfoMapper;
    private MerchantAuthInfoMapper merchantAuthInfoMapper;
    private RedisStringAdapter redisStringAdapter;
    private MerchantProperties merchantProperties;
    private SequenceCreater sequenceCreater;
    private MerchantCategoryMapper merchantCategoryMapper;
    private MessageSender messageSender;
    private MerchantUserProAccountService merchantUserProAccountService;
    private MerchantPrerogativeInfoMapper merchantPrerogativeInfoMapper;
    private UserIntegrationService userIntegrationService;
    private MerchantUserService merchantUserService;
    private DomainIntegrationService domainIntegrationService;
    private MerchantRedisRefresh merchantRedisRefresh;
    private final LocationIntegrationService locationIntegrationService;

    @Override
    public Message getMerchantInfo(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
        MerchantInfoDto merchantInfoDto = new MerchantInfoDto();
        if (merchantInfo == null) {
            this.logger.info("\u5546\u6237id\u83b7\u53d6\u4e0d\u5230\u5546\u6237\u4fe1\u606f:[{}]", (Object)merchantId);
            return Message.build((boolean)false, (String)"\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)merchantInfo, (Object)merchantInfoDto);
        MerchantCategoryEntity merchantCategoryEntity = this.merchantCategoryMapper.selectByPrimaryKey(merchantInfo.getCategoryId());
        if (merchantCategoryEntity != null) {
            merchantInfoDto.setCategoryName(merchantCategoryEntity.getCatName());
        }
        return Message.build((boolean)true).addParam("merchantInfoDto", (Object)merchantInfoDto);
    }

    @Override
    public Message enter(MerchantIntoApplyParam merchantIntoApplyParam) {
        if (!CollectionUtils.isEmpty((Collection)this.merchantInfoMapper.selectByMobile(merchantIntoApplyParam.getMobile()))) {
            return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u5df2\u7ed1\u5b9a\u8be5\u624b\u673a\u53f7,\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a");
        }
        if (this.merchantInfoMapper.selectByUserId(merchantIntoApplyParam.getUserId()) != null) {
            return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u5df2\u7ed1\u5b9a\u5546\u6237,\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a");
        }
        MerchantInfo merchantInfo = this.fillMerchantInfo(merchantIntoApplyParam);
        BeanUtils.copyProperties((Object)merchantIntoApplyParam, (Object)merchantInfo);
        merchantInfo.setId(this.sequenceCreater.nextLongId());
        merchantInfo.setCreateTime(new Date());
        if (this.merchantInfoMapper.insert(merchantInfo) <= 0) {
            this.logger.info("\u63d0\u4ea4\u5165\u9a7b\u5931\u8d25:[{}]", (Object)JSON.toJSONString((Object)merchantIntoApplyParam));
            return Message.build((boolean)false, (String)"\u63d0\u4ea4\u5165\u9a7b\u5931\u8d25");
        }
        this.afterEnterSuccess(merchantInfo);
        this.merchantUserProAccountService.initProAccount(merchantIntoApplyParam.getUserId());
        this.merchantUserService.bossCreate(merchantInfo.getId(), merchantInfo.getUserId());
        IntoApplyDTO intoApplyDTO = new IntoApplyDTO();
        intoApplyDTO.setMerchantId(merchantInfo.getId());
        return Message.build((boolean)true).addParam("intoApplyDTO", (Object)intoApplyDTO);
    }

    private void afterEnterSuccess(MerchantInfo merchantInfo) {
        if (this.merchantProperties.getEnableEnterNotify().booleanValue()) {
            this.messageSender.sendDingtalk(DingtalkMessage.builder().scene("mct").content("\u6709\u65b0\u7684\u5546\u6237\u7533\u8bf7\u5165\u9a7b\uff1a" + merchantInfo.getMerchantName()).build());
        }
        if (this.merchantProperties.getFollowUserIds().size() > 0 && merchantInfo.getUserId() != null) {
            this.merchantProperties.getFollowUserIds().forEach(fromUserId -> this.userIntegrationService.follow(fromUserId, merchantInfo.getUserId()));
        }
    }

    @Override
    public Message updateMerchantInfo(MerchantInfoParam merchantInfoParam) {
        MerchantInfo merchantInfo = this.fillMerchantInfo((MerchantIntoApplyParam)merchantInfoParam);
        merchantInfo.setSettlementStatus(MerchantStatusEnum.SETTLEMENT_ALREADY.getType());
        merchantInfo.setModifyTime(new Date());
        MerchantInfo fullMerchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantInfoParam.getMerchantId());
        if (!StringUtils.equals((String)merchantInfo.getAreaCode(), (String)fullMerchantInfo.getAreaCode())) {
            this.merchantRedisRefresh.removeMerchantList(fullMerchantInfo.getAreaCode(), fullMerchantInfo.getCategoryId());
        }
        if (this.merchantInfoMapper.updateByPrimaryKeySelective(merchantInfo) <= 0) {
            this.logger.info("\u66f4\u65b0\u5e97\u94fa\u4fe1\u606f\u5931\u8d25:[{}]", (Object)JSON.toJSONString((Object)merchantInfoParam));
            return Message.build((boolean)false, (String)"\u66f4\u65b0\u5e97\u94fa\u4fe1\u606f\u5931\u8d25");
        }
        this.merchantRedisRefresh.removeMerchantUserCache(fullMerchantInfo.getUserId());
        this.merchantRedisRefresh.refreshMerchantList(fullMerchantInfo.getId());
        return Message.build((boolean)true);
    }

    @Override
    public Message authApply(MerchantAuthInfoParam merchantAuthInfoParam) {
        if (this.merchantInfoMapper.selectByPrimaryKey(merchantAuthInfoParam.getMerchantId()) == null) {
            this.logger.info("\u5546\u6237id\u83b7\u53d6\u4e0d\u5230\u5546\u6237\u4fe1\u606f:[{}]", (Object)JSON.toJSONString((Object)merchantAuthInfoParam));
            return Message.build((boolean)false, (String)"\u5546\u6237id\u83b7\u53d6\u4e0d\u5230\u5546\u6237\u4fe1\u606f");
        }
        MerchantAuthInfo merchantAuthInfo = new MerchantAuthInfo();
        BeanUtils.copyProperties((Object)merchantAuthInfoParam, (Object)merchantAuthInfo);
        merchantAuthInfo.setCreateTime(new Date());
        merchantAuthInfo.setQualificationStatus(MerchantStatusEnum.QUALIFICATION_WILL.getType());
        if (this.merchantAuthInfoMapper.insertSelective(merchantAuthInfo) <= 0) {
            this.logger.info("\u63d0\u4ea4\u8d44\u8d28\u5ba1\u6838\u8d44\u6599\u65f6\u5931\u8d25:[{}]", (Object)JSON.toJSONString((Object)merchantAuthInfoParam));
            return Message.build((boolean)false, (String)"\u63d0\u4ea4\u8d44\u8d28\u5ba1\u6838\u8d44\u6599\u65f6\u5931\u8d25");
        }
        MerchantInfo merchantInfo = new MerchantInfo();
        merchantInfo.setId(merchantAuthInfoParam.getMerchantId());
        merchantInfo.setLastAuthTime(new Date());
        merchantInfo.setQualificationStatus(MerchantStatusEnum.QUALIFICATION_WILL.getType());
        merchantInfo.setCategoryId(merchantAuthInfoParam.getCategoryId());
        return Message.build((int)this.merchantInfoMapper.updateByPrimaryKeySelective(merchantInfo));
    }

    @Override
    public Message getIntoInfo(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
        if (merchantInfo == null) {
            this.logger.info("\u83b7\u53d6\u5165\u9a7b\u57fa\u672c\u4fe1\u606f\u5931\u8d25:[{}]", (Object)merchantId);
            return Message.build((boolean)false, (String)"\u83b7\u53d6\u5165\u9a7b\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
        }
        MerchantIntoInfoDto merchantIntoInfoDto = new MerchantIntoInfoDto();
        BeanUtils.copyProperties((Object)merchantInfo, (Object)merchantIntoInfoDto);
        return Message.build((boolean)true).addParam("merchantIntoInfoDto", (Object)merchantIntoInfoDto);
    }

    @Override
    public Message getBusinessInfo(Long merchantId) {
        String string;
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
        if (merchantInfo == null) {
            this.logger.info("\u83b7\u53d6\u5546\u5bb6\u4e2d\u5fc3\u57fa\u672c\u4fe1\u606f\u5931\u8d25:[{}]", (Object)merchantId);
            return Message.build((boolean)false, (String)"\u83b7\u53d6\u5546\u5bb6\u4e2d\u5fc3\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
        }
        MerchantBusinessInfo merchantBusinessInfo = new MerchantBusinessInfo();
        BeanUtils.copyProperties((Object)merchantInfo, (Object)merchantBusinessInfo);
        MerchantUserAccountVO merchantUserAccountVO = this.merchantUserProAccountService.getUserProAccount(merchantInfo.getId());
        if (merchantUserAccountVO != null) {
            merchantBusinessInfo.setAblePromotionCash(merchantUserAccountVO.getAbleProCash().setScale(2, 1));
        }
        if (StringUtils.isBlank((String)(string = this.redisStringAdapter.getString(RedisConfig.MERCHANT_ID_KEY.copy().appendKey((Object)merchantId))))) {
            merchantBusinessInfo.setIsInCenter(MerchantStatusEnum.INCENTER_NOT.getType());
        } else {
            merchantBusinessInfo.setIsInCenter(MerchantStatusEnum.INCENTER_YES.getType());
        }
        if (this.merchantPrerogativeInfoMapper.selectByMerchantId(merchantId, Integer.valueOf(0)) == null) {
            merchantBusinessInfo.setIsVip(MerchantStatusEnum.VIP_NO.getType());
        } else {
            merchantBusinessInfo.setIsVip(MerchantStatusEnum.VIP_YES.getType());
        }
        if (StringUtils.isBlank((String)this.redisStringAdapter.getString(RedisConfig.MERCHANT_MESSAGE_KEY.copy().appendKey((Object)merchantId)))) {
            merchantBusinessInfo.setBindType(Integer.valueOf(0));
        } else {
            merchantBusinessInfo.setBindType(Integer.valueOf(1));
        }
        return Message.build((boolean)true).addParam("merchantBusinessInfo", (Object)merchantBusinessInfo);
    }

    @Override
    public MerchantStatusDto getStatus(MerchantStatusParam param) {
        if (Boolean.FALSE.equals(this.merchantProperties.getPersonalEnterSwitch()) && this.merchantProperties.getOpenCityCodes().stream().noneMatch(p -> Objects.equals(p, param.getAreaCode()))) {
            return null;
        }
        String innerH5BaseUrl = this.domainIntegrationService.getInnerH5BaseUrl();
        Long userId = param.getUserId();
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByUserId(userId);
        MerchantStatusDto merchantStatusDto = new MerchantStatusDto();
        MerchantMemberVo merchantMemberVo = this.merchantUserService.getMemberInfo(userId);
        if (merchantMemberVo != null && Objects.equals(merchantMemberVo.getRole(), MerchantMemberEnum.MEMBER_ROLE_EMPLOYEE.getType())) {
            merchantStatusDto.setContent("\u6211\u7684\u8425\u9500");
            this.logger.debug("innerH5BaseUrl=" + innerH5BaseUrl);
            this.logger.debug("baseUrl=" + org.apache.commons.lang3.StringUtils.join((Object[])new String[]{innerH5BaseUrl, this.merchantProperties.getMarketUrlBase()}));
            String url = this.replaceUserIdAndMerchant(org.apache.commons.lang3.StringUtils.join((Object[])new String[]{innerH5BaseUrl, this.merchantProperties.getMarketUrlBase()}), merchantMemberVo.getUserId(), merchantMemberVo.getMerchantId());
            this.logger.debug("url=" + url);
            merchantStatusDto.setProtocolAddress(url);
            return merchantStatusDto;
        }
        if (merchantInfo == null) {
            merchantStatusDto.setContent("\u5546\u5bb6\u5408\u4f5c");
            UserInfoDTO user = this.userIntegrationService.getUserFromRedisDB(userId);
            merchantStatusDto.setProtocolAddress(org.apache.commons.lang3.StringUtils.join((Object[])new String[]{innerH5BaseUrl, this.merchantProperties.getMerchantApplyPath()}));
            if (Objects.nonNull(user) && StringUtils.isNotBlank((String)user.getPhone())) {
                String url = this.replacePhone(org.apache.commons.lang3.StringUtils.join((Object[])new String[]{innerH5BaseUrl, this.merchantProperties.getMerchantApplyPath()}), user.getPhone());
                merchantStatusDto.setProtocolAddress(this.fillLocationParam(url, param.getAreaCode()));
            }
            return merchantStatusDto;
        }
        if (merchantInfo.getQualificationStatus().equals(MerchantStatusEnum.QUALIFICATION_SUCCESS.getType())) {
            merchantStatusDto.setContent("\u5546\u5bb6\u4e2d\u5fc3");
        } else {
            merchantStatusDto.setContent("\u5546\u5bb6\u5408\u4f5c");
        }
        merchantStatusDto.setProtocolAddress(this.replaceMerchant(org.apache.commons.lang3.StringUtils.join((Object[])new String[]{innerH5BaseUrl, this.merchantProperties.getMerchantCenterPath()}), merchantInfo.getId()));
        return merchantStatusDto;
    }

    private String fillLocationParam(String url, String areaCode) {
        try {
            LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(areaCode);
            if (log.isDebugEnabled()) {
                log.debug("\u6839\u636ecode: {} \u83b7\u53d6\u5230\u7684\u57ce\u5e02\u4fe1\u606f: {}", (Object)areaCode, (Object)JSON.toJSONString((Object)locationByGeocode));
            }
            if (Objects.isNull(locationByGeocode) || StringUtils.isBlank((String)locationByGeocode.getCode()) && StringUtils.isBlank((String)locationByGeocode.getLastCode())) {
                log.warn("\u6839\u636ecode: {} \u65e0\u6cd5\u83b7\u53d6\u5230\u81ea\u52a8\u586b\u5145\u7684\u57ce\u5e02", (Object)areaCode);
                return url;
            }
            String fullCode = StringUtils.isNotBlank((String)locationByGeocode.getLastCode()) ? locationByGeocode.getLastCode() : locationByGeocode.getCode();
            String provinceCode = org.apache.commons.lang3.StringUtils.join((Object[])new String[]{fullCode.substring(0, 2), "0000"});
            String cityCode = org.apache.commons.lang3.StringUtils.join((Object[])new String[]{fullCode.substring(0, 4), "00"});
            String countyCode = fullCode.substring(0, 6);
            if (log.isDebugEnabled()) {
                log.debug("\u6839\u636ecode: {} \u83b7\u53d6\u5230\u7684\u7701: {} \u5e02: {} \u533a: {}", new Object[]{fullCode, provinceCode, cityCode, countyCode});
            }
            if (StringUtils.isBlank((String)provinceCode) || StringUtils.isBlank((String)cityCode) || StringUtils.isBlank((String)countyCode)) {
                return url;
            }
            return org.apache.commons.lang3.StringUtils.join((Object[])new String[]{url, "&provinceCode=", provinceCode, "&cityCode=", cityCode, "&countyCode=", countyCode});
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5546\u5bb6\u5165\u9a7b\u7684\u57ce\u5e02\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            return url;
        }
    }

    private String replaceUserIdAndMerchant(String url, Long userId, Long merchantId) {
        this.logger.debug(url);
        String replace = url.replace("{userId}", Objects.toString(userId));
        return replace.replace("{merchantId}", Objects.toString(merchantId));
    }

    private String replaceMerchant(String url, Long merchantId) {
        return url.contains("{merchantId}") ? url.replace("{merchantId}", Objects.toString(merchantId)) : url;
    }

    private String replacePhone(String url, String phone) {
        return url.contains("{phone}") ? url.replace("{phone}", phone) : url;
    }

    @Override
    public void clickCenter(Long merchantId) {
        String string = this.redisStringAdapter.getString(RedisConfig.MERCHANT_ID_KEY.copy().appendKey((Object)merchantId));
        if (StringUtils.isBlank((String)string)) {
            this.redisStringAdapter.set(RedisConfig.MERCHANT_ID_KEY.copy().appendKey((Object)merchantId), (Object)merchantId);
        }
    }

    @Override
    public int deleteMerchantInfoByUid(Long userId) {
        return this.merchantInfoMapper.deletePhoneByUserId(userId);
    }

    @Override
    public MerchantInfoSimpleVO getSimpleMerchantInfoByGoodsId(Long goodsId) {
        return this.merchantInfoMapper.getMerchantByGoodsId(goodsId);
    }

    public MerchantInfoServiceImpl(MerchantInfoMapper merchantInfoMapper, MerchantAuthInfoMapper merchantAuthInfoMapper, RedisStringAdapter redisStringAdapter, MerchantProperties merchantProperties, SequenceCreater sequenceCreater, MerchantCategoryMapper merchantCategoryMapper, MessageSender messageSender, MerchantUserProAccountService merchantUserProAccountService, MerchantPrerogativeInfoMapper merchantPrerogativeInfoMapper, UserIntegrationService userIntegrationService, MerchantUserService merchantUserService, DomainIntegrationService domainIntegrationService, MerchantRedisRefresh merchantRedisRefresh, LocationIntegrationService locationIntegrationService) {
        this.merchantInfoMapper = merchantInfoMapper;
        this.merchantAuthInfoMapper = merchantAuthInfoMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.merchantProperties = merchantProperties;
        this.sequenceCreater = sequenceCreater;
        this.merchantCategoryMapper = merchantCategoryMapper;
        this.messageSender = messageSender;
        this.merchantUserProAccountService = merchantUserProAccountService;
        this.merchantPrerogativeInfoMapper = merchantPrerogativeInfoMapper;
        this.userIntegrationService = userIntegrationService;
        this.merchantUserService = merchantUserService;
        this.domainIntegrationService = domainIntegrationService;
        this.merchantRedisRefresh = merchantRedisRefresh;
        this.locationIntegrationService = locationIntegrationService;
    }
}

