/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.enums.MerchantActionRecordTypeEnum;
import com.bxm.localnews.merchant.common.enums.RoleTypeEnum;
import com.bxm.localnews.merchant.domain.MerchantMemberCounterMapper;
import com.bxm.localnews.merchant.domain.MerchantMemberMapper;
import com.bxm.localnews.merchant.dto.MemberCounterDTO;
import com.bxm.localnews.merchant.dto.MerchantCounterRankDTO;
import com.bxm.localnews.merchant.dto.MerchantCounterTotalDTO;
import com.bxm.localnews.merchant.entity.MerchantMemberCounterEntity;
import com.bxm.localnews.merchant.param.MerchantCounterRankParam;
import com.bxm.localnews.merchant.service.MerchantMemberCounterService;
import com.bxm.localnews.merchant.service.MerchantUserService;
import com.bxm.localnews.merchant.utils.GenerateReidsFieldKey;
import com.bxm.localnews.merchant.vo.MerchantMemberVo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantMemberCounterServiceImpl
implements MerchantMemberCounterService {
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private MerchantMemberCounterMapper merchantMemberCounterMapper;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private MerchantMemberMapper merchantMemberMapper;
    @Autowired
    private MerchantUserService merchantUserService;

    @Override
    public int save(MerchantMemberCounterEntity counterEntity) {
        if (null == counterEntity.getId()) {
            counterEntity.setId(this.sequenceCreater.nextLongId());
        }
        return this.merchantMemberCounterMapper.insert(counterEntity);
    }

    @Override
    public int addAmountByType(Long merchantId, Long userId, Integer actionRecordType) {
        return this.merchantMemberCounterMapper.addAmountByType(merchantId, userId, actionRecordType);
    }

    @Override
    public int saveOrUpdate(MemberCounterDTO memberCounterDTO) {
        MerchantMemberCounterEntity counterEntity = this.merchantMemberCounterMapper.selectByMidUid(memberCounterDTO.getMerchantId(), memberCounterDTO.getUserId());
        if (null == counterEntity) {
            counterEntity = new MerchantMemberCounterEntity();
            counterEntity.setMerchantId(memberCounterDTO.getMerchantId());
            counterEntity.setUserId(memberCounterDTO.getUserId());
            counterEntity.setNickName(memberCounterDTO.getNickName());
            counterEntity.setHeadImg(memberCounterDTO.getHeadImg());
            counterEntity.setRelation(memberCounterDTO.getRelation());
            counterEntity.setCreateTime(new Date());
            counterEntity.setClickAmount(Long.valueOf(0L));
            counterEntity.setGuestAmount(Long.valueOf(0L));
            counterEntity.setShareAmount(Long.valueOf(0L));
            counterEntity.setViewAmount(Long.valueOf(0L));
            counterEntity.setOrderAmount(Long.valueOf(0L));
            if (Objects.equals(memberCounterDTO.getRecordTypeEnum(), MerchantActionRecordTypeEnum.SHARE)) {
                counterEntity.setShareAmount(Long.valueOf(1L));
            } else if (Objects.equals(memberCounterDTO.getRecordTypeEnum(), MerchantActionRecordTypeEnum.CLICK)) {
                counterEntity.setClickAmount(Long.valueOf(1L));
            } else if (Objects.equals(memberCounterDTO.getRecordTypeEnum(), MerchantActionRecordTypeEnum.ORDER)) {
                counterEntity.setOrderAmount(Long.valueOf(1L));
            }
            return this.save(counterEntity);
        }
        return this.addAmountByType(counterEntity.getMerchantId(), counterEntity.getUserId(), memberCounterDTO.getRecordTypeEnum().getType());
    }

    @Override
    public int updateRelation(Long merchantId, Long userId, Byte relation) {
        return this.merchantMemberCounterMapper.updateRelation(merchantId, userId, relation);
    }

    @Override
    public PageWarper<MerchantCounterRankDTO> getRankList(MerchantCounterRankParam merchantCounterRankParam) {
        PageWarper pageWarper = new PageWarper(this.merchantMemberCounterMapper.getRankList(merchantCounterRankParam));
        for (int i = 0; i < pageWarper.getList().size(); ++i) {
            ((MerchantCounterRankDTO)pageWarper.getList().get(i)).setSort(Integer.valueOf((merchantCounterRankParam.getPageNum() - 1) * merchantCounterRankParam.getPageSize() + i + 1));
        }
        return pageWarper;
    }

    @Override
    public MerchantCounterTotalDTO getUserContribution(Long userId, Integer type, Long merchantId) {
        MerchantCounterTotalDTO resultCounter = this.merchantMemberCounterMapper.getUserContribution(userId, type, merchantId);
        if (Objects.equals(type, 1)) {
            userId = merchantId;
        }
        if (null == resultCounter) {
            return this.initMerchantCounterTotalDTO();
        }
        resultCounter.setTodayClue(this.sizeClickCounter(userId, merchantId, type));
        resultCounter.setTodayOrder(this.sizeOrderCounter(userId, merchantId, type));
        resultCounter.setTodayShare(this.sizeShareCounter(userId, merchantId, type));
        resultCounter.setTodayView(this.sizeViewCounter(userId, merchantId, type));
        resultCounter.setTodayVisit(this.sizeGuestCounter(userId, merchantId, type));
        return resultCounter;
    }

    private MerchantCounterTotalDTO initMerchantCounterTotalDTO() {
        MerchantCounterTotalDTO entity = new MerchantCounterTotalDTO();
        entity.setTotalShare(Long.valueOf(0L));
        entity.setTotalVisit(Long.valueOf(0L));
        entity.setTotalClue(Long.valueOf(0L));
        entity.setTotalOrder(Long.valueOf(0L));
        entity.setTodayShare(Long.valueOf(0L));
        entity.setTodayVisit(Long.valueOf(0L));
        entity.setTodayClue(Long.valueOf(0L));
        entity.setTodayOrder(Long.valueOf(0L));
        entity.setTotalView(Long.valueOf(0L));
        entity.setTodayView(Long.valueOf(0L));
        return entity;
    }

    @Override
    public MerchantCounterRankDTO getBoosRank(MerchantCounterRankParam merchantCounterRankParam) {
        MerchantMemberVo merchantMemberVo = this.merchantMemberMapper.getBossByMerchantId(merchantCounterRankParam.getMerchantId());
        if (null != merchantMemberVo) {
            merchantCounterRankParam.setUserId(merchantMemberVo.getUserId());
        }
        return this.merchantMemberCounterMapper.getBoosRank(merchantCounterRankParam.getUserId(), merchantCounterRankParam.getType(), merchantCounterRankParam.getMerchantId());
    }

    @Override
    public List<MerchantCounterRankDTO> getRankTop(MerchantCounterRankParam merchantCounterRankParam) {
        return this.merchantMemberCounterMapper.getRankTop(merchantCounterRankParam.getMerchantId());
    }

    @Override
    public boolean addClickCounter(Long userId, Long merchantId, String value, Integer type) {
        boolean flag;
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            flag = this.redisSetAdapter.add(RedisConfig.MERCHANT_CLICK_COUNTER.copy().appendKey((Object)GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId)), new Object[]{value}) > 0L;
            this.redisHashMapAdapter.expire(RedisConfig.MERCHANT_CLICK_COUNTER.copy().appendKey((Object)GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId)), DateUtils.getTodayEndMillis() / 1000L);
        } else {
            KeyGenerator key = RedisConfig.MERCHANT_CLICK_COUNTER.copy().appendKey((Object)GenerateReidsFieldKey.generateMerchantFieldKey(merchantId));
            flag = this.redisSetAdapter.add(key, new Object[]{userId + value}) > 0L;
            this.redisHashMapAdapter.expire(key, DateUtils.getTodayEndMillis() / 1000L);
        }
        return flag;
    }

    @Override
    public void addOrderCounter(Long userId, Long merchantId, Integer type) {
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            this.redisHashMapAdapter.increment(RedisConfig.MERCHANT_ORDER_COUNTER, GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId), 1);
        } else {
            this.redisHashMapAdapter.increment(RedisConfig.MERCHANT_ORDER_COUNTER, GenerateReidsFieldKey.generateMerchantFieldKey(merchantId), 1);
        }
        this.redisHashMapAdapter.expire(RedisConfig.MERCHANT_ORDER_COUNTER, DateUtils.getTodayEndMillis() / 1000L);
    }

    @Override
    public void addViewCounter(Long userId, Long merchantId, Integer type) {
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            this.redisHashMapAdapter.increment(RedisConfig.MERCHANT_VIEW_COUNTER, GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId), 1);
        } else {
            this.redisHashMapAdapter.increment(RedisConfig.MERCHANT_VIEW_COUNTER, GenerateReidsFieldKey.generateMerchantFieldKey(merchantId), 1);
        }
        this.redisHashMapAdapter.expire(RedisConfig.MERCHANT_VIEW_COUNTER, DateUtils.getTodayEndMillis() / 1000L);
    }

    @Override
    public void addShareCounter(Long userId, Long merchantId, Integer type) {
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            this.redisHashMapAdapter.increment(RedisConfig.MERCHANT_SHARE_COUNTER, GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId), 1);
        } else {
            this.redisHashMapAdapter.increment(RedisConfig.MERCHANT_SHARE_COUNTER, GenerateReidsFieldKey.generateMerchantFieldKey(merchantId), 1);
        }
        this.redisHashMapAdapter.expire(RedisConfig.MERCHANT_SHARE_COUNTER, DateUtils.getTodayEndMillis() / 1000L);
    }

    @Override
    public boolean addGuestCounter(Long userId, Long merchantId, String value, Integer type) {
        boolean flag;
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            KeyGenerator generator = RedisConfig.MERCHANT_GUEST_COUNTER.copy().appendKey((Object)GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId));
            flag = this.redisSetAdapter.add(generator, new Object[]{value}) > 0L;
            this.redisSetAdapter.expire(generator, DateUtils.getTodayEndMillis() / 1000L);
        } else {
            KeyGenerator generator = RedisConfig.MERCHANT_GUEST_COUNTER.copy().appendKey((Object)GenerateReidsFieldKey.generateMerchantFieldKey(merchantId));
            flag = this.redisSetAdapter.add(generator, new Object[]{userId + value}) > 0L;
            this.redisSetAdapter.expire(generator, DateUtils.getTodayEndMillis() / 1000L);
        }
        return flag;
    }

    @Override
    public Long sizeGuestCounter(Long userId, Long merchantId, Integer type) {
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            return this.redisSetAdapter.size(RedisConfig.MERCHANT_GUEST_COUNTER.copy().appendKey((Object)GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId)));
        }
        return this.redisSetAdapter.size(RedisConfig.MERCHANT_GUEST_COUNTER.copy().appendKey((Object)GenerateReidsFieldKey.generateMerchantFieldKey(merchantId)));
    }

    @Override
    public Long sizeViewCounter(Long userId, Long merchantId, Integer type) {
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            Long count = (Long)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_VIEW_COUNTER, GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId), Long.class);
            return null == count ? 0L : count;
        }
        Long count = (Long)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_VIEW_COUNTER, GenerateReidsFieldKey.generateMerchantFieldKey(merchantId), Long.class);
        return null == count ? 0L : count;
    }

    @Override
    public Long sizeClickCounter(Long userId, Long merchantId, Integer type) {
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            return this.redisSetAdapter.size(RedisConfig.MERCHANT_CLICK_COUNTER.copy().appendKey((Object)GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId)));
        }
        return this.redisSetAdapter.size(RedisConfig.MERCHANT_CLICK_COUNTER.copy().appendKey((Object)GenerateReidsFieldKey.generateMerchantFieldKey(merchantId)));
    }

    @Override
    public Long sizeOrderCounter(Long userId, Long merchantId, Integer type) {
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            Long count = (Long)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_ORDER_COUNTER, GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId), Long.class);
            return null == count ? 0L : count;
        }
        Long count = (Long)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_ORDER_COUNTER, GenerateReidsFieldKey.generateMerchantFieldKey(merchantId), Long.class);
        return null == count ? 0L : count;
    }

    @Override
    public Long sizeShareCounter(Long userId, Long merchantId, Integer type) {
        if (Objects.equals(type, RoleTypeEnum.USER.getType())) {
            Long count = (Long)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_SHARE_COUNTER, GenerateReidsFieldKey.generateUserFieldKey(userId + merchantId), Long.class);
            return null == count ? 0L : count;
        }
        Long count = (Long)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_SHARE_COUNTER, GenerateReidsFieldKey.generateMerchantFieldKey(merchantId), Long.class);
        return null == count ? 0L : count;
    }

    @Override
    public void addSyncPushRedis(Long userId) {
        MerchantMemberVo memberVo = this.merchantUserService.getMemberInfo(userId);
        this.redisHashMapAdapter.put(RedisConfig.MERCHANT_CLICK_INFO_PUSH, userId.toString(), (Object)memberVo);
    }

    @Override
    public List<MerchantMemberVo> getAllSyncPushList() {
        ArrayList<MerchantMemberVo> listMember = new ArrayList<MerchantMemberVo>();
        Set keys = this.redisHashMapAdapter.keys(RedisConfig.MERCHANT_CLICK_INFO_PUSH);
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            MerchantMemberVo merchantMemberVo = (MerchantMemberVo)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_CLICK_INFO_PUSH, (String)iterator.next(), MerchantMemberVo.class);
            listMember.add(merchantMemberVo);
        }
        return listMember;
    }

    @Override
    public void removeAllSyncPushList() {
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_CLICK_INFO_PUSH);
    }

    private MerchantCounterRankDTO initMerchantCounterRankDTO(Long userId, String nickName, String headImg) {
        MerchantCounterRankDTO counterRankDTO = new MerchantCounterRankDTO();
        counterRankDTO.setName(nickName);
        counterRankDTO.setHeadImg(headImg);
        counterRankDTO.setVisitNum(Long.valueOf(0L));
        counterRankDTO.setClueNum(Long.valueOf(0L));
        counterRankDTO.setShareNum(Long.valueOf(0L));
        counterRankDTO.setOrderNum(Long.valueOf(0L));
        return counterRankDTO;
    }
}

