/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.merchant.common.constant.AppCommonStatus;
import com.bxm.localnews.merchant.common.enums.MerchantActionRecordTypeEnum;
import com.bxm.localnews.merchant.common.enums.RoleTypeEnum;
import com.bxm.localnews.merchant.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.merchant.dto.MemberCounterDTO;
import com.bxm.localnews.merchant.dto.NewsBriefInfoDto;
import com.bxm.localnews.merchant.dto.RelationImplDTO;
import com.bxm.localnews.merchant.dto.RelationshipDto;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.entity.MerchantActionRecordEntity;
import com.bxm.localnews.merchant.entity.MerchantContentRecordEntity;
import com.bxm.localnews.merchant.facade.ForumPostFacadeService;
import com.bxm.localnews.merchant.facade.NewsFacadeService;
import com.bxm.localnews.merchant.facade.UserFeignService;
import com.bxm.localnews.merchant.param.MerchantReportParam;
import com.bxm.localnews.merchant.service.MerchantActionRecordService;
import com.bxm.localnews.merchant.service.MerchantContentRecordService;
import com.bxm.localnews.merchant.service.MerchantMemberCounterService;
import com.bxm.localnews.merchant.service.MerchantPageCollectService;
import com.bxm.localnews.merchant.service.MerchantUserService;
import com.bxm.localnews.merchant.service.PushIntegrationService;
import com.bxm.localnews.merchant.utils.ValidatorlUtils;
import com.bxm.localnews.merchant.vo.MerchantMemberVo;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MerchantPageCollectServiceImpl
implements MerchantPageCollectService {
    private static final Logger log = LoggerFactory.getLogger(MerchantPageCollectServiceImpl.class);
    @Autowired
    private MerchantActionRecordService merchantActionRecordService;
    @Autowired
    private MerchantMemberCounterService merchantMemberCounterService;
    @Autowired
    private MerchantContentRecordService merchantContentRecordService;
    @Autowired
    private ForumPostFacadeService forumPostFacadeService;
    @Autowired
    private NewsFacadeService newsFacadeService;
    @Autowired
    private UserFeignService userFeignService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private PushIntegrationService pushIntegrationService;
    private MerchantUserService merchantUserService;

    private MerchantUserService getMerchantUserService() {
        if (null == this.merchantUserService) {
            this.merchantUserService = (MerchantUserService)SpringContextHolder.getBean(MerchantUserService.class);
        }
        return this.merchantUserService;
    }

    @Override
    public void toReport(MerchantReportParam merchantReportParam) {
        this.clickContent(merchantReportParam);
    }

    @Override
    public void shareContent(Long targetId, Long userId, InviteTypeEnum inviteTypeEnum) {
        String title = "";
        if (Objects.equals(inviteTypeEnum, InviteTypeEnum.NEWS)) {
            NewsBriefInfoDto newsBriefInfoDto = (NewsBriefInfoDto)this.newsFacadeService.getBriefInfo(targetId, null, null).getBody();
            if (null != newsBriefInfoDto) {
                title = newsBriefInfoDto.getTitle();
            }
        } else {
            ForumPostBriefInfoDto briefInfoDto = (ForumPostBriefInfoDto)this.forumPostFacadeService.getPostWithoutDetail(targetId).getBody();
            if (null != briefInfoDto) {
                title = briefInfoDto.getTitle();
            }
        }
        RelationshipDto relationshipDto = this.getMerchantUserService().getRelationship(userId);
        if (null != relationshipDto) {
            RelationImplDTO relationImplDTO = this.merchantActionRecordService.convertRelationShipDto(relationshipDto);
            MerchantActionRecordEntity actionRecordEntity = this.convertActionRecord(relationImplDTO, MerchantActionRecordTypeEnum.SHARE);
            MemberCounterDTO counterDTO = this.convertCounter(relationImplDTO, MerchantActionRecordTypeEnum.SHARE);
            MerchantContentRecordEntity contentRecordEntity = this.convertContentRecord(actionRecordEntity);
            actionRecordEntity.setBizId(targetId);
            actionRecordEntity.setBizType(inviteTypeEnum.getName());
            actionRecordEntity.setBizTitle(title);
            actionRecordEntity.setTraceId(this.sequenceCreater.nextStringId());
            contentRecordEntity.setRelationId(targetId);
            contentRecordEntity.setRelationType(inviteTypeEnum.getName());
            contentRecordEntity.setRelationTitle(title);
            contentRecordEntity.setRelationType(inviteTypeEnum.name());
            this.merchantActionRecordService.save(actionRecordEntity);
            this.merchantMemberCounterService.saveOrUpdate(counterDTO);
            this.merchantContentRecordService.saveOrUpdate(contentRecordEntity);
            this.addShare(actionRecordEntity, MerchantActionRecordTypeEnum.SHARE);
        }
    }

    @Override
    public void clickContent(MerchantReportParam merchantReportParam) {
        MerchantActionRecordEntity actionRecordEntity = this.merchantActionRecordService.getByTraceId(merchantReportParam.getTraceId());
        MerchantActionRecordEntity clickActionRecordEntity = null;
        if (null != actionRecordEntity) {
            clickActionRecordEntity = new MerchantActionRecordEntity();
            BeanUtils.copyProperties((Object)actionRecordEntity, (Object)clickActionRecordEntity);
            this.setActorInfo(merchantReportParam.getToken(), clickActionRecordEntity);
            clickActionRecordEntity.setTraceId(merchantReportParam.getTraceId());
            clickActionRecordEntity.setActor(merchantReportParam.getToken());
            clickActionRecordEntity.setActionType(Byte.valueOf(MerchantActionRecordTypeEnum.CLICK.getType().byteValue()));
        } else if (!Objects.isNull(merchantReportParam.getShareUserId())) {
            clickActionRecordEntity = this.initActionRecordEntity(merchantReportParam.getShareUserId(), MerchantActionRecordTypeEnum.CLICK);
            this.setActorInfo(merchantReportParam.getToken(), clickActionRecordEntity);
        }
        if (null == clickActionRecordEntity) {
            return;
        }
        if (this.addShare(clickActionRecordEntity, MerchantActionRecordTypeEnum.CLICK)) {
            this.merchantActionRecordService.save(clickActionRecordEntity);
            this.merchantMemberCounterService.addAmountByType(clickActionRecordEntity.getMerchantId(), clickActionRecordEntity.getBelonger(), MerchantActionRecordTypeEnum.CLICK.getType());
            this.merchantContentRecordService.addCounterByType(clickActionRecordEntity.getBizId(), clickActionRecordEntity.getBelonger(), clickActionRecordEntity.getMerchantId(), MerchantActionRecordTypeEnum.CLICK);
            this.merchantMemberCounterService.addSyncPushRedis(clickActionRecordEntity.getBelonger());
        }
    }

    @Override
    public void viewContent(MerchantReportParam merchantReportParam) {
        MerchantActionRecordEntity actionRecordEntity = this.merchantActionRecordService.getByTraceId(merchantReportParam.getTraceId());
        if (null != actionRecordEntity) {
            MerchantActionRecordEntity clickActionRecordEntity = new MerchantActionRecordEntity();
            BeanUtils.copyProperties((Object)actionRecordEntity, (Object)clickActionRecordEntity);
            clickActionRecordEntity.setTraceId(merchantReportParam.getTraceId());
            clickActionRecordEntity.setActor(merchantReportParam.getToken());
            this.setActorInfo(merchantReportParam.getToken(), clickActionRecordEntity);
            clickActionRecordEntity.setActionType(Byte.valueOf(MerchantActionRecordTypeEnum.VIEW.getType().byteValue()));
            this.merchantActionRecordService.save(clickActionRecordEntity);
            this.merchantMemberCounterService.addAmountByType(actionRecordEntity.getMerchantId(), actionRecordEntity.getBelonger(), MerchantActionRecordTypeEnum.VIEW.getType());
            this.merchantContentRecordService.addCounterByType(actionRecordEntity.getBizId(), actionRecordEntity.getBelonger(), actionRecordEntity.getMerchantId(), MerchantActionRecordTypeEnum.VIEW);
            this.addShare(actionRecordEntity, MerchantActionRecordTypeEnum.VIEW);
            if (this.addShare(actionRecordEntity, MerchantActionRecordTypeEnum.USER_VIEW)) {
                this.merchantMemberCounterService.addAmountByType(actionRecordEntity.getMerchantId(), actionRecordEntity.getBelonger(), MerchantActionRecordTypeEnum.USER_VIEW.getType());
            }
        }
    }

    @Override
    @Async
    public void orderContent(MerchantReportParam merchantReportParam) {
        MerchantActionRecordEntity actionRecordEntity = this.merchantActionRecordService.getByTraceId(merchantReportParam.getTraceId());
        MerchantActionRecordEntity clickActionRecordEntity = new MerchantActionRecordEntity();
        if (null != actionRecordEntity) {
            BeanUtils.copyProperties((Object)actionRecordEntity, (Object)clickActionRecordEntity);
            clickActionRecordEntity.setTraceId(merchantReportParam.getTraceId());
            clickActionRecordEntity.setActor(merchantReportParam.getToken());
            this.setActorInfo(merchantReportParam.getToken(), clickActionRecordEntity);
            clickActionRecordEntity.setActionType(Byte.valueOf(MerchantActionRecordTypeEnum.ORDER.getType().byteValue()));
        } else if (!Objects.isNull(merchantReportParam.getShareUserId())) {
            clickActionRecordEntity = this.initActionRecordEntity(merchantReportParam.getShareUserId(), MerchantActionRecordTypeEnum.ORDER);
            this.setActorInfo(merchantReportParam.getToken(), clickActionRecordEntity);
        }
        if (null == actionRecordEntity) {
            return;
        }
        this.merchantActionRecordService.save(clickActionRecordEntity);
        this.merchantMemberCounterService.addAmountByType(clickActionRecordEntity.getMerchantId(), clickActionRecordEntity.getBelonger(), MerchantActionRecordTypeEnum.ORDER.getType());
        this.merchantContentRecordService.addCounterByType(clickActionRecordEntity.getBizId(), clickActionRecordEntity.getBelonger(), clickActionRecordEntity.getMerchantId(), MerchantActionRecordTypeEnum.ORDER);
        this.addShare(clickActionRecordEntity, MerchantActionRecordTypeEnum.ORDER);
        MerchantMemberVo merchantMemberVo = this.getMerchantUserService().getMemberInfo(clickActionRecordEntity.getBelonger());
        if (null != merchantMemberVo) {
            this.pushIntegrationService.pushShareByOrderReport(clickActionRecordEntity.getMerchantId(), clickActionRecordEntity.getBelonger(), merchantMemberVo.getRole());
        }
    }

    private MerchantActionRecordEntity initActionRecordEntity(Long shareUserId, MerchantActionRecordTypeEnum actionRecordTypeEnum) {
        RelationshipDto relationshipDto = this.getMerchantUserService().getRelationship(shareUserId);
        if (null != relationshipDto) {
            RelationImplDTO relationImplDTO = this.merchantActionRecordService.convertRelationShipDto(relationshipDto);
            MerchantActionRecordEntity actionRecordEntity = this.convertActionRecord(relationImplDTO, actionRecordTypeEnum);
            actionRecordEntity.setTraceId(this.sequenceCreater.nextStringId());
            return actionRecordEntity;
        }
        return null;
    }

    private void setActorInfo(String token, MerchantActionRecordEntity clickActionRecordEntity) {
        try {
            if (ValidatorlUtils.checkNum(token)) {
                UserInfoDTO actorUser = (UserInfoDTO)this.userFeignService.getUserFromCache(Long.valueOf(Long.parseLong(token))).getBody();
                if (null != actorUser) {
                    clickActionRecordEntity.setActorHeadImg(actorUser.getHeadImg());
                    clickActionRecordEntity.setActorNickName(actorUser.getNickname());
                    clickActionRecordEntity.setActor(token);
                }
            } else {
                clickActionRecordEntity.setActor(token);
                clickActionRecordEntity.setActorHeadImg("");
                clickActionRecordEntity.setActorNickName("\u672a\u6388\u6743\u7528\u6237");
            }
        }
        catch (NumberFormatException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
    }

    private boolean addShare(MerchantActionRecordEntity actionRecordEntity, MerchantActionRecordTypeEnum recordTypeEnum) {
        switch (recordTypeEnum) {
            case SHARE: {
                this.merchantMemberCounterService.addShareCounter(actionRecordEntity.getBelonger(), actionRecordEntity.getMerchantId(), RoleTypeEnum.USER.getType());
                this.merchantMemberCounterService.addShareCounter(actionRecordEntity.getMerchantId(), actionRecordEntity.getMerchantId(), RoleTypeEnum.MERCHANT.getType());
                break;
            }
            case VIEW: {
                this.merchantMemberCounterService.addViewCounter(actionRecordEntity.getBelonger(), actionRecordEntity.getMerchantId(), RoleTypeEnum.USER.getType());
                this.merchantMemberCounterService.addViewCounter(actionRecordEntity.getMerchantId(), actionRecordEntity.getMerchantId(), RoleTypeEnum.MERCHANT.getType());
                break;
            }
            case CLICK: {
                this.merchantMemberCounterService.addClickCounter(actionRecordEntity.getBelonger(), actionRecordEntity.getMerchantId(), actionRecordEntity.getActor(), RoleTypeEnum.USER.getType());
                return this.merchantMemberCounterService.addClickCounter(actionRecordEntity.getBelonger(), actionRecordEntity.getMerchantId(), actionRecordEntity.getActor(), RoleTypeEnum.MERCHANT.getType());
            }
            case ORDER: {
                this.merchantMemberCounterService.addOrderCounter(actionRecordEntity.getBelonger(), actionRecordEntity.getMerchantId(), RoleTypeEnum.USER.getType());
                this.merchantMemberCounterService.addOrderCounter(actionRecordEntity.getMerchantId(), actionRecordEntity.getMerchantId(), RoleTypeEnum.MERCHANT.getType());
                break;
            }
            case USER_VIEW: {
                this.merchantMemberCounterService.addGuestCounter(actionRecordEntity.getBelonger(), actionRecordEntity.getMerchantId(), actionRecordEntity.getActor(), RoleTypeEnum.MERCHANT.getType());
                return this.merchantMemberCounterService.addGuestCounter(actionRecordEntity.getBelonger(), actionRecordEntity.getMerchantId(), actionRecordEntity.getActor(), RoleTypeEnum.USER.getType());
            }
        }
        return true;
    }

    @Override
    public Boolean updateRelationStatus(Long userId, Long merchantId, Byte status) {
        return true;
    }

    private MerchantActionRecordEntity convertActionRecord(RelationImplDTO relationImplDTO, MerchantActionRecordTypeEnum recordTypeEnum) {
        MerchantActionRecordEntity recordEntity = new MerchantActionRecordEntity();
        recordEntity.setOperator(relationImplDTO.getOperator());
        recordEntity.setBelonger(relationImplDTO.getBelonger());
        recordEntity.setActor(relationImplDTO.getActor());
        UserInfoDTO belongUser = (UserInfoDTO)this.userFeignService.getUserFromCache(recordEntity.getBelonger()).getBody();
        if (null != belongUser) {
            recordEntity.setBelongerHeadImg(belongUser.getHeadImg());
            recordEntity.setBelongerNickName(belongUser.getNickname());
        }
        recordEntity.setActionType(Byte.valueOf(recordTypeEnum.getType().byteValue()));
        recordEntity.setId(this.sequenceCreater.nextLongId());
        recordEntity.setMerchantId(relationImplDTO.getMerchantId());
        return recordEntity;
    }

    private MemberCounterDTO convertCounter(RelationImplDTO relationImplDTO, MerchantActionRecordTypeEnum recordTypeEnum) {
        UserInfoDTO userInfoDTO = (UserInfoDTO)this.userFeignService.getUserFromCache(relationImplDTO.getBelonger()).getBody();
        MemberCounterDTO counterDTO = MemberCounterDTO.builder().merchantId(relationImplDTO.getMerchantId()).userId(relationImplDTO.getBelonger()).headImg(userInfoDTO.getHeadImg()).nickName(userInfoDTO.getNickname()).relation(AppCommonStatus.ENABLE).recordTypeEnum(recordTypeEnum).build();
        return counterDTO;
    }

    private MerchantContentRecordEntity convertContentRecord(MerchantActionRecordEntity actionRecordEntity) {
        MerchantContentRecordEntity contentRecordEntity = new MerchantContentRecordEntity();
        contentRecordEntity.setMerchantId(actionRecordEntity.getMerchantId());
        contentRecordEntity.setBelonger(actionRecordEntity.getBelonger());
        contentRecordEntity.setBelongerHeadImg(actionRecordEntity.getBelongerHeadImg());
        contentRecordEntity.setBelongerName(actionRecordEntity.getBelongerNickName());
        contentRecordEntity.setOperator(actionRecordEntity.getOperator());
        return contentRecordEntity;
    }
}

