/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.constant.MerchantStatusEnum;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.dto.MerchantUserDTO;
import com.bxm.localnews.merchant.param.MerChantListParam;
import com.bxm.localnews.merchant.service.MerchantRedisRefresh;
import com.bxm.localnews.merchant.service.work.MerchantCollectService;
import com.bxm.localnews.merchant.service.work.MerchantListService;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MerchantRedisRefreshImpl
implements MerchantRedisRefresh {
    @Resource
    private MerchantCollectService merchantCollectService;
    @Resource
    private MerchantListService merchantListService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private MerchantInfoMapper merchantInfoMapper;

    @Override
    @Async
    public void refreshMerchantCollect(Long userId) {
        this.merchantCollectService.loadInfoFromDb(userId);
    }

    @Override
    @Async
    public void refreshMerchantList(Long merchantId) {
        MerchantInfo info = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
        if (Objects.isNull(info)) {
            return;
        }
        MerChantListParam param = new MerChantListParam();
        param.setCategoryId(info.getCategoryId());
        param.setAreaCode(info.getAreaCode());
        this.merchantListService.getFromDb(param);
        MerChantListParam paramTotal = new MerChantListParam();
        paramTotal.setCategoryId(Long.valueOf(0L));
        paramTotal.setAreaCode(info.getAreaCode());
        this.merchantListService.getFromDb(paramTotal);
    }

    @Override
    public void removeMerchantList(String areaCode, Long categoryId) {
        this.merchantListService.removeCache(areaCode, categoryId);
    }

    @Override
    public void removeMerchantUserCache(Long userId) {
        if (null == userId) {
            return;
        }
        this.reloadCache(userId);
    }

    @Override
    public void initCache() {
        List merchantInfos = this.merchantInfoMapper.queryPassQualificationList();
        ((Stream)merchantInfos.stream().parallel()).forEach(merchantInfo -> this.reloadCache(merchantInfo.getUserId()));
    }

    private MerchantUserDTO reloadCache(Long userId) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByUserId(userId);
        if (Objects.isNull(merchantInfo)) {
            return null;
        }
        int merchantStatus = Objects.equals(merchantInfo.getQualificationStatus(), MerchantStatusEnum.QUALIFICATION_SUCCESS.getType()) ? 1 : 0;
        String merchantName = merchantInfo.getShortName();
        if (StringUtils.isBlank((CharSequence)merchantName)) {
            merchantName = merchantInfo.getMerchantName();
        }
        MerchantUserDTO merchantUserDTO = MerchantUserDTO.builder().v(2).userId(userId).merchantId(merchantInfo.getId()).isShelf(merchantInfo.getIsShelf()).merchantName(merchantName).merchantStatus(Integer.valueOf(merchantStatus)).build();
        this.redisHashMapAdapter.put(RedisConfig.MERCHANT_USER_CACHE_KEY, userId.toString(), (Object)merchantUserDTO);
        return merchantUserDTO;
    }

    @Override
    public MerchantUserDTO getMerchantUserCache(Long userId) {
        MerchantUserDTO merchantUser = (MerchantUserDTO)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_USER_CACHE_KEY, userId.toString(), MerchantUserDTO.class);
        if (merchantUser == null) {
            merchantUser = new MerchantUserDTO();
            merchantUser.setUserId(userId);
            merchantUser.setMerchantStatus(Integer.valueOf(0));
        }
        if (!Objects.equals(2, merchantUser.getV())) {
            merchantUser = this.reloadCache(userId);
        }
        return merchantUser;
    }
}

