/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.constant.MerchantMemberEnum;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantMemberMapper;
import com.bxm.localnews.merchant.domain.MerchantNotifactionMapper;
import com.bxm.localnews.merchant.dto.CreateStatusDto;
import com.bxm.localnews.merchant.dto.MerchantUserInfoDto;
import com.bxm.localnews.merchant.dto.RelationshipDto;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.UserInviteHistoryBean;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.integration.UserInviteIntegrationService;
import com.bxm.localnews.merchant.param.CreateParam;
import com.bxm.localnews.merchant.param.EmployeeRemoveParam;
import com.bxm.localnews.merchant.param.MerchantMemberPageParam;
import com.bxm.localnews.merchant.param.RemoveRecordParam;
import com.bxm.localnews.merchant.service.MerchantUserService;
import com.bxm.localnews.merchant.service.PushIntegrationService;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.localnews.merchant.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.vo.MerchantNotifactionVo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MerchantUserImpl
extends BaseService
implements MerchantUserService {
    private MerchantMemberMapper merchantMemberMapper;
    private MerchantNotifactionMapper merchantNotifactionMapper;
    private MerchantInfoMapper merchantInfoMapper;
    private UserIntegrationService userIntegrationService;
    private RedisHashMapAdapter redisHashMapAdapter;
    private UserInviteIntegrationService userInviteIntegrationService;
    private PushIntegrationService pushIntegrationService;
    private RedisStringAdapter redisStringAdapter;

    @Override
    public Message create(CreateParam createParam) {
        CreateStatusDto createStatusDto = new CreateStatusDto();
        MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
        BeanUtils.copyProperties((Object)createParam, (Object)merchantMemberVo);
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(createParam.getMerchantId());
        if (merchantInfo == null) {
            this.logger.debug("\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4fe1\u606f" + createParam.getMerchantId());
            return Message.build((boolean)false, (String)"\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4fe1\u606f");
        }
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(createParam.getUserId());
        String nickname = "";
        String headImg = "";
        Integer register = 0;
        if (userInfoDTO != null && userInfoDTO.getState() != null) {
            nickname = userInfoDTO.getNickname();
            headImg = userInfoDTO.getHeadImg();
            createStatusDto.setRegister(Integer.valueOf(0));
            register = 0;
        } else {
            nickname = createParam.getNickName();
            headImg = createParam.getHeadImg();
            createStatusDto.setRegister(Integer.valueOf(1));
            register = 1;
        }
        MerchantMemberVo memberInfo = this.getMemberInfo(createParam.getUserId());
        if (memberInfo != null) {
            MerchantInfo vo = this.merchantInfoMapper.selectByPrimaryKey(memberInfo.getMerchantId());
            if (vo != null) {
                createStatusDto.setContent("\u60a8\u5df2\u7ecf\u662f\u201c" + vo.getShortName() + "\u201d\u7684\u5458\u5de5\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u5176\u4ed6\u5e97\u94fa");
                this.logger.debug("\u60a8\u5df2\u7ecf\u662f\u201c" + vo.getShortName() + "\u201d\u7684\u5458\u5de5\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u5176\u4ed6\u5e97\u94fa");
            }
            createStatusDto.setType(Integer.valueOf(1));
            createStatusDto.setRegister(register);
            return Message.build((boolean)true).addParam("createStatusDto", (Object)createStatusDto);
        }
        merchantMemberVo.setNickName(nickname);
        merchantMemberVo.setHeadImg(headImg);
        merchantMemberVo.setRelation(MerchantMemberEnum.RELATION_TYPE_YES.getType());
        merchantMemberVo.setRole(MerchantMemberEnum.MEMBER_ROLE_EMPLOYEE.getType());
        merchantMemberVo.setCreateTime(new Date());
        merchantMemberVo.setBindTime(new Date());
        merchantMemberVo.setBindPopType(Integer.valueOf(0));
        if (this.merchantMemberMapper.selectByMerchantAndUserId(createParam.getMerchantId(), createParam.getUserId()) != null) {
            merchantMemberVo.setCreateTime(null);
            merchantMemberVo.setModifyTime(new Date());
            merchantMemberVo.setDeleteFlag(Integer.valueOf(0));
            this.merchantMemberMapper.updateByUserIdAndMerchantId(merchantMemberVo);
        } else {
            this.merchantMemberMapper.insertSelective(merchantMemberVo);
        }
        if (!Objects.equals(createParam.getPush(), 0)) {
            this.pushIntegrationService.pushMerchantMemberMsg(merchantMemberVo, merchantInfo, MerchantMemberEnum.PUSH_TOBOSS_SUCESSS);
        }
        this.pushIntegrationService.pushMerchantMemberMsg(merchantMemberVo, merchantInfo, MerchantMemberEnum.PUSH_TOEMPLOYEE_SUCESSS);
        this.redisHashMapAdapter.put(RedisConfig.MEMBER_INFO_KEY, merchantMemberVo.getUserId() + "", (Object)merchantMemberVo);
        this.redisStringAdapter.set(RedisConfig.MERCHANT_MESSAGE_KEY.copy().appendKey((Object)merchantInfo.getId()), (Object)(nickname + "\u548c\u60a8\u7ed1\u5b9a\u4e86\u4e86\u5458\u5de5\u5173\u7cfb"));
        this.addLog(createParam.getMerchantId(), nickname + "\u548c\u60a8\u7ed1\u5b9a\u4e86\u4e86\u5458\u5de5\u5173\u7cfb", "\u9080\u8bf7\u6210\u529f");
        createStatusDto.setType(Integer.valueOf(0));
        createStatusDto.setContent("\u606d\u559c\u4f60\u6210\u4e3a" + merchantInfo.getShortName() + "\u7684\u5458\u5de5");
        return Message.build((boolean)true).addParam("createStatusDto", (Object)createStatusDto);
    }

    @Override
    public Message remove(EmployeeRemoveParam employeeRemoveParam) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(employeeRemoveParam.getMerchantId());
        if (merchantInfo == null) {
            return Message.build((boolean)false, (String)"\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4fe1\u606f");
        }
        MerchantMemberVo merchantMemberVo = this.getMemberInfo(employeeRemoveParam.getUserId());
        if (merchantMemberVo == null) {
            return Message.build((boolean)false, (String)"\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u7684\u7ed1\u5b9a\u5e97\u94fa");
        }
        merchantMemberVo.setRelation(MerchantMemberEnum.RELATION_TYPE_NO.getType());
        merchantMemberVo.setModifyTime(new Date());
        this.merchantMemberMapper.updateByUserId(merchantMemberVo);
        this.pushIntegrationService.pushMerchantMemberMsg(merchantMemberVo, merchantInfo, MerchantMemberEnum.PUSH_TOBOSS_FAIL);
        this.pushIntegrationService.pushMerchantMemberMsg(merchantMemberVo, merchantInfo, MerchantMemberEnum.PUSH_TOEMPLOYEE_FAIL);
        this.addLog(merchantMemberVo.getMerchantId(), merchantMemberVo.getNickName() + "\u548c\u60a8\u89e3\u9664\u4e86\u5458\u5de5\u5173\u7cfb", "\u89e3\u9664\u7ed1\u5b9a");
        this.redisHashMapAdapter.remove(RedisConfig.MEMBER_INFO_KEY, new String[]{merchantMemberVo.getUserId() + ""});
        this.redisStringAdapter.set(RedisConfig.MERCHANT_MESSAGE_KEY.copy().appendKey((Object)merchantMemberVo.getMerchantId()), (Object)(merchantMemberVo.getNickName() + "\u548c\u60a8\u89e3\u9664\u4e86\u5458\u5de5\u5173\u7cfb"));
        return Message.build((boolean)true);
    }

    @Override
    public Message removeRecord(RemoveRecordParam removeRecordParam) {
        if (this.merchantMemberMapper.selectByPrimaryKey(removeRecordParam.getId()) == null) {
            return Message.build((boolean)false, (String)"\u6ca1\u6709\u627e\u5230\u8be5\u6761\u7ed1\u5b9a\u8bb0\u5f55");
        }
        MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
        merchantMemberVo.setId(removeRecordParam.getId());
        merchantMemberVo.setDeleteFlag(Integer.valueOf(1));
        merchantMemberVo.setDeleteTime(new Date());
        merchantMemberVo.setModifyTime(new Date());
        this.merchantMemberMapper.updateByPrimaryKeySelective(merchantMemberVo);
        return Message.build((boolean)true);
    }

    @Override
    public PageWarper<MerchantMemberVo> getEmployeeList(MerchantMemberPageParam merchantMemberPageParam) {
        List list = this.merchantMemberMapper.queryListByPage(merchantMemberPageParam);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return new PageWarper(list);
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    @Override
    public Message getMerchantUserInfo(Long userId) {
        MerchantMemberVo merchantMemberVo = this.getMemberInfo(userId);
        if (merchantMemberVo == null) {
            return Message.build((boolean)false, (String)"\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u56e2\u961f\u7684\u76f8\u5173\u4fe1\u606f");
        }
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantMemberVo.getMerchantId());
        if (merchantInfo == null) {
            return Message.build((boolean)false, (String)"\u6ca1\u6709\u627e\u5230\u8be5\u7528\u6237\u7ed1\u5b9a\u5e97\u94fa\u7684\u76f8\u5173\u4fe1\u606f");
        }
        MerchantUserInfoDto merchantUserInfoDto = new MerchantUserInfoDto();
        merchantUserInfoDto.setShortName(merchantInfo.getShortName());
        merchantUserInfoDto.setHeadImg(merchantMemberVo.getHeadImg());
        merchantUserInfoDto.setNickname(merchantMemberVo.getNickName());
        merchantUserInfoDto.setCreateTime(merchantMemberVo.getBindTime());
        return Message.build((boolean)true).addParam("merchantUserInfoDto", (Object)merchantUserInfoDto);
    }

    public void addLog(Long merchantId, String message, String type) {
        MerchantNotifactionVo merchantNotifactionVo = new MerchantNotifactionVo();
        merchantNotifactionVo.setMerchant(merchantId);
        merchantNotifactionVo.setMessage(message);
        merchantNotifactionVo.setType(type);
        merchantNotifactionVo.setCreateTime(new Date());
        this.merchantNotifactionMapper.insertSelective(merchantNotifactionVo);
    }

    @Override
    public RelationshipDto getRelationship(Long userId) {
        RelationshipDto relationshipDto;
        UserInviteHistoryBean userInviteHistoryBean;
        MerchantMemberVo merchantMemberVo = this.getMemberInfo(userId);
        if (merchantMemberVo != null) {
            if (Objects.equals(merchantMemberVo.getRole(), MerchantMemberEnum.MEMBER_ROLE_BOSS.getType())) {
                return this.getRelationshipDto(0, merchantMemberVo.getMerchantId(), merchantMemberVo.getUserId(), null, null);
            }
            if (Objects.equals(merchantMemberVo.getRole(), MerchantMemberEnum.MEMBER_ROLE_EMPLOYEE.getType())) {
                return this.getRelationshipDto(1, merchantMemberVo.getMerchantId(), null, merchantMemberVo.getUserId(), null);
            }
        }
        if ((userInviteHistoryBean = this.userInviteIntegrationService.selectByUserId(userId)) != null && userInviteHistoryBean.getInviteUserId() != null && Objects.nonNull(relationshipDto = this.getbindInfo(userInviteHistoryBean.getInviteUserId()))) {
            return relationshipDto;
        }
        if (userInviteHistoryBean != null && userInviteHistoryBean.getInviteSuperUserId() != null && Objects.nonNull(relationshipDto = this.getbindInfo(userInviteHistoryBean.getInviteSuperUserId()))) {
            return relationshipDto;
        }
        return null;
    }

    public RelationshipDto getbindInfo(Long userId) {
        MerchantMemberVo vo = this.getMemberInfo(userId);
        if (vo != null) {
            if (Objects.equals(vo.getRole(), MerchantMemberEnum.MEMBER_ROLE_BOSS.getType())) {
                return this.getRelationshipDto(2, vo.getMerchantId(), vo.getUserId(), null, vo.getUserId());
            }
            if (Objects.equals(vo.getRole(), MerchantMemberEnum.MEMBER_ROLE_EMPLOYEE.getType())) {
                return this.getRelationshipDto(3, vo.getMerchantId(), null, vo.getUserId(), vo.getUserId());
            }
        }
        return null;
    }

    RelationshipDto getRelationshipDto(Integer type, Long merchantId, Long bossUserId, Long employeeUserId, Long inviteSuperUserId) {
        RelationshipDto relationshipDto = new RelationshipDto();
        relationshipDto.setType(type);
        relationshipDto.setMerchantId(merchantId);
        relationshipDto.setBossUserId(bossUserId);
        relationshipDto.setEmployeeUserId(employeeUserId);
        relationshipDto.setInviteSuperUserId(inviteSuperUserId);
        return relationshipDto;
    }

    @Override
    @Async
    public void bossCreate(Long merchantId, Long userId) {
        try {
            UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
            MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
            merchantMemberVo.setMerchantId(merchantId);
            merchantMemberVo.setUserId(userId);
            if (userInfoDTO != null && userInfoDTO.getState() != null) {
                merchantMemberVo.setNickName(userInfoDTO.getNickname());
                merchantMemberVo.setHeadImg(userInfoDTO.getHeadImg());
            }
            merchantMemberVo.setRelation(MerchantMemberEnum.RELATION_TYPE_YES.getType());
            merchantMemberVo.setRole(MerchantMemberEnum.MEMBER_ROLE_BOSS.getType());
            merchantMemberVo.setCreateTime(new Date());
            merchantMemberVo.setBindTime(new Date());
            this.merchantMemberMapper.insertSelective(merchantMemberVo);
            this.redisHashMapAdapter.put(RedisConfig.MEMBER_INFO_KEY, merchantMemberVo.getUserId() + "", (Object)merchantMemberVo);
            this.addLog(merchantId, "\u8001\u677f\u52a0\u5165\u56e2\u961f\u6210\u529f", "\u9080\u8bf7\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u8001\u677f" + userId + "\u52a0\u5165\u56e2\u961f\u5931\u8d25");
        }
    }

    @Override
    public MerchantMemberVo getMemberInfo(Long userId) {
        MerchantMemberVo merchantMemberVo = (MerchantMemberVo)this.redisHashMapAdapter.get(RedisConfig.MEMBER_INFO_KEY, userId + "", MerchantMemberVo.class);
        if (merchantMemberVo == null) {
            MerchantMemberVo vo = this.merchantMemberMapper.selectByUserId(userId);
            if (vo != null) {
                this.redisHashMapAdapter.put(RedisConfig.MEMBER_INFO_KEY, vo.getUserId() + "", (Object)vo);
                return vo;
            }
            return null;
        }
        return merchantMemberVo;
    }

    public void bossCreateOne(Long merchantId, Long userId) {
        try {
            UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
            MerchantMemberVo merchantMemberVo = new MerchantMemberVo();
            merchantMemberVo.setMerchantId(merchantId);
            merchantMemberVo.setUserId(userId);
            if (userInfoDTO != null && userInfoDTO.getState() != null) {
                merchantMemberVo.setNickName(userInfoDTO.getNickname());
                merchantMemberVo.setHeadImg(userInfoDTO.getHeadImg());
            }
            merchantMemberVo.setRelation(MerchantMemberEnum.RELATION_TYPE_YES.getType());
            merchantMemberVo.setRole(MerchantMemberEnum.MEMBER_ROLE_BOSS.getType());
            merchantMemberVo.setCreateTime(new Date());
            merchantMemberVo.setBindTime(new Date());
            this.merchantMemberMapper.insertSelective(merchantMemberVo);
            this.redisHashMapAdapter.put(RedisConfig.MEMBER_INFO_KEY, merchantMemberVo.getUserId() + "", (Object)merchantMemberVo);
            this.addLog(merchantId, "\u8001\u677f\u52a0\u5165\u56e2\u961f\u6210\u529f", "\u9080\u8bf7\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u8001\u677f" + userId + "\u52a0\u5165\u56e2\u961f\u5931\u8d25");
        }
    }

    public MerchantUserImpl(MerchantMemberMapper merchantMemberMapper, MerchantNotifactionMapper merchantNotifactionMapper, MerchantInfoMapper merchantInfoMapper, UserIntegrationService userIntegrationService, RedisHashMapAdapter redisHashMapAdapter, UserInviteIntegrationService userInviteIntegrationService, PushIntegrationService pushIntegrationService, RedisStringAdapter redisStringAdapter) {
        this.merchantMemberMapper = merchantMemberMapper;
        this.merchantNotifactionMapper = merchantNotifactionMapper;
        this.merchantInfoMapper = merchantInfoMapper;
        this.userIntegrationService = userIntegrationService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userInviteIntegrationService = userInviteIntegrationService;
        this.pushIntegrationService = pushIntegrationService;
        this.redisStringAdapter = redisStringAdapter;
    }
}

