/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.merchant.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.service.NewsIntegrationService;
import com.bxm.localnews.merchant.service.invite.InviteProcessorContext;
import com.bxm.localnews.merchant.service.invite.InviteTypeProcessor;
import com.bxm.newidea.component.tools.StringUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ForumInviteTypeProcessor
implements InviteTypeProcessor {
    @Resource
    private NewsIntegrationService newsIntegrationService;

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.FORUM;
    }

    @Override
    public String decorateTitle(UserInviteHistoryEntity inviteHistory) {
        if (StringUtils.isBlank((CharSequence)inviteHistory.getRelationTitle())) {
            return "\u5176\u4ed6\u5206\u4eab";
        }
        return "\u5206\u4eab\u7684\u300a" + inviteHistory.getRelationTitle() + "\u300b\u5e16\u5b50\u9080\u8bf7";
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return "";
        }
        ForumPostBriefInfoDto post = this.newsIntegrationService.getPostWithoutDetail(context.getRelationId());
        if (StringUtils.isBlank((CharSequence)post.getTitle())) {
            return "";
        }
        return post.getTitle();
    }
}

