/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.withdraw.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.merchant.constant.DistributedKey;
import com.bxm.localnews.merchant.domain.MerchantWithdrawFlowExtendMapper;
import com.bxm.localnews.merchant.dto.H5WithdrawDetail;
import com.bxm.localnews.merchant.dto.MerchantH5WithdrawItemDTO;
import com.bxm.localnews.merchant.dto.MerchantInfoDto;
import com.bxm.localnews.merchant.dto.MerchantToWithdrawDTO;
import com.bxm.localnews.merchant.dto.WithdrawAccountVO;
import com.bxm.localnews.merchant.entity.MerchantWithdrawFlow;
import com.bxm.localnews.merchant.entity.MerchantWithdrawManageFlow;
import com.bxm.localnews.merchant.enums.WithdrawStatus;
import com.bxm.localnews.merchant.integration.PaymentIntegrationService;
import com.bxm.localnews.merchant.param.H5MerchantWithdrawListParam;
import com.bxm.localnews.merchant.param.ManageMerchantWithdrawParam;
import com.bxm.localnews.merchant.param.MerchantWithdrawFacadeParam;
import com.bxm.localnews.merchant.param.MerchantWithdrawFlowListParam;
import com.bxm.localnews.merchant.param.MerchantWithdrawManageParam;
import com.bxm.localnews.merchant.param.MerchantWithdrawParam;
import com.bxm.localnews.merchant.service.MerchantInfoService;
import com.bxm.localnews.merchant.service.account.boss.BossAccountActionService;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.localnews.merchant.service.withdraw.MerchantWithdrawService;
import com.bxm.localnews.merchant.vo.MerchantWithdrawManageFlowVO;
import com.bxm.localnews.msg.integration.SmsIntegrationService;
import com.bxm.localnews.user.enums.WithdrawTypeEnum;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MerchantWithdrawServiceImpl
implements MerchantWithdrawService {
    private static final Logger log = LoggerFactory.getLogger(MerchantWithdrawServiceImpl.class);
    private final MerchantWithdrawFlowExtendMapper merchantWithdrawFlowExtendMapper;
    private final BossAccountActionService bossAccountActionService;
    private final SmsIntegrationService smsIntegrationService;
    private final MerchantInfoService merchantInfoService;
    private final SequenceCreater sequenceCreater;
    private final PaymentIntegrationService paymentIntegrationService;
    private final DistributedLock lock;

    @Override
    public MerchantToWithdrawDTO withdraw(MerchantWithdrawParam param) {
        String requestId;
        if (param.getWithdrawMoney().compareTo(BigDecimal.ZERO) <= 0) {
            return this.buildFailed("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u63d0\u73b0\u91d1\u989d");
        }
        String key = DistributedKey.WITHDRAW_SUBMIT.copy().appendKey((Object)param.getMerchantId()).gen();
        if (!this.lock.lock(key, requestId = this.sequenceCreater.nextStringId(), 2L, TimeUnit.SECONDS)) {
            return this.buildFailed("\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        param.setWithdrawChannel(Byte.valueOf((byte)2));
        Message message = this.merchantInfoService.getMerchantInfo(param.getMerchantId());
        if (!message.isSuccess()) {
            return this.buildFailed(message.getLastMessage());
        }
        MerchantInfoDto merchantInfoDto = (MerchantInfoDto)message.getParam("merchantInfoDto");
        if (Objects.isNull(merchantInfoDto)) {
            return this.buildFailed("\u5546\u6237\u4e0d\u5b58\u5728");
        }
        String mobile = merchantInfoDto.getMobile();
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return this.buildFailed("\u5546\u5bb6\u7ed1\u5b9a\u7684\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        }
        WithdrawAccountVO paymentAccount = this.paymentIntegrationService.getPaymentAccount(merchantInfoDto.getUserId());
        if (Objects.isNull(paymentAccount) || StringUtils.isBlank((CharSequence)paymentAccount.getAccount())) {
            return this.buildFailed("\u8bf7\u5148\u7ed1\u5b9a\u652f\u4ed8\u5b9d\u8d26\u53f7");
        }
        if (!Objects.equals(this.smsIntegrationService.verifyByType(Byte.valueOf((byte)9), mobile, param.getCode()), Boolean.TRUE)) {
            return this.buildFailed("\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25");
        }
        MerchantWithdrawFlow withdrawFlow = this.createWithdrawFlow(param, paymentAccount);
        BossAccountContext context = new BossAccountContext();
        context.setActionEnum(MerchantBossAccountActionEnum.ACCOUNT_ACTION_WITHDRAW_ING);
        context.setAmount(param.getWithdrawMoney());
        context.setUserId(merchantInfoDto.getUserId());
        context.setMerchantId(param.getMerchantId());
        context.setRelationId(withdrawFlow.getId());
        message = this.bossAccountActionService.bossAccountActionLogic(context);
        if (!message.isSuccess()) {
            return this.buildFailed(message.getLastMessage());
        }
        return this.convert(withdrawFlow);
    }

    @Override
    public PageWarper<MerchantH5WithdrawItemDTO> getH5WithdrawList(H5MerchantWithdrawListParam param) {
        MerchantWithdrawFlowListParam flowListParam = new MerchantWithdrawFlowListParam();
        flowListParam.setMerchantId(param.getMerchantId());
        flowListParam.setPageNum(param.getPageNum());
        flowListParam.setPageSize(param.getPageSize());
        PageWarper<MerchantWithdrawFlow> withdrawList = this.getWithdrawList(flowListParam);
        List withdrawItems = withdrawList.getList().stream().map(this::convert2MerchantH5WithdrawItemDTO).collect(Collectors.toList());
        return new PageWarper(withdrawItems);
    }

    @Override
    public H5WithdrawDetail getH5WithdrawDetail(Long withdrawId) {
        if (Objects.isNull(withdrawId)) {
            log.warn("\u83b7\u53d6\u63d0\u73b0\u8be6\u60c5\u5931\u8d25\uff0c\u63d0\u73b0id\u4e3a\u7a7a");
            return new H5WithdrawDetail();
        }
        MerchantWithdrawFlow merchantWithdrawFlow = this.merchantWithdrawFlowExtendMapper.selectByPrimaryKey(withdrawId);
        return this.convert2H5WithdrawDetail(merchantWithdrawFlow);
    }

    private H5WithdrawDetail convert2H5WithdrawDetail(MerchantWithdrawFlow flow) {
        if (Objects.isNull(flow)) {
            return new H5WithdrawDetail();
        }
        H5WithdrawDetail withdrawDTO = new H5WithdrawDetail();
        withdrawDTO.setRealName(flow.getRealName());
        withdrawDTO.setOrderNo(flow.getOrderNo());
        withdrawDTO.setWithdrawId(flow.getId());
        withdrawDTO.setWithdrawTime(flow.getCreateTime());
        withdrawDTO.setStatus(Integer.valueOf(this.convertStatus(flow.getState())));
        withdrawDTO.setWithdrawMoney(flow.getAmount());
        if (Objects.nonNull(flow.getPayChannel())) {
            withdrawDTO.setPayChannel(Byte.valueOf(flow.getPayChannel().byteValue()));
        }
        withdrawDTO.setAccount(flow.getPayAccount());
        return withdrawDTO;
    }

    private MerchantH5WithdrawItemDTO convert2MerchantH5WithdrawItemDTO(MerchantWithdrawFlow flow) {
        MerchantH5WithdrawItemDTO withdrawDTO = new MerchantH5WithdrawItemDTO();
        withdrawDTO.setWithdrawId(flow.getId());
        withdrawDTO.setWithdrawTime(flow.getCreateTime());
        withdrawDTO.setStatus(Integer.valueOf(this.convertStatus(flow.getState())));
        withdrawDTO.setWithdrawMoney(flow.getAmount());
        return withdrawDTO;
    }

    private int convertStatus(Byte status) {
        if (Objects.isNull(status)) {
            return 2;
        }
        switch (status) {
            case 3: {
                return 1;
            }
        }
        return 2;
    }

    @Override
    public PageWarper<MerchantWithdrawFlow> getWithdrawList(MerchantWithdrawFlowListParam param) {
        Page merchantWithdrawFlows = PageMethod.startPage((Object)param).doSelectPage(() -> this.merchantWithdrawFlowExtendMapper.selectByParam(param));
        return new PageWarper((List)merchantWithdrawFlows);
    }

    private MerchantToWithdrawDTO convert(MerchantWithdrawFlow flow) {
        MerchantToWithdrawDTO withdrawDTO = new MerchantToWithdrawDTO();
        withdrawDTO.setSuccess(Boolean.valueOf(true));
        withdrawDTO.setWithdrawMoney(flow.getAmount());
        withdrawDTO.setAccount(flow.getPayAccount());
        withdrawDTO.setPayChannel(Byte.valueOf(flow.getPayChannel().byteValue()));
        withdrawDTO.setWithdrawTime(flow.getCreateTime());
        withdrawDTO.setOrderNo(flow.getOrderNo());
        withdrawDTO.setWithdrawId(flow.getId());
        return withdrawDTO;
    }

    private MerchantWithdrawFlow createWithdrawFlow(MerchantWithdrawParam param, WithdrawAccountVO paymentAccount) {
        Date now = new Date();
        MerchantWithdrawFlow record = new MerchantWithdrawFlow();
        record.setId(this.sequenceCreater.nextLongId());
        record.setOrderNo(this.generateWithdrawNum(param.getWithdrawChannel()));
        record.setMerchantId(param.getMerchantId());
        record.setPayChannel(Long.valueOf(param.getWithdrawChannel().longValue()));
        record.setEquipment(param.getDevcId());
        record.setRealName(paymentAccount.getRealName());
        record.setPayAccount(paymentAccount.getAccount());
        record.setAmount(param.getWithdrawMoney());
        record.setFee(BigDecimal.ZERO);
        record.setState(Byte.valueOf(WithdrawStatus.CHECK.getStatus()));
        record.setClientIp(param.getClientIp());
        record.setEquipment(param.getDevcId());
        record.setCreateTime(now);
        record.setUpdateTime(now);
        this.merchantWithdrawFlowExtendMapper.insertSelective(record);
        return record;
    }

    private String generateWithdrawNum(byte withdrawChannel) {
        String prefix = WithdrawTypeEnum.getNameByType((Byte)withdrawChannel);
        return NidGeneratorUtil.getOrderNo((String)prefix);
    }

    private MerchantToWithdrawDTO buildFailed(String errorMsg) {
        return MerchantToWithdrawDTO.builder().success(Boolean.valueOf(false)).errorMsg(errorMsg).build();
    }

    @Override
    public PageWarper<MerchantWithdrawManageFlowVO> getManageListByParam(MerchantWithdrawManageParam param) {
        Page merchantWithdrawFlows = PageMethod.startPage((Object)param).doSelectPage(() -> this.merchantWithdrawFlowExtendMapper.selectByManageParam(param));
        PageWarper pageWarper = new PageWarper((List)merchantWithdrawFlows);
        pageWarper.setList(merchantWithdrawFlows.stream().map(this::convert).collect(Collectors.toList()));
        return pageWarper;
    }

    @Override
    public Message passWithdraw(ManageMerchantWithdrawParam param) {
        String requestId;
        if (!Objects.equals(param.getState(), (byte)1)) {
            return Message.build((boolean)false, (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
        }
        String key = DistributedKey.MANAGE_WITHDRAW.copy().appendKey((Object)param.getId()).gen();
        if (!this.lock.lock(key, requestId = this.sequenceCreater.nextStringId(), 2L, TimeUnit.SECONDS)) {
            return Message.build((boolean)false, (String)"\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        MerchantWithdrawFlow flow = this.merchantWithdrawFlowExtendMapper.selectByPrimaryKey(param.getId());
        if (Objects.isNull(flow)) {
            return Message.build((boolean)false, (String)"\u63d0\u73b0\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(flow.getState(), WithdrawStatus.SUCCESS.getStatus()) || Objects.equals(flow.getState(), WithdrawStatus.FAILED.getStatus())) {
            return Message.build((boolean)false, (String)"\u8be5\u72b6\u6001\u4e0d\u53ef\u64cd\u4f5c");
        }
        Message message = this.merchantInfoService.getMerchantInfo(flow.getMerchantId());
        if (!message.isSuccess()) {
            return message;
        }
        MerchantInfoDto merchantInfoDto = (MerchantInfoDto)message.getParam("merchantInfoDto");
        if (Objects.isNull(merchantInfoDto)) {
            return Message.build((boolean)false, (String)"\u5546\u6237\u4e0d\u5b58\u5728");
        }
        BossAccountContext context = new BossAccountContext();
        context.setActionEnum(MerchantBossAccountActionEnum.ACCOUNT_ACTION_WITHDRAW_SUCCESS);
        context.setAmount(flow.getAmount());
        context.setUserId(merchantInfoDto.getUserId());
        context.setRelationId(flow.getId());
        context.setMerchantId(flow.getMerchantId());
        message = this.bossAccountActionService.bossAccountActionLogic(context);
        if (!message.isSuccess()) {
            return this.passWithdrawLog(param, message);
        }
        MerchantWithdrawFacadeParam withdrawParam = new MerchantWithdrawFacadeParam();
        withdrawParam.setWithdrawNo(flow.getOrderNo());
        withdrawParam.setPayChannel(flow.getPayChannel());
        withdrawParam.setRealName(flow.getRealName());
        withdrawParam.setPayAccount(flow.getPayAccount());
        withdrawParam.setAmount(flow.getAmount());
        withdrawParam.setMerchantId(flow.getMerchantId());
        message = this.paymentIntegrationService.merchantWithdraw(withdrawParam);
        if (!message.isSuccess()) {
            this.merchantWithdrawFlowExtendMapper.updateStatue(flow.getId(), Byte.valueOf(WithdrawStatus.FAILED.getStatus()));
            return this.passWithdrawLog(param, message);
        }
        this.merchantWithdrawFlowExtendMapper.updateStatue(flow.getId(), Byte.valueOf(WithdrawStatus.SUCCESS.getStatus()));
        return this.passWithdrawLog(param, message);
    }

    private Message passWithdrawLog(ManageMerchantWithdrawParam param, Message message) {
        log.info("\u53d1\u8d77\u63d0\u73b0\uff0c\u8bf7\u6c42\u53c2\u6570: {} \u5904\u7406\u7ed3\u679c: {}", (Object)JSON.toJSONString((Object)param), (Object)JSON.toJSONString((Object)message));
        return message;
    }

    private MerchantWithdrawManageFlowVO convert(MerchantWithdrawManageFlow flow) {
        MerchantWithdrawManageFlowVO flowVO = new MerchantWithdrawManageFlowVO();
        BeanUtils.copyProperties((Object)flow, (Object)flowVO);
        return flowVO;
    }

    public MerchantWithdrawServiceImpl(MerchantWithdrawFlowExtendMapper merchantWithdrawFlowExtendMapper, BossAccountActionService bossAccountActionService, SmsIntegrationService smsIntegrationService, MerchantInfoService merchantInfoService, SequenceCreater sequenceCreater, PaymentIntegrationService paymentIntegrationService, DistributedLock lock) {
        this.merchantWithdrawFlowExtendMapper = merchantWithdrawFlowExtendMapper;
        this.bossAccountActionService = bossAccountActionService;
        this.smsIntegrationService = smsIntegrationService;
        this.merchantInfoService = merchantInfoService;
        this.sequenceCreater = sequenceCreater;
        this.paymentIntegrationService = paymentIntegrationService;
        this.lock = lock;
    }
}

