/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.work.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.domain.MerchantCollectMapper;
import com.bxm.localnews.merchant.dto.MerchantCollectInfoDetailDTO;
import com.bxm.localnews.merchant.param.CollectMerchantParam;
import com.bxm.localnews.merchant.param.MerchantCollectListParam;
import com.bxm.localnews.merchant.service.MerchantRedisRefresh;
import com.bxm.localnews.merchant.service.work.MerchantCollectService;
import com.bxm.localnews.merchant.vo.MerchantFavoriteVo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantCollectServiceImpl
implements MerchantCollectService {
    private static final Logger log = LogManager.getLogger(MerchantCollectServiceImpl.class);
    private final MerchantCollectMapper merchantCollectMapper;
    private final RedisStringAdapter redisStringAdapter;

    @Autowired
    public MerchantCollectServiceImpl(MerchantCollectMapper merchantCollectMapper, RedisStringAdapter redisStringAdapter) {
        this.merchantCollectMapper = merchantCollectMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public boolean collectMerchant(CollectMerchantParam param) {
        log.debug("userId : {},merchantId : {},type : {}", (Object)param.getUserId(), (Object)param.getMerchantId(), (Object)param.getType());
        if (Objects.isNull(param.getMerchantId()) || Objects.isNull(param.getUserId()) || Objects.isNull(param.getType())) {
            return false;
        }
        MerchantFavoriteVo merchantFavoriteVo = this.merchantCollectMapper.getFavoriteInfo(param.getMerchantId(), param.getUserId());
        if (Objects.isNull(merchantFavoriteVo)) {
            this.merchantCollectMapper.save(param.getMerchantId(), param.getUserId(), param.getType());
        } else {
            this.merchantCollectMapper.updateCollectInfo(param.getMerchantId(), param.getUserId(), param.getType());
        }
        ((MerchantRedisRefresh)SpringContextHolder.getBean(MerchantRedisRefresh.class)).refreshMerchantCollect(param.getUserId());
        return true;
    }

    @Override
    public PageWarper<MerchantCollectInfoDetailDTO> getCollectList(MerchantCollectListParam param) {
        log.debug("userId : {}", (Object)param.getUserId());
        List<MerchantCollectInfoDetailDTO> list = this.loadListInfo(param.getUserId());
        if (list.size() <= 0) {
            return new PageWarper();
        }
        Page page = new Page(param.getPageNum().intValue(), param.getPageSize().intValue());
        page.setTotal((long)list.size());
        page.addAll(list);
        return new PageWarper((List)page);
    }

    private List<MerchantCollectInfoDetailDTO> loadListInfo(Long userId) {
        String collectListStr = this.redisStringAdapter.getString(this.buildKey(userId));
        if (StringUtils.isNotBlank((CharSequence)collectListStr)) {
            return JSONArray.parseArray((String)collectListStr, MerchantCollectInfoDetailDTO.class);
        }
        return this.loadInfoFromDb(userId);
    }

    private KeyGenerator buildKey(Long userId) {
        return RedisConfig.MERCHANT_COLLECT_LIST_KEY.copy().appendKey((Object)userId);
    }

    @Override
    public List<MerchantCollectInfoDetailDTO> loadInfoFromDb(Long userId) {
        List list = this.merchantCollectMapper.getCollectList(userId);
        KeyGenerator key = this.buildKey(userId);
        if (list.size() > 0) {
            List<MerchantCollectInfoDetailDTO> result = list.stream().map(item -> {
                MerchantCollectInfoDetailDTO merchantCollectInfoDetailDTO = new MerchantCollectInfoDetailDTO();
                merchantCollectInfoDetailDTO.setMerchantId(item.getMerchantId());
                merchantCollectInfoDetailDTO.setMerchantName(item.getMerchantName());
                merchantCollectInfoDetailDTO.setShortDesc(item.getDes());
                merchantCollectInfoDetailDTO.setStatus(Integer.valueOf(item.getIsShelf() == 1 ? 1 : 0));
                merchantCollectInfoDetailDTO.setImgUrl(StringUtils.isNotBlank((CharSequence)item.getHeadPics()) ? Arrays.asList(item.getHeadPics().split(",")).get(0) : "");
                merchantCollectInfoDetailDTO.setCollectTime(item.getCreateTime() != null ? DateUtils.timeConvertString((Date)item.getCreateTime()) : null);
                return merchantCollectInfoDetailDTO;
            }).collect(Collectors.toList());
            this.redisStringAdapter.set(key, (Object)JSONArray.toJSONString(result));
            return result;
        }
        this.redisStringAdapter.remove(key);
        return new ArrayList<MerchantCollectInfoDetailDTO>();
    }
}

