/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.work.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.domain.MerchantCategoryMapper;
import com.bxm.localnews.merchant.domain.MerchantCollectMapper;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantWorkMapper;
import com.bxm.localnews.merchant.dto.MerchantChannelInfo;
import com.bxm.localnews.merchant.dto.MerchantDetailDTO;
import com.bxm.localnews.merchant.dto.MerchantWorkBase;
import com.bxm.localnews.merchant.dto.MerchantWorkListDTO;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.goods.MerchantWorkGoodsDTO;
import com.bxm.localnews.merchant.entity.MerchantCategoryEntity;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.MerChantListParam;
import com.bxm.localnews.merchant.param.MerchantDetailParam;
import com.bxm.localnews.merchant.service.goods.GoodsService;
import com.bxm.localnews.merchant.service.work.MerchantListService;
import com.bxm.localnews.merchant.vo.MerchantFavoriteVo;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.localnews.merchant.vo.MerchantWorkListVo;
import com.bxm.localnews.merchant.vo.UserForMerchantInfo;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MerchantWorkServiceImpl
implements MerchantListService {
    private static final Logger log = LogManager.getLogger(MerchantWorkServiceImpl.class);
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private GeoService geoService;
    @Resource
    MerchantWorkMapper merchantWorkMapper;
    @Resource
    MerchantInfoMapper merchantInfoMapper;
    @Resource
    UserIntegrationService userIntegrationService;
    @Resource
    MerchantCollectMapper merchantCollectMapper;
    @Resource
    MerchantCategoryMapper merchantCategoryMapper;
    @Resource
    private GoodsService goodsService;
    private static int DEFAULT_NUM = 0;
    private static int DISTANCE_LEVE = 1000;
    private static int DISTANCE_LEVE2 = 500;

    @Override
    public PageWarper<MerchantWorkListDTO> getMerchantList(MerChantListParam param) {
        List<MerchantWorkListDTO> resultList;
        if (log.isDebugEnabled()) {
            log.debug("param : {}", (Object)param);
        }
        if ((resultList = this.loadMerchantListInfo(param)).size() <= 0) {
            return new PageWarper();
        }
        if (log.isDebugEnabled()) {
            log.debug("result : {}", resultList);
        }
        if (!CollectionUtils.isEmpty(resultList = this.sorted(resultList, param))) {
            resultList.forEach(merchantWorkListDTO -> {
                if (merchantWorkListDTO != null) {
                    List<MerchantWorkGoodsDTO> merchantWorkGoodsDTOS = this.goodsService.queryWorkGoods(merchantWorkListDTO.getMerchantId());
                    merchantWorkListDTO.setGoodsDTOList(merchantWorkGoodsDTOS);
                }
            });
        }
        int start = (param.getPageNum() - 1) * param.getPageSize();
        int end = param.getPageNum() * param.getPageSize();
        if (start < 0) {
            start = 0;
        }
        if (end > resultList.size()) {
            end = resultList.size();
        }
        List<MerchantWorkListDTO> pageRecords = resultList.subList(start, end);
        Page page = new Page(param.getPageNum().intValue(), param.getPageSize().intValue());
        page.setTotal((long)resultList.size());
        page.addAll(pageRecords);
        return new PageWarper((List)page);
    }

    @Override
    public MerchantDetailDTO getMerchantDetail(MerchantDetailParam param) {
        MerchantInfo merchantInfo;
        if (log.isDebugEnabled()) {
            log.debug("param : {},merchantId\uff1a{}", (Object)param, (Object)param.getMerchantId());
        }
        if (Objects.isNull(merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(param.getMerchantId()))) {
            log.error("\u83b7\u53d6\u8be6\u60c5\u65f6 \u5546\u5bb6\u65e0\u6570\u636e  merchantId : {}", (Object)param.getMerchantId());
            return new MerchantDetailDTO();
        }
        if (log.isDebugEnabled()) {
            log.debug("merchantInfo : {}", (Object)merchantInfo);
        }
        MerchantDetailDTO merchantDetailDTO = this.convertToDetail(merchantInfo, param);
        this.distanceCalculationDetail(param, merchantDetailDTO);
        return merchantDetailDTO;
    }

    private void distanceCalculationDetail(MerchantDetailParam param, MerchantDetailDTO merchantDetailDTO) {
        if (param.getLatitude() != null && param.getLongitude() != null) {
            Coordinate userLngAndLat = new Coordinate();
            userLngAndLat.setLongitude(param.getLongitude());
            userLngAndLat.setLatitude(param.getLatitude());
            if (merchantDetailDTO.getLat() != null && merchantDetailDTO.getLng() != null) {
                Long distance = this.fillDistance(userLngAndLat, merchantDetailDTO.getLat(), merchantDetailDTO.getLng());
                merchantDetailDTO.setDistance(this.distance(distance));
            }
        }
    }

    private MerchantDetailDTO convertToDetail(MerchantInfo merchantInfo, MerchantDetailParam param) {
        UserInfoDTO userInfoDTO;
        MerchantFavoriteVo merchantFavoriteVo;
        MerchantDetailDTO result = new MerchantDetailDTO();
        BeanUtils.copyProperties((Object)merchantInfo, (Object)result);
        result.setMerchantId(merchantInfo.getId());
        result.setIsVip(merchantInfo.getJudgeMarker());
        result.setShortDesc(merchantInfo.getDes());
        result.setTownName(merchantInfo.getAddress());
        result.setBusinessArea(Objects.nonNull(merchantInfo.getAddress()) ? merchantInfo.getAddress() : null);
        result.setWorkTime(merchantInfo.getOpenType().equals(DEFAULT_NUM) ? "\u5168\u5929" : merchantInfo.getOpenTime() + "-" + merchantInfo.getCloseTime());
        result.setFacadeUrl(StringUtils.isNotBlank((CharSequence)merchantInfo.getHeadPics()) ? Arrays.asList(merchantInfo.getHeadPics().split(",")) : new ArrayList());
        result.setImgUrls(StringUtils.isNotBlank((CharSequence)merchantInfo.getAlbum()) ? Arrays.asList(merchantInfo.getAlbum().split(",")) : new ArrayList());
        result.setServicePhone(StringUtils.isNotBlank((CharSequence)merchantInfo.getMobile()) ? merchantInfo.getMobile() : null);
        result.setDescription(StringUtils.isNotBlank((CharSequence)merchantInfo.getDetailContent()) ? merchantInfo.getDetailContent() : null);
        if (merchantInfo.getLat() != null) {
            result.setLat(Double.valueOf(merchantInfo.getLat().doubleValue()));
        }
        if (merchantInfo.getLng() != null) {
            result.setLng(Double.valueOf(merchantInfo.getLng().doubleValue()));
        }
        if (Objects.nonNull(merchantFavoriteVo = this.merchantCollectMapper.getFavoriteInfo(param.getMerchantId(), param.getUserId()))) {
            result.setHasCollected(merchantFavoriteVo.getStatus());
        } else {
            result.setHasCollected(Integer.valueOf(DEFAULT_NUM));
        }
        MerchantCategoryEntity categoryEntity = this.merchantCategoryMapper.selectByPrimaryKey(merchantInfo.getCategoryId());
        result.setCategoryName(Objects.nonNull(categoryEntity) ? categoryEntity.getCatName() : null);
        if (merchantInfo.getUserId() != null && Objects.nonNull(userInfoDTO = this.userIntegrationService.getUserFromRedisDB(merchantInfo.getUserId()))) {
            UserForMerchantInfo userInfo = UserForMerchantInfo.builder().userId(Integer.valueOf(merchantInfo.getUserId().intValue())).headimgurl(StringUtils.isNotBlank((CharSequence)userInfoDTO.getHeadImg()) ? userInfoDTO.getHeadImg() : "").nickName(StringUtils.isNotBlank((CharSequence)userInfoDTO.getNickname()) ? userInfoDTO.getNickname() : "").userJobDesc(StringUtils.isNotBlank((CharSequence)userInfoDTO.getJobTitle()) ? userInfoDTO.getJobTitle() : "").build();
            result.setUserForMerchantInfo(userInfo);
        }
        return result;
    }

    private List<MerchantWorkListDTO> sorted(List<MerchantWorkListDTO> list, MerChantListParam param) {
        if (Objects.isNull(param.getCategoryId()) || param.getCategoryId() == (long)DEFAULT_NUM) {
            List<MerchantWorkListDTO> topForBmTotal = list.stream().filter(item -> item.getBianMinOrder() > 0 && DateUtils.before((Date)item.getBianMinStartTime()) && DateUtils.after((Date)item.getBianMinEndTime())).sorted(Comparator.comparing(MerchantWorkListDTO::getBianMinOrder)).collect(Collectors.toList());
            topForBmTotal.forEach(i -> i.setBianMinTopStatus(Integer.valueOf(1)));
            return this.sortedCommon(list, topForBmTotal, param);
        }
        List<MerchantWorkListDTO> topForChannel = list.stream().filter(item -> item.getChannelOrder() > 0 && DateUtils.before((Date)item.getChannelStartTime()) && DateUtils.after((Date)item.getChannelEndTime())).sorted(Comparator.comparing(MerchantWorkListDTO::getChannelOrder)).collect(Collectors.toList());
        topForChannel.forEach(i -> i.setChannelTopStatus(Integer.valueOf(1)));
        return this.sortedCommon(list, topForChannel, param);
    }

    private List<MerchantWorkListDTO> sortedCommon(List<MerchantWorkListDTO> list, List<MerchantWorkListDTO> listTop, MerChantListParam param) {
        if (param.getLongitude() == 0.0 && param.getLatitude() == 0.0) {
            list.removeAll(listTop);
            list.sort(Comparator.comparing(MerchantWorkListDTO::getToVipDate, Comparator.nullsLast(Date::compareTo)).reversed());
            listTop.addAll(list);
            listTop.forEach(item -> {
                item.setDistance("");
                item.setDistanceNum(null);
            });
            return listTop;
        }
        if (param.getSortType() == DEFAULT_NUM) {
            list.removeAll(listTop);
            list.sort(Comparator.comparing(MerchantWorkBase::getDistanceNum, Comparator.nullsLast(Long::compareTo)));
            listTop.addAll(list);
            return listTop;
        }
        list.sort(Comparator.comparing(MerchantWorkBase::getDistanceNum, Comparator.nullsLast(Long::compareTo)));
        return list;
    }

    private List<MerchantWorkListDTO> loadMerchantListInfo(MerChantListParam param) {
        List<Object> list = new ArrayList();
        String listInfoStrFromRedis = this.redisStringAdapter.getString(this.getListKey(param.getAreaCode(), param.getCategoryId()));
        list = StringUtils.isNotBlank((CharSequence)listInfoStrFromRedis) ? JSONArray.parseArray((String)listInfoStrFromRedis, MerchantWorkListDTO.class) : this.getFromDb(param);
        this.distanceCalculation(param, list);
        return list;
    }

    @Override
    public List<MerchantWorkListDTO> getFromDb(MerChantListParam param) {
        List listFromDb = this.merchantWorkMapper.selectByCategoryId(param.getCategoryId(), param.getAreaCode());
        KeyGenerator listKey = this.getListKey(param.getAreaCode(), param.getCategoryId());
        if (listFromDb.size() > 0) {
            List<MerchantWorkListDTO> list = listFromDb.stream().map(this::convert).collect(Collectors.toList());
            this.redisStringAdapter.set(listKey, (Object)JSONArray.toJSONString(list));
            return list;
        }
        this.redisStringAdapter.remove(listKey);
        return new ArrayList<MerchantWorkListDTO>();
    }

    @Override
    public void removeCache(String areaCode, Long categoryId) {
        this.redisStringAdapter.remove(this.getListKey(areaCode, categoryId));
        this.redisStringAdapter.remove(this.getListKey(areaCode, 0L));
    }

    @Override
    public List<MerchantChannelInfo> getChannelQuMerchantList(MerChantListParam param) {
        List merchantChannelQuVos = this.merchantWorkMapper.selectForQuByCategoryId(param.getCategoryId(), param.getAreaCode());
        return merchantChannelQuVos.stream().map(s -> {
            MerchantChannelInfo result = new MerchantChannelInfo();
            BeanUtils.copyProperties((Object)s, (Object)result);
            result.setIcon(s.getLogo());
            return result;
        }).collect(Collectors.toList());
    }

    private MerchantWorkListDTO convert(MerchantWorkListVo merchantWorkListVo) {
        MerchantWorkListDTO merchantWorkListDTO = new MerchantWorkListDTO();
        BeanUtils.copyProperties((Object)merchantWorkListVo, (Object)merchantWorkListDTO);
        merchantWorkListDTO.setLat(Double.valueOf(merchantWorkListVo.getLat().doubleValue()));
        merchantWorkListDTO.setLng(Double.valueOf(merchantWorkListVo.getLng().doubleValue()));
        merchantWorkListDTO.setMerchantId(merchantWorkListVo.getId());
        merchantWorkListDTO.setShortDesc(Objects.nonNull(merchantWorkListVo.getDes()) ? merchantWorkListVo.getDes() : null);
        merchantWorkListDTO.setTownName(Objects.nonNull(merchantWorkListVo.getAddress()) ? merchantWorkListVo.getAddress() : null);
        merchantWorkListDTO.setHeadImg(Objects.nonNull(merchantWorkListVo.getHeadPics()) ? Arrays.asList(merchantWorkListVo.getHeadPics().split(",")).get(0) : null);
        merchantWorkListDTO.setWorkTime(merchantWorkListVo.getOpenType().equals(DEFAULT_NUM) ? "\u5168\u5929" : merchantWorkListVo.getOpenTime() + "-" + merchantWorkListVo.getCloseTime());
        merchantWorkListDTO.setIsVip(merchantWorkListVo.getJudgeMarker());
        return merchantWorkListDTO;
    }

    private void distanceCalculation(MerChantListParam param, List<MerchantWorkListDTO> list) {
        if (param.getLatitude() != null && param.getLongitude() != null) {
            Coordinate userLngAndLat = new Coordinate();
            userLngAndLat.setLongitude(param.getLongitude());
            userLngAndLat.setLatitude(param.getLatitude());
            for (MerchantWorkBase merchantWorkBase : list) {
                if (merchantWorkBase.getLat() == null || merchantWorkBase.getLng() == null) continue;
                Long distance = this.fillDistance(userLngAndLat, merchantWorkBase.getLat(), merchantWorkBase.getLng());
                merchantWorkBase.setDistance(this.distance(distance));
                merchantWorkBase.setDistanceNum(distance);
            }
        }
    }

    private String distance(Long distance) {
        if (distance >= (long)DISTANCE_LEVE) {
            return (double)Math.round((double)distance.longValue() / 100.0) / 10.0 + "km";
        }
        if (distance >= (long)DISTANCE_LEVE2) {
            return distance + "m";
        }
        return "<500m";
    }

    private Long fillDistance(Coordinate userLngAndLat, Double geoLat, Double geoLng) {
        Coordinate lngAndLat = new Coordinate();
        lngAndLat.setLongitude(geoLng);
        lngAndLat.setLatitude(geoLat);
        return this.geoService.getDistance(userLngAndLat, lngAndLat);
    }

    private KeyGenerator getListKey(String areaCode, Long categoryId) {
        return RedisConfig.MERCHANT_WORK_KEY.copy().appendKey((Object)(StringUtils.isNotBlank((CharSequence)areaCode) ? areaCode : "all")).appendKey((Object)categoryId);
    }
}

