/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.supporter;

import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.vo.MerchantInfo;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LocationHelper {
    private static final Logger log = LoggerFactory.getLogger(LocationHelper.class);
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private GeoService geoService;

    public boolean fillLocation(MerchantInfo info) {
        if (null == info) {
            return false;
        }
        boolean changeFlag = false;
        String address = "";
        if (StringUtils.isNotBlank((String)info.getCountyCode()) && StringUtils.isNotBlank((String)info.getAddress())) {
            Coordinate coordinate;
            LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(info.getCountyCode());
            if (locationByGeocode != null) {
                address = locationByGeocode.getFullName() + info.getAddress();
            }
            if (StringUtils.isNotBlank((String)address) && (coordinate = this.geoService.getCoordinate(address)) != null) {
                if (coordinate.getLatitude() != null) {
                    info.setLat(BigDecimal.valueOf(coordinate.getLatitude()));
                }
                if (coordinate.getLongitude() != null) {
                    info.setLng(BigDecimal.valueOf(coordinate.getLongitude()));
                }
                changeFlag = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bbe\u7f6e\u7ecf\u7eac\u5ea6\u4fe1\u606f\uff0c\u5546\u5bb6ID\uff1a{},\u5730\u5740\u4fe1\u606f\uff1a{},\u89e3\u6790\u7684\u7ecf\u7eac\u5ea6\uff1a{} - {}", new Object[]{info.getId(), address, info.getLat(), info.getLng()});
        }
        return changeFlag;
    }
}

