/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.timer;

import com.bxm.localnews.merchant.domain.UserInviteHistoryMapper;
import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.service.invite.InviteProcessService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FixUserInviteHistoryTitleTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(FixUserInviteHistoryTitleTask.class);
    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;
    @Autowired
    private InviteProcessService inviteProcessService;

    protected ReturnT<String> service(String s) {
        int maxTimes = 5;
        this.execFix(maxTimes);
        return ReturnT.SUCCESS;
    }

    private void execFix(int times) {
        if (times <= 0) {
            log.warn("\u4fee\u590d\u6536\u5f92\u6807\u9898\u7684\u5904\u7406\u6b21\u6570\u4f7f\u7528\u5b8c\uff0c\u6b64\u4e3a\u5f02\u5e38\u60c5\u51b5\uff0c\u8bf7\u5173\u6ce8\u662f\u5426\u6709\u903b\u8f91\u5c06\u6807\u9898\u8bbe\u7f6e\u4e3anull");
            return;
        }
        List emptyTitleList = this.userInviteHistoryMapper.queryEmptyTitleRecord();
        if (emptyTitleList.size() == 0) {
            return;
        }
        for (UserInviteHistoryEntity historyBean : emptyTitleList) {
            String title = this.inviteProcessService.getInviteTitle(historyBean);
            if (null == title) {
                title = "";
            }
            historyBean.setRelationTitle(title);
            this.userInviteHistoryMapper.updateTitle(historyBean);
        }
        this.execFix(--times);
    }

    public String taskName() {
        return "\u5b9a\u671f\u4fee\u590d\u9080\u8bf7\u5f92\u5f1f\u4fe1\u606f\u4e2d\u7684\u6807\u9898";
    }

    public String cron() {
        return "0 0/10 * * * ?";
    }

    public String version() {
        return "1.0.0";
    }
}

