/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.timer;

import com.bxm.localnews.merchant.domain.MerchantActionRecordMapper;
import com.bxm.localnews.merchant.domain.MerchantMemberMapper;
import com.bxm.localnews.merchant.service.PushIntegrationService;
import com.bxm.localnews.merchant.vo.MerchantMemberVo;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MerchantStaffWeekReportTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(MerchantStaffWeekReportTask.class);
    private String content = "\u4e0a\u5468\uff0c\u60a8\u5171\u5206\u4eab\u4e86%s\u7bc7\u6587\u7ae0\uff0c\u5171%s\u4eba\u6d4f\u89c8\uff0c\u83b7\u5f97%s\u6761\u5ba2\u6237\u7ebf\u7d22\uff0c%s\u4e2a\u8ba2\u5355";
    private String title = "\u6211\u7684\u8425\u9500\u5468\u62a5";
    @Autowired
    private MerchantMemberMapper merchantMemberMapper;
    @Autowired
    private MerchantActionRecordMapper merchantActionRecordMapper;
    @Autowired
    private PushIntegrationService pushIntegrationService;

    public ReturnT<String> service(String s) {
        List listStaff = this.merchantMemberMapper.getMerchantMemberList();
        if (listStaff.isEmpty()) {
            return ReturnT.SUCCESS;
        }
        Date begin = DateUtils.addDays((Date)new Date(), (int)-7);
        Date end = new Date();
        List allListWeek = this.merchantActionRecordMapper.getEmployeeReportList(begin, end);
        HashMap mapListWeek = new HashMap();
        if (allListWeek.size() > 0) {
            allListWeek.forEach(merchantWeekReportDTO -> mapListWeek.put(merchantWeekReportDTO.getBelonger() + "_" + merchantWeekReportDTO.getActionType(), merchantWeekReportDTO.getNum()));
        }
        for (MerchantMemberVo merchantMemberVo : listStaff) {
            Long share = (Long)mapListWeek.get(merchantMemberVo.getUserId() + "_" + 0);
            Long view = (Long)mapListWeek.get(merchantMemberVo.getUserId() + "_" + 1);
            Long click = (Long)mapListWeek.get(merchantMemberVo.getUserId() + "_" + 2);
            Long order = (Long)mapListWeek.get(merchantMemberVo.getUserId() + "_" + 3);
            String info = String.format(this.content, null == share ? 0L : share, null == view ? 0L : view, null == click ? 0L : click, null == order ? 0L : order);
            log.info("\u5458\u5de5id\u300b\u300b\u300b{}.....info:::?>>>>{}", (Object)merchantMemberVo.getUserId(), (Object)info);
            this.pushIntegrationService.pushEmployeeWeekReport(merchantMemberVo.getMerchantId(), merchantMemberVo.getUserId(), this.title, info);
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "\u5168\u5458\u8425\u9500\u5458\u5de5\u5468\u62a5\u53d1\u9001\u3010\u7ed9\u5458\u5de5\u53d1\u9001\u5468\u62a5\u3011";
    }

    public String cron() {
        return "0 0 10 ? * MON";
    }
}

