/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.timer;

import com.bxm.localnews.merchant.domain.MerchantPrerogativeInfoMapper;
import com.bxm.localnews.merchant.entity.MerchantPrerogativeInfoEntity;
import com.bxm.localnews.merchant.service.MerchantRedisRefresh;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MerchantVipTimeoutTask
extends AbstractCronTask<String> {
    private final MerchantPrerogativeInfoMapper merchantPrerogativeInfoMapper;
    private final MerchantRedisRefresh merchantRedisRefresh;

    @Autowired
    public MerchantVipTimeoutTask(MerchantPrerogativeInfoMapper merchantPrerogativeInfoMapper, MerchantRedisRefresh merchantRedisRefresh) {
        this.merchantPrerogativeInfoMapper = merchantPrerogativeInfoMapper;
        this.merchantRedisRefresh = merchantRedisRefresh;
    }

    protected ReturnT<String> service(String callbackParam) {
        List timeoutList = this.merchantPrerogativeInfoMapper.getTimeoutList();
        if (!CollectionUtils.isEmpty((Collection)timeoutList)) {
            ArrayList<Long> timeoutIds = new ArrayList<Long>(timeoutList.size());
            for (MerchantPrerogativeInfoEntity entity : timeoutList) {
                timeoutIds.add(entity.getId());
                this.merchantRedisRefresh.refreshMerchantList(entity.getMerchantId());
            }
            this.merchantPrerogativeInfoMapper.updateTimeoutInfo(timeoutIds);
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "MERCHANT_PREROGATIVE_TIME_OUT_TASK";
    }

    public String cron() {
        return "0 0 0 * * ?";
    }

    public String description() {
        return "\u5546\u5bb6\u6743\u76ca\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1[\u5305\u62ecvip\u548c\u5e7f\u544a]";
    }
}

