/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.config;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="merchant.config")
public class MerchantProperties {
    private String merchantApplyPath = "/tk/merchant.html#/application?userId={userId}&areaCode={areaCode}&areaName={areaName}&phone={phone}";
    private String merchantCenterPath = "/tk/merchant.html#/shopCenter?userId={userId}&areaCode={areaCode}&areaName={areaName}&merchantId={merchantId}";
    private String merchantPromotePath = "/tk/merchantMarketing.html#/income/index?userId={userId}&areaCode={areaCode}&areaName={areaName}&merchantId={merchantId}";
    private Boolean enableEnterNotify = true;
    private Boolean personalEnterSwitch = Boolean.FALSE;
    private String marketUrlBase = "/tk/marketing.html#/staff?userId={userId}&areaCode={areaCode}&areaName={areaName}&merchantId={merchantId}";
    private List<String> openCityCodes = Lists.newArrayList();
    private List<Long> followUserIds = Lists.newArrayList();
    private BigDecimal defaultOriginalPromoteAmt = BigDecimal.valueOf(5999L);

    public String getMerchantApplyPath() {
        return this.merchantApplyPath;
    }

    public String getMerchantCenterPath() {
        return this.merchantCenterPath;
    }

    public String getMerchantPromotePath() {
        return this.merchantPromotePath;
    }

    public Boolean getEnableEnterNotify() {
        return this.enableEnterNotify;
    }

    public Boolean getPersonalEnterSwitch() {
        return this.personalEnterSwitch;
    }

    public String getMarketUrlBase() {
        return this.marketUrlBase;
    }

    public List<String> getOpenCityCodes() {
        return this.openCityCodes;
    }

    public List<Long> getFollowUserIds() {
        return this.followUserIds;
    }

    public BigDecimal getDefaultOriginalPromoteAmt() {
        return this.defaultOriginalPromoteAmt;
    }

    public void setMerchantApplyPath(String merchantApplyPath) {
        this.merchantApplyPath = merchantApplyPath;
    }

    public void setMerchantCenterPath(String merchantCenterPath) {
        this.merchantCenterPath = merchantCenterPath;
    }

    public void setMerchantPromotePath(String merchantPromotePath) {
        this.merchantPromotePath = merchantPromotePath;
    }

    public void setEnableEnterNotify(Boolean enableEnterNotify) {
        this.enableEnterNotify = enableEnterNotify;
    }

    public void setPersonalEnterSwitch(Boolean personalEnterSwitch) {
        this.personalEnterSwitch = personalEnterSwitch;
    }

    public void setMarketUrlBase(String marketUrlBase) {
        this.marketUrlBase = marketUrlBase;
    }

    public void setOpenCityCodes(List<String> openCityCodes) {
        this.openCityCodes = openCityCodes;
    }

    public void setFollowUserIds(List<Long> followUserIds) {
        this.followUserIds = followUserIds;
    }

    public void setDefaultOriginalPromoteAmt(BigDecimal defaultOriginalPromoteAmt) {
        this.defaultOriginalPromoteAmt = defaultOriginalPromoteAmt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MerchantProperties)) {
            return false;
        }
        MerchantProperties other = (MerchantProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$merchantApplyPath = this.getMerchantApplyPath();
        String other$merchantApplyPath = other.getMerchantApplyPath();
        if (this$merchantApplyPath == null ? other$merchantApplyPath != null : !this$merchantApplyPath.equals(other$merchantApplyPath)) {
            return false;
        }
        String this$merchantCenterPath = this.getMerchantCenterPath();
        String other$merchantCenterPath = other.getMerchantCenterPath();
        if (this$merchantCenterPath == null ? other$merchantCenterPath != null : !this$merchantCenterPath.equals(other$merchantCenterPath)) {
            return false;
        }
        String this$merchantPromotePath = this.getMerchantPromotePath();
        String other$merchantPromotePath = other.getMerchantPromotePath();
        if (this$merchantPromotePath == null ? other$merchantPromotePath != null : !this$merchantPromotePath.equals(other$merchantPromotePath)) {
            return false;
        }
        Boolean this$enableEnterNotify = this.getEnableEnterNotify();
        Boolean other$enableEnterNotify = other.getEnableEnterNotify();
        if (this$enableEnterNotify == null ? other$enableEnterNotify != null : !((Object)this$enableEnterNotify).equals(other$enableEnterNotify)) {
            return false;
        }
        Boolean this$personalEnterSwitch = this.getPersonalEnterSwitch();
        Boolean other$personalEnterSwitch = other.getPersonalEnterSwitch();
        if (this$personalEnterSwitch == null ? other$personalEnterSwitch != null : !((Object)this$personalEnterSwitch).equals(other$personalEnterSwitch)) {
            return false;
        }
        String this$marketUrlBase = this.getMarketUrlBase();
        String other$marketUrlBase = other.getMarketUrlBase();
        if (this$marketUrlBase == null ? other$marketUrlBase != null : !this$marketUrlBase.equals(other$marketUrlBase)) {
            return false;
        }
        List<String> this$openCityCodes = this.getOpenCityCodes();
        List<String> other$openCityCodes = other.getOpenCityCodes();
        if (this$openCityCodes == null ? other$openCityCodes != null : !((Object)this$openCityCodes).equals(other$openCityCodes)) {
            return false;
        }
        List<Long> this$followUserIds = this.getFollowUserIds();
        List<Long> other$followUserIds = other.getFollowUserIds();
        if (this$followUserIds == null ? other$followUserIds != null : !((Object)this$followUserIds).equals(other$followUserIds)) {
            return false;
        }
        BigDecimal this$defaultOriginalPromoteAmt = this.getDefaultOriginalPromoteAmt();
        BigDecimal other$defaultOriginalPromoteAmt = other.getDefaultOriginalPromoteAmt();
        return !(this$defaultOriginalPromoteAmt == null ? other$defaultOriginalPromoteAmt != null : !((Object)this$defaultOriginalPromoteAmt).equals(other$defaultOriginalPromoteAmt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MerchantProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $merchantApplyPath = this.getMerchantApplyPath();
        result = result * 59 + ($merchantApplyPath == null ? 43 : $merchantApplyPath.hashCode());
        String $merchantCenterPath = this.getMerchantCenterPath();
        result = result * 59 + ($merchantCenterPath == null ? 43 : $merchantCenterPath.hashCode());
        String $merchantPromotePath = this.getMerchantPromotePath();
        result = result * 59 + ($merchantPromotePath == null ? 43 : $merchantPromotePath.hashCode());
        Boolean $enableEnterNotify = this.getEnableEnterNotify();
        result = result * 59 + ($enableEnterNotify == null ? 43 : ((Object)$enableEnterNotify).hashCode());
        Boolean $personalEnterSwitch = this.getPersonalEnterSwitch();
        result = result * 59 + ($personalEnterSwitch == null ? 43 : ((Object)$personalEnterSwitch).hashCode());
        String $marketUrlBase = this.getMarketUrlBase();
        result = result * 59 + ($marketUrlBase == null ? 43 : $marketUrlBase.hashCode());
        List<String> $openCityCodes = this.getOpenCityCodes();
        result = result * 59 + ($openCityCodes == null ? 43 : ((Object)$openCityCodes).hashCode());
        List<Long> $followUserIds = this.getFollowUserIds();
        result = result * 59 + ($followUserIds == null ? 43 : ((Object)$followUserIds).hashCode());
        BigDecimal $defaultOriginalPromoteAmt = this.getDefaultOriginalPromoteAmt();
        result = result * 59 + ($defaultOriginalPromoteAmt == null ? 43 : ((Object)$defaultOriginalPromoteAmt).hashCode());
        return result;
    }

    public String toString() {
        return "MerchantProperties(merchantApplyPath=" + this.getMerchantApplyPath() + ", merchantCenterPath=" + this.getMerchantCenterPath() + ", merchantPromotePath=" + this.getMerchantPromotePath() + ", enableEnterNotify=" + this.getEnableEnterNotify() + ", personalEnterSwitch=" + this.getPersonalEnterSwitch() + ", marketUrlBase=" + this.getMarketUrlBase() + ", openCityCodes=" + this.getOpenCityCodes() + ", followUserIds=" + this.getFollowUserIds() + ", defaultOriginalPromoteAmt=" + this.getDefaultOriginalPromoteAmt() + ")";
    }
}

