/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account;

import com.bxm.localnews.merchant.common.enums.MerchantAccountTypeEnum;
import com.bxm.localnews.merchant.dto.account.MerchantAccountInfoDTO;
import com.bxm.localnews.merchant.service.account.AbstractUserProAccount;
import com.bxm.localnews.merchant.service.account.DefaultUserProAccount;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserProAccountStrategy {
    private Map<MerchantAccountTypeEnum, AbstractUserProAccount> userProAccountMap = Maps.newHashMap();
    private DefaultUserProAccount defaultUserProAccount;

    @Autowired
    public UserProAccountStrategy(List<AbstractUserProAccount> processors, DefaultUserProAccount defaultUserProAccount) {
        if (null != processors) {
            processors.forEach(processor -> this.userProAccountMap.put(processor.getType(), (AbstractUserProAccount)processor));
        }
        this.defaultUserProAccount = defaultUserProAccount;
    }

    public Message exection(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        return this.userProAccountMap.getOrDefault(merchantAccountInfoDTO.getType(), this.defaultUserProAccount).execute(merchantAccountInfoDTO);
    }
}

