/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.handle.processor;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossCashFlagEnum;
import com.bxm.localnews.merchant.domain.MerchantAccountMapper;
import com.bxm.localnews.merchant.entity.MerchantAccountEntity;
import com.bxm.localnews.merchant.service.account.boss.BossAccountCacheService;
import com.bxm.localnews.merchant.service.account.boss.handle.AbstractBossAccountHandle;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayActionProcessor
extends AbstractBossAccountHandle {
    private static final Logger log = LoggerFactory.getLogger(PayActionProcessor.class);
    @Resource
    private MerchantAccountMapper merchantAccountMapper;
    @Autowired
    private BossAccountCacheService bossAccountCacheService;

    @Override
    protected Message checkLogic(BossAccountContext context) {
        if (Objects.isNull(context.getPayMoney())) {
            return Message.build((boolean)false);
        }
        if (Objects.isNull(context.getServiceMoney())) {
            return Message.build((boolean)false);
        }
        if (Objects.isNull(context.getReceiveMoney())) {
            return Message.build((boolean)false);
        }
        return Message.build((boolean)true);
    }

    @Override
    protected void bossAccountChange(BossAccountContext context) {
        MerchantAccountEntity entity;
        int flag;
        int times = 0;
        do {
            entity = super.accountEntity(context);
            entity.setTotalCash(entity.getTotalCash().add(context.getReceiveMoney()));
            entity.setFreezeCash(entity.getFreezeCash().add(context.getReceiveMoney()));
            entity.setVersion(entity.getVersion());
            if (!log.isDebugEnabled()) continue;
            log.debug("\u5546\u6237id:{}, \u6536\u76ca\u91d1\u989d\uff1a{}", (Object)context.getMerchantId(), (Object)context.getReceiveMoney());
            log.debug("\u5546\u6237id:{}, \u4fee\u6539\u8d26\u6237\u4fe1\u606f\uff1a{}", (Object)context.getMerchantId(), (Object)JSON.toJSONString((Object)entity));
        } while ((flag = this.merchantAccountMapper.updateByPrimaryKeySelective(entity)) <= 0 && ++times < 3);
        if (flag <= 0) {
            throw new BusinessException("\u8d26\u6237\u53d8\u66f4\u5931\u8d25\uff01");
        }
        this.bossAccountCacheService.cacheAccountToday(context.getMerchantId(), context.getReceiveMoney());
    }

    @Override
    protected void addAccountCash(BossAccountContext context) {
        this.addCash(context, MerchantBossAccountCashTypeEnum.CASH_PAYMENT, context.getPayMoney(), "\u8ba2\u5355", MerchantBossCashFlagEnum.CASH_FLAG_OUT_NO);
        if (null != context.getServiceMoney() && context.getServiceMoney().compareTo(BigDecimal.ZERO) > 0) {
            this.addCash(context, MerchantBossAccountCashTypeEnum.CASH_INCOME_CHARGE, context.getServiceMoney().multiply(new BigDecimal("-1")), "\u8ba2\u5355", MerchantBossCashFlagEnum.CASH_FLAG_OUT);
        }
        if (null != context.getPromotionMoney() && context.getPromotionMoney().compareTo(BigDecimal.ZERO) > 0) {
            this.addCash(context, MerchantBossAccountCashTypeEnum.CASH_DIVIDE, context.getPromotionMoney().multiply(new BigDecimal("-1")), "\u8ba2\u5355", MerchantBossCashFlagEnum.CASH_FLAG_OUT);
        }
    }

    @Override
    protected MerchantBossAccountActionEnum actionType() {
        return MerchantBossAccountActionEnum.ACCOUNT_ACTION_PAYMENT;
    }
}

