/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.handle.processor;

import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum;
import com.bxm.localnews.merchant.common.enums.MerchantBossCashFlagEnum;
import com.bxm.localnews.merchant.domain.MerchantAccountMapper;
import com.bxm.localnews.merchant.domain.MerchantCashFlowMapper;
import com.bxm.localnews.merchant.entity.MerchantAccountEntity;
import com.bxm.localnews.merchant.service.account.boss.handle.AbstractBossAccountHandle;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class WithdrawSuccessActionProcessor
extends AbstractBossAccountHandle {
    @Resource
    private MerchantAccountMapper merchantAccountMapper;
    @Resource
    private MerchantCashFlowMapper merchantCashFlowMapper;

    @Override
    protected Message checkLogic(BossAccountContext context) {
        if (Objects.isNull(context.getAmount())) {
            return Message.build((boolean)false);
        }
        MerchantAccountEntity entity = super.accountEntity(context);
        if (Objects.isNull(entity)) {
            return Message.build((boolean)false, (String)"\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (entity.getTotalCash().compareTo(context.getAmount()) < 0) {
            return Message.build((boolean)false, (String)"\u5185\u90e8\u9519\u8bef\uff1a\u5546\u5bb6\u603b\u8d44\u4ea7\u5f02\u5e38\uff01");
        }
        if (entity.getFreezeCash().compareTo(context.getAmount()) < 0) {
            return Message.build((boolean)false, (String)"\u5185\u90e8\u9519\u8bef\uff1a\u5546\u5bb6\u51bb\u7ed3\u4e2d\u91d1\u989d\u5f02\u5e38\uff01");
        }
        if (entity.getWithdrawingCash().compareTo(context.getAmount()) < 0) {
            return Message.build((boolean)false, (String)"\u5185\u90e8\u9519\u8bef\uff1a\u5546\u5bb6\u63d0\u73b0\u4e2d\u91d1\u989d\u5f02\u5e38\uff01");
        }
        return Message.build((boolean)true);
    }

    @Override
    protected void bossAccountChange(BossAccountContext context) {
        MerchantAccountEntity entity;
        int flag;
        int times = 0;
        do {
            entity = super.accountEntity(context);
            entity.setFreezeCash(entity.getFreezeCash().subtract(context.getAmount()));
            entity.setTotalCash(entity.getTotalCash().subtract(context.getAmount()));
            entity.setWithdrawingCash(entity.getWithdrawingCash().subtract(context.getAmount()));
            entity.setWithdrawedCash(entity.getWithdrawedCash().add(context.getAmount()));
            entity.setVersion(entity.getVersion());
        } while ((flag = this.merchantAccountMapper.updateByPrimaryKeySelective(entity)) <= 0 && ++times < 3);
        if (flag <= 0) {
            throw new BusinessException("\u8d26\u6237\u53d8\u66f4\u5931\u8d25\uff01");
        }
    }

    @Override
    protected void addAccountCash(BossAccountContext context) {
        this.merchantCashFlowMapper.update(context.getRelationId(), MerchantBossAccountCashTypeEnum.CASH_WITHDRAW_ING.name(), MerchantBossAccountCashTypeEnum.CASH_WITHDRAW_SUCCESS.name(), Integer.valueOf(MerchantBossCashFlagEnum.CASH_FLAG_OUT.getCode()), MerchantBossAccountCashTypeEnum.CASH_WITHDRAW_SUCCESS.getDesc());
    }

    @Override
    protected MerchantBossAccountActionEnum actionType() {
        return MerchantBossAccountActionEnum.ACCOUNT_ACTION_WITHDRAW_SUCCESS;
    }
}

