/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum;
import com.bxm.localnews.merchant.common.enums.RoleTypeEnum;
import com.bxm.localnews.merchant.domain.MerchantAccountMapper;
import com.bxm.localnews.merchant.domain.MerchantCashFlowMapper;
import com.bxm.localnews.merchant.dto.WithdrawAccountVO;
import com.bxm.localnews.merchant.dto.account.BossCashDTO;
import com.bxm.localnews.merchant.dto.account.BossTodayAccountDTO;
import com.bxm.localnews.merchant.dto.account.BossTotalAccountDTO;
import com.bxm.localnews.merchant.dto.account.BossWithdrawalInfoDTO;
import com.bxm.localnews.merchant.dto.account.MerchantOrderDetailDTO;
import com.bxm.localnews.merchant.entity.MerchantAccountEntity;
import com.bxm.localnews.merchant.entity.MerchantCashFlowEntity;
import com.bxm.localnews.merchant.integration.PaymentIntegrationService;
import com.bxm.localnews.merchant.param.account.BossCashParam;
import com.bxm.localnews.merchant.param.account.MerchantBossTodayCountParam;
import com.bxm.localnews.merchant.param.account.MerchantBossTotalAccountParam;
import com.bxm.localnews.merchant.service.account.boss.BossAccountCacheService;
import com.bxm.localnews.merchant.service.account.boss.BossAccountService;
import com.bxm.localnews.merchant.service.account.boss.impl.accountdetail.OrderManageProcess;
import com.bxm.localnews.merchant.service.members.MerchantMemberCounterService;
import com.bxm.localnews.merchant.service.promote.MerchantUserProAccountService;
import com.bxm.localnews.merchant.vo.MerchantUserAccountVO;
import com.bxm.localnews.merchants.dto.MerchantInfoDto;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.PageWarper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BossAccountServiceImpl
implements BossAccountService {
    private static final Logger log = LogManager.getLogger(BossAccountServiceImpl.class);
    private MerchantAccountMapper merchantAccountMapper;
    private RedisStringAdapter redisStringAdapter;
    private BossAccountCacheService bossAccountCacheService;
    private MerchantMemberCounterService merchantMemberCounterService;
    private MerchantUserProAccountService merchantUserProAccountService;
    private MerchantCashFlowMapper merchantCashFlowMapper;
    private PaymentIntegrationService paymentIntegrationService;
    private MerchantInfoFacadeService merchantInfoService;
    private OrderManageProcess orderManageProcess;
    private static int FROZEN_TYPE = 1;

    @Override
    public BossTodayAccountDTO accountToday(MerchantBossTodayCountParam param) {
        BossTodayAccountDTO result = new BossTodayAccountDTO();
        result.setTodayAmount(this.bossAccountCacheService.getAccountTodayCache(param.getMerchantId()).setScale(2, RoundingMode.HALF_UP));
        result.setTodayUV(this.merchantMemberCounterService.sizeClickCounter(null, param.getMerchantId(), RoleTypeEnum.MERCHANT.getType()));
        result.setTodayOrders(this.merchantMemberCounterService.sizeOrderCounter(null, param.getMerchantId(), RoleTypeEnum.MERCHANT.getType()));
        result.setPromoteMoney(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
        MerchantUserAccountVO merchantUserAccountVO = this.merchantUserProAccountService.getUserProAccount(param.getMerchantId());
        if (Objects.nonNull(merchantUserAccountVO)) {
            result.setPromoteMoney(merchantUserAccountVO.getAbleProCash().setScale(2, RoundingMode.HALF_UP));
        }
        return result;
    }

    @Override
    public BossTotalAccountDTO accountTotal(MerchantBossTotalAccountParam param) {
        log.debug("MerchantBossTotalAccountParam : {}", (Object)param);
        if (Objects.isNull(param.getMerchantId())) {
            return this.defaultAccount();
        }
        return this.getBossTotalAccount(param.getMerchantId());
    }

    private BossTotalAccountDTO getBossTotalAccount(Long merchantId) {
        BossTotalAccountDTO result = (BossTotalAccountDTO)this.redisStringAdapter.get(this.cacheKey(merchantId), BossTotalAccountDTO.class);
        if (Objects.isNull(result)) {
            MerchantAccountEntity entity = this.merchantAccountMapper.selectByMerchantId(merchantId);
            if (Objects.isNull(entity)) {
                return this.defaultAccount();
            }
            result = this.convert(entity);
            this.redisStringAdapter.set(this.cacheKey(merchantId), (Object)result);
        }
        return result;
    }

    @Override
    public PageWarper<BossCashDTO> accountCashFlows(BossCashParam param) {
        List merchantFlows = this.merchantCashFlowMapper.merchantFlows(param);
        if (CollectionUtils.isEmpty((Collection)merchantFlows)) {
            return new PageWarper();
        }
        List resultLists = merchantFlows.stream().map(item -> this.convert((MerchantCashFlowEntity)item, param)).collect(Collectors.toList());
        return new PageWarper(resultLists);
    }

    @Override
    public MerchantOrderDetailDTO getAccountDetailById(Long cashId, Integer requestCashType) {
        if (Objects.isNull(requestCashType)) {
            requestCashType = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug("cash : {}", (Object)cashId);
        }
        MerchantOrderDetailDTO orderDetailResult = new MerchantOrderDetailDTO();
        MerchantCashFlowEntity cashFlowEntity = this.merchantCashFlowMapper.selectByPrimaryKey(cashId);
        if (log.isDebugEnabled()) {
            log.debug("cashFlowEntity : {}", (Object)cashFlowEntity);
        }
        if (cashFlowEntity == null) {
            return orderDetailResult;
        }
        MerchantBossAccountCashTypeEnum cashType = MerchantBossAccountCashTypeEnum.valueOf((String)cashFlowEntity.getType());
        if (Objects.equals(cashFlowEntity.getType(), MerchantBossAccountCashTypeEnum.PLATFORM_SUBSIDY.name())) {
            orderDetailResult.setMoney(cashFlowEntity.getAmount().setScale(2, RoundingMode.HALF_DOWN));
            orderDetailResult.setGoodsName(cashFlowEntity.getRemark());
            orderDetailResult.setTransTime(cashFlowEntity.getCreateTime());
            orderDetailResult.setPayOrderNo(String.valueOf(cashFlowEntity.getRelationId()));
        } else if (Objects.equals(cashFlowEntity.getType(), MerchantBossAccountCashTypeEnum.REWARD_CASH_INCOME_CHARGE.name())) {
            orderDetailResult.setMoney(cashFlowEntity.getAmount().setScale(2, RoundingMode.HALF_DOWN));
            orderDetailResult.setTransTime(cashFlowEntity.getCreateTime());
        } else if (null != cashFlowEntity.getRelationId()) {
            orderDetailResult = this.orderManageProcess.getOrderDetail(cashFlowEntity.getType(), cashFlowEntity.getRelationId());
            orderDetailResult.setMoney(cashFlowEntity.getAmount());
            if (requestCashType == FROZEN_TYPE && cashFlowEntity.getType().equals(MerchantBossAccountCashTypeEnum.CASH_PAYMENT.name())) {
                orderDetailResult.setMoney(cashFlowEntity.getReceiveAmount().setScale(2, RoundingMode.HALF_DOWN));
            }
        }
        orderDetailResult.setStatus(Integer.valueOf(cashType.getCode()));
        return orderDetailResult;
    }

    @Override
    public BossWithdrawalInfoDTO withdrawInfoForAlipay(Long userId, Long merchantId) {
        log.debug("userId : {},merchantId : {}", (Object)userId, (Object)merchantId);
        if (Objects.isNull(userId) || Objects.isNull(merchantId)) {
            return null;
        }
        MerchantInfoDto merchantInfoDto = this.merchantInfoService.getMerchantInfoDetail(merchantId);
        if (Objects.isNull(merchantInfoDto)) {
            log.warn("\u83b7\u53d6\u5546\u5bb6: {} \u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f: {}", (Object)merchantId, (Object)merchantInfoDto);
            return null;
        }
        BossTotalAccountDTO account = this.getBossTotalAccount(merchantId);
        if (Objects.isNull(account)) {
            account = this.defaultAccount();
        }
        WithdrawAccountVO paymentInfo = this.paymentIntegrationService.getPaymentAccount(userId);
        BossWithdrawalInfoDTO result = new BossWithdrawalInfoDTO();
        result.setAmount(account.getActiveAmount().setScale(2, RoundingMode.HALF_UP));
        result.setAlipay(Objects.nonNull(paymentInfo) ? paymentInfo.getAccount() : null);
        result.setRealName(Objects.nonNull(paymentInfo) ? paymentInfo.getRealName() : null);
        result.setUserId(userId);
        result.setMobile(merchantInfoDto.getMobile());
        return result;
    }

    private BossCashDTO convert(MerchantCashFlowEntity entity, BossCashParam param) {
        BossCashDTO bossCashDTO = new BossCashDTO();
        bossCashDTO.setAmount(entity.getAmount().setScale(2, RoundingMode.HALF_UP));
        if (param.getCashType() == FROZEN_TYPE && entity.getType().equals(MerchantBossAccountCashTypeEnum.CASH_PAYMENT.name())) {
            bossCashDTO.setAmount(entity.getReceiveAmount().setScale(2, RoundingMode.HALF_UP));
        }
        bossCashDTO.setCashDesc(entity.getRemark());
        bossCashDTO.setGoodsName(entity.getGoodsName());
        bossCashDTO.setCashId(entity.getId());
        bossCashDTO.setType(entity.getType());
        bossCashDTO.setCreateTime(entity.getCreateTime());
        bossCashDTO.setRelationId(entity.getRelationId());
        return bossCashDTO;
    }

    private BossTotalAccountDTO convert(MerchantAccountEntity entity) {
        BossTotalAccountDTO bossTotalAccountDTO = new BossTotalAccountDTO();
        bossTotalAccountDTO.setActiveAmount(entity.getDrawableCash().setScale(2, RoundingMode.HALF_UP));
        bossTotalAccountDTO.setFrozenAmount(entity.getFreezeCash().setScale(2, RoundingMode.HALF_UP));
        bossTotalAccountDTO.setTotalAmount(entity.getTotalCash().setScale(2, RoundingMode.HALF_UP));
        bossTotalAccountDTO.setWithdrawalIngAmount(entity.getWithdrawingCash().setScale(2, RoundingMode.HALF_UP));
        bossTotalAccountDTO.setWithdrawedAmount(entity.getWithdrawedCash().setScale(2, RoundingMode.HALF_UP));
        return bossTotalAccountDTO;
    }

    private BossTotalAccountDTO defaultAccount() {
        BossTotalAccountDTO bossTotalAccountDTO = new BossTotalAccountDTO();
        bossTotalAccountDTO.setActiveAmount(new BigDecimal("0.00"));
        bossTotalAccountDTO.setFrozenAmount(new BigDecimal("0.00"));
        bossTotalAccountDTO.setTotalAmount(new BigDecimal("0.00"));
        bossTotalAccountDTO.setWithdrawalIngAmount(new BigDecimal("0.00"));
        return bossTotalAccountDTO;
    }

    private KeyGenerator cacheKey(Long merchantId) {
        return RedisConfig.MERCHANT_ACCOUNT_TOTAL.copy().appendKey((Object)merchantId);
    }

    public BossAccountServiceImpl(MerchantAccountMapper merchantAccountMapper, RedisStringAdapter redisStringAdapter, BossAccountCacheService bossAccountCacheService, MerchantMemberCounterService merchantMemberCounterService, MerchantUserProAccountService merchantUserProAccountService, MerchantCashFlowMapper merchantCashFlowMapper, PaymentIntegrationService paymentIntegrationService, MerchantInfoFacadeService merchantInfoService, OrderManageProcess orderManageProcess) {
        this.merchantAccountMapper = merchantAccountMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.bossAccountCacheService = bossAccountCacheService;
        this.merchantMemberCounterService = merchantMemberCounterService;
        this.merchantUserProAccountService = merchantUserProAccountService;
        this.merchantCashFlowMapper = merchantCashFlowMapper;
        this.paymentIntegrationService = paymentIntegrationService;
        this.merchantInfoService = merchantInfoService;
        this.orderManageProcess = orderManageProcess;
    }
}

