/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.boss.impl.accountdetail;

import com.bxm.localnews.merchant.dto.account.MerchantOrderDetailDTO;
import com.bxm.localnews.merchant.entity.OrderInfoDTO;
import com.bxm.localnews.merchant.integration.MarketIntegrationService;
import com.bxm.localnews.merchant.service.account.boss.impl.accountdetail.AbstractOrderDetail;
import java.math.BigDecimal;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MerchantOrderDetail
extends AbstractOrderDetail {
    @Autowired
    private MarketIntegrationService marketIntegrationService;

    @Override
    public MerchantOrderDetailDTO getDetailByRelationId(Long relationId) {
        MerchantOrderDetailDTO orderDetailResult = new MerchantOrderDetailDTO();
        OrderInfoDTO orderInfoDTO = this.marketIntegrationService.getSomeInfoById(relationId);
        orderDetailResult.setGoodsName(orderInfoDTO.getGoodsName());
        orderDetailResult.setPhone(orderInfoDTO.getOwnerUserPhone());
        orderDetailResult.setUserName(orderInfoDTO.getOwnerUserName());
        orderDetailResult.setPayOrderNo(orderInfoDTO.getOrderSn());
        orderDetailResult.setTransTime(orderInfoDTO.getCreateTime());
        if (Objects.equals(orderInfoDTO.getOrderStatus(), 7)) {
            orderDetailResult.setReceive(Integer.valueOf(1));
        } else {
            orderDetailResult.setReceive(Integer.valueOf(0));
        }
        if (Objects.nonNull(orderInfoDTO.getVipPurchaseCommission()) && !Objects.equals(orderInfoDTO.getVipPurchaseCommission().compareTo(BigDecimal.ZERO), 0)) {
            orderDetailResult.setVip(Integer.valueOf(1));
        } else {
            orderDetailResult.setVip(Integer.valueOf(0));
        }
        orderDetailResult.setStatus(orderInfoDTO.getOrderStatus());
        return orderDetailResult;
    }

    @Override
    Integer getType() {
        return 1;
    }
}

