/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.account.substract;

import com.bxm.localnews.merchant.common.enums.MerchantAccountTypeEnum;
import com.bxm.localnews.merchant.common.properties.MerchantProAccountProperties;
import com.bxm.localnews.merchant.dto.account.MerchantAccountInfoDTO;
import com.bxm.localnews.merchant.entity.MerchantUserPromotionAccountEntity;
import com.bxm.localnews.merchant.service.account.AbstractUserProAccount;
import com.bxm.localnews.merchant.service.promote.MerchantUserProAccountService;
import com.bxm.localnews.merchant.vo.MerchantUserAccountVO;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryException;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractSubstractProAccount
extends AbstractUserProAccount {
    private static final Logger log = LoggerFactory.getLogger(AbstractSubstractProAccount.class);
    @Autowired
    private MerchantUserProAccountService merchantUserProAccountService;
    @Autowired
    protected MerchantProAccountProperties merchantProAccountProperties;

    @Override
    protected Boolean checkAmount(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        this.setAmount(merchantAccountInfoDTO);
        if (merchantAccountInfoDTO.getAmount().compareTo(BigDecimal.ZERO) > 0) {
            merchantAccountInfoDTO.setAmount(merchantAccountInfoDTO.getAmount().multiply(new BigDecimal("-1")));
        }
        return true;
    }

    @Override
    protected Message preCheck(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        return Message.build((boolean)true);
    }

    @Override
    protected void changeAccount(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        if (this.subAccount(merchantAccountInfoDTO).booleanValue()) {
            return;
        }
        throw new RetryException("\u91d1\u989d\u6263\u9664\u5931\u8d25\uff0c\u8bf7\u6c42\u91cd\u8bd5");
    }

    private Boolean subAccount(MerchantAccountInfoDTO merchantAccountInfoDTO) {
        MerchantUserAccountVO userAccountVO = this.merchantUserProAccountService.getUserProAccount(merchantAccountInfoDTO.getMerchantId());
        MerchantUserPromotionAccountEntity promotionAccountEntity = new MerchantUserPromotionAccountEntity();
        promotionAccountEntity.setAblePromotionCash(merchantAccountInfoDTO.getAmount());
        promotionAccountEntity.setVersion(userAccountVO.getVersionProCash());
        promotionAccountEntity.setMerchantId(merchantAccountInfoDTO.getMerchantId());
        Integer value = this.merchantUserProAccountService.subProAccount(promotionAccountEntity);
        return value > 0;
    }

    @Override
    protected abstract MerchantAccountTypeEnum getType();

    protected abstract void setAmount(MerchantAccountInfoDTO var1);
}

