/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.merchant.common.enums.MerchantActionRecordTypeEnum;
import com.bxm.localnews.merchant.domain.MerchantContentRecordMapper;
import com.bxm.localnews.merchant.domain.MerchantMemberMapper;
import com.bxm.localnews.merchant.dto.MerchantCounterShareContentDTO;
import com.bxm.localnews.merchant.dto.MerchantMarketingDTO;
import com.bxm.localnews.merchant.dto.ShareContentDTO;
import com.bxm.localnews.merchant.entity.MerchantContentRecordEntity;
import com.bxm.localnews.merchant.facade.ForumPostFeignService;
import com.bxm.localnews.merchant.param.MerchantCounterClueParam;
import com.bxm.localnews.merchant.service.members.MerchantContentRecordService;
import com.bxm.localnews.merchant.vo.MerchantMemberVo;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantContentRecordServiceImpl
implements MerchantContentRecordService {
    @Resource
    private MerchantContentRecordMapper merchantContentRecordMapper;
    @Autowired
    private ForumPostFeignService forumPostFacadeService;
    @Resource
    private MerchantMemberMapper merchantMemberMapper;
    @Autowired
    private SequenceCreater sequenceCreater;

    @Override
    public int insert(MerchantContentRecordEntity contentRecordEntity) {
        if (null == contentRecordEntity.getId()) {
            contentRecordEntity.setId(this.sequenceCreater.nextLongId());
        }
        contentRecordEntity.setShareAmount(Long.valueOf(1L));
        contentRecordEntity.setViewAmount(Long.valueOf(0L));
        contentRecordEntity.setClickAmount(Long.valueOf(0L));
        contentRecordEntity.setCreateTime(new Date());
        return this.merchantContentRecordMapper.insert(contentRecordEntity);
    }

    @Override
    public int saveOrUpdate(MerchantContentRecordEntity contentRecordEntity) {
        MerchantContentRecordEntity recordEntity = this.merchantContentRecordMapper.selectByRelaIdBelonger(contentRecordEntity.getRelationId(), contentRecordEntity.getBelonger(), contentRecordEntity.getMerchantId());
        if (null == recordEntity) {
            return this.insert(contentRecordEntity);
        }
        return this.addCounterByType(contentRecordEntity.getRelationId(), contentRecordEntity.getBelonger(), contentRecordEntity.getMerchantId(), MerchantActionRecordTypeEnum.SHARE);
    }

    @Override
    public int addCounterByType(Long relationId, Long belonger, Long merchantId, MerchantActionRecordTypeEnum recordTypeEnum) {
        return this.merchantContentRecordMapper.addCounterByType(relationId, belonger, merchantId, recordTypeEnum.getType());
    }

    @Override
    public PageWarper<MerchantCounterShareContentDTO> getShareContentList(MerchantCounterClueParam merchantCounterClueParam) {
        return new PageWarper(this.merchantContentRecordMapper.getShareContentList(merchantCounterClueParam));
    }

    @Override
    public void updateStatus(Long msgId, Byte status) {
        this.merchantContentRecordMapper.updateStatusByRelationId(msgId, status);
    }

    @Override
    public PageWarper<MerchantMarketingDTO> getMarketingTrends(MerchantCounterClueParam merchantCounterClueParam) {
        PageWarper page = new PageWarper(this.merchantContentRecordMapper.getMarketingTrends(merchantCounterClueParam));
        return page;
    }

    @Override
    public Boolean updateRelationStatus(Long userId, Long merchantId, Byte status) {
        return this.merchantContentRecordMapper.updateRelationStatus(userId, merchantId, status) > 0;
    }

    @Override
    public List<MerchantMarketingDTO> getMarketingTrendsTopTen(MerchantCounterClueParam merchantCounterClueParam) {
        List listShare;
        List resultList = this.merchantContentRecordMapper.getMarketingTrendsTopTen(merchantCounterClueParam.getMerchantId());
        MerchantMemberVo merchantMemberVo = this.merchantMemberMapper.getBossByMerchantId(merchantCounterClueParam.getMerchantId());
        Long bossId = merchantMemberVo.getUserId();
        if (resultList.size() > 0) {
            resultList.forEach(merchantMarketingDTO -> {
                if (Objects.equals(merchantMarketingDTO.getUserId(), bossId)) {
                    merchantMarketingDTO.setTag(Integer.valueOf(2));
                }
            });
        }
        if (resultList.size() < 10 && StringUtils.isNotEmpty((CharSequence)merchantCounterClueParam.getAreaCode()) && !Objects.isNull(listShare = (List)this.forumPostFacadeService.getTopPost(merchantCounterClueParam.getAreaCode()).getBody()) && listShare.size() > 0) {
            listShare.forEach(contentDTO -> resultList.add(this.convertShareContent((ShareContentDTO)contentDTO)));
        }
        return resultList;
    }

    private MerchantMarketingDTO convertShareContent(ShareContentDTO contentDTO) {
        MerchantMarketingDTO marketingDTO = new MerchantMarketingDTO();
        marketingDTO.setTag(Integer.valueOf(1));
        marketingDTO.setTitle(contentDTO.getTitle());
        marketingDTO.setRelationId(contentDTO.getId());
        marketingDTO.setRelationType(Objects.equals(contentDTO.getOrigin(), "1") ? InviteTypeEnum.FORUM.name() : InviteTypeEnum.NEWS.name());
        return marketingDTO;
    }
}

