/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.domain.MerchantNotifactionMapper;
import com.bxm.localnews.merchant.dto.RadioMessageDto;
import com.bxm.localnews.merchant.service.MerchantMessageService;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MerchantMessageImpl
implements MerchantMessageService {
    private MerchantNotifactionMapper merchantNotifactionMapper;
    private RedisStringAdapter redisStringAdapter;
    private final MerchantInfoFacadeService merchantInfoDbService;

    @Override
    public Message getRadioMessage(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantId);
        if (merchantInfo == null) {
            return Message.build((boolean)false, (String)"\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4fe1\u606f");
        }
        ArrayList<RadioMessageDto> radioMessageDtoList = new ArrayList<RadioMessageDto>();
        String string = this.redisStringAdapter.getString(RedisConfig.MERCHANT_MESSAGE_KEY.copy().appendKey((Object)merchantId));
        if (StringUtils.isBlank((String)string)) {
            RadioMessageDto radioMessageDto = new RadioMessageDto();
            radioMessageDto.setMessage("\u60a8\u8fd8\u6ca1\u6709\u5458\u5de5\uff0c\u5feb\u53bb\u7ed1\u5b9a\u5458\u5de5\u5427");
            radioMessageDtoList.add(radioMessageDto);
            return Message.build((boolean)true).addParam("radioMessageDtoList", radioMessageDtoList);
        }
        List result = this.merchantNotifactionMapper.queryByMerchantId(merchantId);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            result.forEach(merchantNotifactionVo -> {
                RadioMessageDto radioMessageDto = new RadioMessageDto();
                radioMessageDto.setMessage(merchantNotifactionVo.getMessage());
                radioMessageDtoList.add(radioMessageDto);
            });
        }
        RadioMessageDto radioMessageDto = new RadioMessageDto();
        radioMessageDto.setMessage("\u5206\u4eab\u5e16\u5b50\uff0c\u4f1a\u9644\u5e26\u60a8\u5e7f\u544a\uff0c\u8d76\u5feb\u53bb\u5206\u4eab\u5427");
        radioMessageDtoList.add(0, radioMessageDto);
        return Message.build((boolean)true).addParam("radioMessageDtoList", radioMessageDtoList);
    }

    public MerchantMessageImpl(MerchantNotifactionMapper merchantNotifactionMapper, RedisStringAdapter redisStringAdapter, MerchantInfoFacadeService merchantInfoDbService) {
        this.merchantNotifactionMapper = merchantNotifactionMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.merchantInfoDbService = merchantInfoDbService;
    }
}

