/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.merchant.common.enums.MerchantOrderStateEnum;
import com.bxm.localnews.merchant.config.MerchantOrderProperties;
import com.bxm.localnews.merchant.domain.MerchantOpenvipOrderMapper;
import com.bxm.localnews.merchant.domain.MerchantOrderInfoMapper;
import com.bxm.localnews.merchant.dto.MerchantManageOrderInfoDTO;
import com.bxm.localnews.merchant.dto.MerchantOpenVipDTO;
import com.bxm.localnews.merchant.dto.MerchantOperatorOrderDTO;
import com.bxm.localnews.merchant.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.merchant.dto.PromoteMoneyDTO;
import com.bxm.localnews.merchant.dto.order.MerchantBuyPromoteDTO;
import com.bxm.localnews.merchant.dto.order.PaymentOrderDTO;
import com.bxm.localnews.merchant.entity.MerchantOpenvipOrderEntity;
import com.bxm.localnews.merchant.entity.MerchantOrderInfoEntity;
import com.bxm.localnews.merchant.entity.OrderInfoDTO;
import com.bxm.localnews.merchant.events.GoodsOrderPaymentEvent;
import com.bxm.localnews.merchant.integration.MarketIntegrationService;
import com.bxm.localnews.merchant.integration.PaymentIntegrationService;
import com.bxm.localnews.merchant.param.MerchantH5OrderParam;
import com.bxm.localnews.merchant.param.MerchantManageOrderParam;
import com.bxm.localnews.merchant.param.MerchantOpenVipParam;
import com.bxm.localnews.merchant.param.MerchantOperatorOrderParam;
import com.bxm.localnews.merchant.param.MerchantOrderInfoParam;
import com.bxm.localnews.merchant.param.order.MerchantBuyOrderParam;
import com.bxm.localnews.merchant.param.order.UserOrderParam;
import com.bxm.localnews.merchant.service.InterestsService;
import com.bxm.localnews.merchant.service.members.MerchantMemberCounterService;
import com.bxm.localnews.merchant.service.order.MerchantOrderInfoService;
import com.bxm.localnews.merchant.service.promote.PromoteService;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class MerchantOrderInfoServiceImpl
implements MerchantOrderInfoService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MerchantOrderInfoServiceImpl.class);
    @Autowired
    private SequenceCreater sequenceCreater;
    @Resource
    private MerchantOrderInfoMapper merchantOrderInfoMapper;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private PromoteService promoteService;
    @Resource
    private MerchantOpenvipOrderMapper merchantOpenvipOrderMapper;
    @Autowired
    private PaymentIntegrationService paymentIntegrationService;
    @Autowired
    private MarketIntegrationService marketIntegrationService;
    @Autowired
    private MerchantOrderProperties merchantOrderProperties;
    @Autowired
    private MerchantMemberCounterService merchantMemberCounterService;
    private ApplicationContext applicationContext;

    @Override
    public int insertBySelect(MerchantOrderInfoParam merchantOrderInfoParam) {
        MerchantOrderInfoEntity merchantOrderInfoEntity = new MerchantOrderInfoEntity();
        BeanUtils.copyProperties((Object)merchantOrderInfoParam, (Object)merchantOrderInfoEntity);
        if (null == merchantOrderInfoEntity.getId()) {
            merchantOrderInfoEntity.setId(this.sequenceCreater.nextLongId());
        }
        return this.merchantOrderInfoMapper.insertSelective(merchantOrderInfoEntity);
    }

    @Override
    public int updateByOrderNoSelect(MerchantOrderInfoParam merchantOrderInfoParam) {
        if (null == merchantOrderInfoParam) {
            log.error("\u66f4\u65b0\u7528\u6237\u8ba2\u5355\u4fe1\u606f\u65f6\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3anull");
            return 0;
        }
        log.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001,\u66f4\u65b0\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)merchantOrderInfoParam));
        MerchantOrderInfoEntity merchantOrderInfoEntity = new MerchantOrderInfoEntity();
        BeanUtils.copyProperties((Object)merchantOrderInfoParam, (Object)merchantOrderInfoEntity);
        if (null == merchantOrderInfoEntity.getOrderNo()) {
            return 0;
        }
        MerchantOrderInfoEntity orderInfo = this.merchantOrderInfoMapper.selectByOrderNo(merchantOrderInfoParam.getOrderNo());
        if (Objects.equals(MerchantOrderStateEnum.PAY_SUCCESS.getState(), merchantOrderInfoParam.getState())) {
            log.info("\u5546\u54c1\u8ba2\u5355\u4ed8\u6b3e\u5b8c\u6210\uff0c\u89e6\u53d1\u76f8\u5173\u4e8b\u4ef6\uff0c\u66f4\u65b0\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)merchantOrderInfoParam));
            this.applicationContext.publishEvent((Object)GoodsOrderPaymentEvent.builder().goodsId(orderInfo.getGoodsId()).userId(orderInfo.getUserId()).orderNo(merchantOrderInfoParam.getOrderNo()).build());
            this.merchantMemberCounterService.addOrderCounter(null, orderInfo.getMerchantId(), 1);
        }
        if (Objects.equals(MerchantOrderStateEnum.REFUND_AUDITING.getState(), merchantOrderInfoParam.getState())) {
            merchantOrderInfoEntity.setRefundTime(new Date());
        }
        return this.merchantOrderInfoMapper.updateByOrderNoSelective(merchantOrderInfoEntity);
    }

    @Override
    public Boolean operatorOrder(MerchantOperatorOrderParam merchantOperatorOrderParam) {
        return this.marketIntegrationService.operatorOrder(merchantOperatorOrderParam.getOrderNo(), merchantOperatorOrderParam.getState());
    }

    @Override
    public MerchantBuyPromoteDTO createMerchantOrder(MerchantBuyOrderParam param) {
        MerchantBuyPromoteDTO result = new MerchantBuyPromoteDTO();
        if (Objects.equals(param.getUsePromotion(), AppConst.ENABLE)) {
            MerchantOpenVipDTO openVipDTO = this.openMerchantVip(param.getMerchantId(), param.getUserId());
            if (Objects.equals(openVipDTO.getMoney().compareTo(BigDecimal.ZERO), 0)) {
                result.setState(Integer.valueOf(1));
                return result;
            }
            param.setAmount(openVipDTO.getMoney());
            param.setOrderSn(openVipDTO.getOrderNo());
        } else {
            PromoteMoneyDTO promoteMoneyDTO = this.promoteService.getPromoteMoney(param.getUserId(), null);
            param.setAmount(promoteMoneyDTO.getTotalMoney());
            promoteMoneyDTO.setMoney(promoteMoneyDTO.getTotalMoney());
            promoteMoneyDTO.setPromoteMoney(BigDecimal.ZERO);
            MerchantOpenvipOrderEntity openvipOrderEntity = this.addOpenVipInfo(promoteMoneyDTO);
            if (null != openvipOrderEntity) {
                param.setOrderSn(openvipOrderEntity.getOrderNo());
            }
        }
        UserOrderParam orderParam = new UserOrderParam();
        BeanUtils.copyProperties((Object)param, (Object)orderParam);
        orderParam.setPaymentTitle("\u4e07\u4e8b\u901a\u5546\u5bb6\u4f1a\u5458");
        PaymentOrderDTO paymentOrderDTO = this.paymentIntegrationService.orderCreate(orderParam);
        BeanUtils.copyProperties((Object)paymentOrderDTO, (Object)result);
        result.setState(Integer.valueOf(0));
        return result;
    }

    @Override
    public MerchantOperatorOrderDTO verification(MerchantOperatorOrderParam merchantOperatorOrderParam) {
        MerchantOperatorOrderDTO operatorOrderDTO = new MerchantOperatorOrderDTO();
        Integer res = this.marketIntegrationService.verificationOrder(merchantOperatorOrderParam.getVerificationCode(), merchantOperatorOrderParam.getMerchantId());
        operatorOrderDTO.setState(res);
        return operatorOrderDTO;
    }

    @Override
    public Boolean paySuccessCallback(String orderNo) {
        MerchantOpenvipOrderEntity openvipOrderEntity = this.merchantOpenvipOrderMapper.getByOrderNo(orderNo);
        if (null != openvipOrderEntity && Objects.equals(openvipOrderEntity.getStatus(), AppConst.DISALBE)) {
            PromoteMoneyDTO promoteMoneyDTO = new PromoteMoneyDTO();
            promoteMoneyDTO.setMoney(openvipOrderEntity.getPayAmt());
            promoteMoneyDTO.setPromoteMoney(openvipOrderEntity.getDeductionAmt());
            promoteMoneyDTO.setMerchantId(openvipOrderEntity.getMerchantId());
            Boolean flag = this.openVipMoney(promoteMoneyDTO);
            this.merchantOpenvipOrderMapper.updateStatusById(openvipOrderEntity.getId(), AppConst.ENABLE);
            return flag;
        }
        return false;
    }

    @Override
    public PageWarper<MerchantOrderInfoDTO> getPageList(MerchantH5OrderParam merchantH5OrderParam) {
        PageWarper pageWarderList = new PageWarper(this.merchantOrderInfoMapper.getListOrder(merchantH5OrderParam));
        PageWarper resultPage = new PageWarper();
        BeanUtils.copyProperties((Object)pageWarderList, (Object)resultPage);
        resultPage.setList(pageWarderList.getList().stream().map(this::convertToDto).collect(Collectors.toList()));
        return resultPage;
    }

    @Override
    public PageWarper<MerchantManageOrderInfoDTO> getManagePageListOrder(MerchantManageOrderParam manageOrderParam) {
        PageWarper pageWarderList = new PageWarper(this.merchantOrderInfoMapper.getManagePageListOrder(manageOrderParam));
        PageWarper resultPage = new PageWarper();
        BeanUtils.copyProperties((Object)pageWarderList, (Object)resultPage);
        resultPage.setList(pageWarderList.getList().stream().map(this::convertToManageDto).collect(Collectors.toList()));
        return resultPage;
    }

    @Override
    public MerchantOpenVipDTO openMerchantVip(Long merchantId, Long userId) {
        MerchantOpenVipDTO openVipDTO = new MerchantOpenVipDTO();
        PromoteMoneyDTO promoteMoneyDTO = this.promoteService.getPromoteMoney(userId, null);
        if (Objects.equals(promoteMoneyDTO.getMoney().compareTo(BigDecimal.ZERO), 0)) {
            this.openVipMoney(promoteMoneyDTO);
            openVipDTO.setMoney(BigDecimal.ZERO);
        } else {
            promoteMoneyDTO = this.promoteService.getPromoteMoney(userId, null);
            MerchantOpenvipOrderEntity openvipOrderEntity = this.addOpenVipInfo(promoteMoneyDTO);
            openVipDTO.setMoney(promoteMoneyDTO.getMoney());
            openVipDTO.setOrderNo(openvipOrderEntity.getOrderNo());
        }
        return openVipDTO;
    }

    private Boolean openVipMoney(PromoteMoneyDTO promoteMoneyDTO) {
        MerchantOpenVipParam openVipParam = new MerchantOpenVipParam();
        openVipParam.setPayMoney(String.valueOf(promoteMoneyDTO.getMoney()));
        openVipParam.setId(promoteMoneyDTO.getMerchantId());
        openVipParam.setDeductionMoney(String.valueOf(promoteMoneyDTO.getPromoteMoney()));
        openVipParam.setInterestsType(Integer.valueOf(0));
        openVipParam.setOpenType(Integer.valueOf(0));
        return this.interestsService.openVip(openVipParam, 1);
    }

    private MerchantOpenvipOrderEntity addOpenVipInfo(PromoteMoneyDTO promoteMoneyDTO) {
        MerchantOpenvipOrderEntity openvipOrderEntity = new MerchantOpenvipOrderEntity();
        openvipOrderEntity.setCreateTime(new Date());
        openvipOrderEntity.setMerchantId(promoteMoneyDTO.getMerchantId());
        openvipOrderEntity.setDeductionAmt(promoteMoneyDTO.getPromoteMoney());
        openvipOrderEntity.setPrerogativeType(Integer.valueOf(promoteMoneyDTO.getOpenType().intValue()));
        openvipOrderEntity.setPayAmt(promoteMoneyDTO.getMoney());
        openvipOrderEntity.setStatus(AppConst.DISALBE);
        openvipOrderEntity.setId(this.sequenceCreater.nextLongId());
        openvipOrderEntity.setOrderNo(NidGeneratorUtil.getOrderNo((String)""));
        this.merchantOpenvipOrderMapper.insert(openvipOrderEntity);
        return openvipOrderEntity;
    }

    private MerchantOrderInfoDTO convertToDto(MerchantOrderInfoEntity entity) {
        OrderInfoDTO detailByOrderNo = this.marketIntegrationService.getDetailByOrderNo(entity.getOrderNo());
        MerchantOrderInfoDTO orderInfoDTO = MerchantOrderInfoDTO.builder().goodsId(entity.getGoodsId()).goodsImg(entity.getGoodsImg()).goodsName(entity.getGoodsName()).orderNo(entity.getOrderNo()).userName(entity.getUserName()).userPhone(entity.getUserPhone()).dateTime(entity.getCreateTime()).orderMoney(detailByOrderNo.getPayPrice()).num(entity.getGoodsNum()).userPayMoney(detailByOrderNo.getUserActualPayPrice()).coupon(detailByOrderNo.getCoupon()).couponDesc(detailByOrderNo.getCouponDesc()).build();
        if (Objects.equals(entity.getState(), MerchantOrderStateEnum.REFUND_AUDITING.getState())) {
            long leftTime = 0L;
            if (Objects.nonNull(entity.getRefundTime())) {
                leftTime = DateUtils.getDiffSeconed((Date)new Date(), (Date)entity.getRefundTime(), (boolean)true);
                leftTime = (long)this.merchantOrderProperties.getRefundMaxScened().intValue() - leftTime;
                if (leftTime < 0L) {
                    leftTime = 0L;
                }
            } else {
                log.warn("\u8ba2\u5355: {}\u7684\u9000\u6b3e\u65f6\u95f4\u4e3a\u7a7a \u65e0\u6cd5\u8ba1\u7b97\u5269\u4f59\u5904\u7406\u65f6\u95f4", (Object)entity.getOrderNo());
            }
            orderInfoDTO.setLeftTime(Long.valueOf(leftTime));
        }
        if (Objects.equals(entity.getState(), MerchantOrderStateEnum.PAY_SUCCESS.getState())) {
            orderInfoDTO.setState(Integer.valueOf(0));
        } else if (Objects.equals(entity.getState(), MerchantOrderStateEnum.WAIT_PAY.getState())) {
            orderInfoDTO.setState(Integer.valueOf(1));
        } else if (Objects.equals(entity.getState(), MerchantOrderStateEnum.REFUND_AUDITING.getState())) {
            orderInfoDTO.setState(Integer.valueOf(2));
        } else if (Objects.equals(entity.getState(), MerchantOrderStateEnum.VERIFICATION.getState())) {
            orderInfoDTO.setState(Integer.valueOf(3));
        } else if (Objects.equals(entity.getState(), MerchantOrderStateEnum.TIME_OUT_PAY.getState())) {
            orderInfoDTO.setState(Integer.valueOf(4));
        } else if (Objects.equals(entity.getState(), MerchantOrderStateEnum.REFUND_FAIL.getState())) {
            orderInfoDTO.setState(Integer.valueOf(5));
        } else if (Objects.equals(entity.getState(), MerchantOrderStateEnum.REFUND_SUCCESS.getState())) {
            orderInfoDTO.setState(Integer.valueOf(6));
        }
        if (Objects.nonNull(detailByOrderNo.getUserActualPayPrice()) && detailByOrderNo.getUserActualPayPrice().compareTo(BigDecimal.ZERO) == 0 && Objects.nonNull(detailByOrderNo.getCoupon()) && detailByOrderNo.getPayPrice().compareTo(detailByOrderNo.getCoupon()) < 0) {
            orderInfoDTO.setCoupon(detailByOrderNo.getPayPrice());
        }
        return orderInfoDTO;
    }

    private MerchantManageOrderInfoDTO convertToManageDto(MerchantOrderInfoEntity entity) {
        MerchantManageOrderInfoDTO orderInfoDTO = MerchantManageOrderInfoDTO.builder().goodsName(entity.getGoodsName()).orderNo(entity.getOrderNo()).userName(entity.getUserName()).userPhone(entity.getUserPhone()).dateTime(entity.getCreateTime()).orderMoney(entity.getReceiveMoney()).merchantName(entity.getMerchantName()).state(entity.getState()).payTime(entity.getCreateTime()).num(Integer.valueOf(entity.getGoodsNum().intValue())).build();
        return orderInfoDTO;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

